/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.Paths;
import de.flapdoodle.embed.mongo.config.DownloadConfigBuilder;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.store.ArtifactStoreBuilder;
import de.flapdoodle.embed.process.store.IArtifactStore;

public class ArtifactStores {
    private ArtifactStores() {
    }

    public static IArtifactStore defaultArtifactStore() {
        return ArtifactStores.artifactStore(Command.MongoD);
    }

    public static IArtifactStore mongoSArtifactStore() {
        return ArtifactStores.artifactStore(Command.MongoS);
    }

    private static IArtifactStore artifactStore(Command command) {
        return ArtifactStores.builder(command).build();
    }

    public static ArtifactStoreBuilder builder(Command command) {
        return ArtifactStores.defaultBuilder().download(new DownloadConfigBuilder().defaults().packageResolver(new Paths(command)).build());
    }

    public static ArtifactStoreBuilder defaultBuilder() {
        return new ArtifactStoreBuilder().tempDir(new PropertyOrPlatformTempDir()).executableNaming(new UUIDTempNaming());
    }
}

