/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongoConfig;
import de.flapdoodle.embed.mongo.config.MongoCmdOptionsBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.IProperty;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.ISupportConfig;
import java.io.IOException;
import java.net.UnknownHostException;

public abstract class AbstractMongoConfigBuilder<T extends IMongoConfig>
extends AbstractBuilder<T> {
    protected static final TypedProperty<IFeatureAwareVersion> VERSION = TypedProperty.with("Version", IFeatureAwareVersion.class);
    protected static final TypedProperty<Timeout> TIMEOUT = TypedProperty.with("Timeout", Timeout.class);
    protected static final TypedProperty<Net> NET = TypedProperty.with("Net", Net.class);
    protected static final TypedProperty<IMongoCmdOptions> CMD_OPTIONS = TypedProperty.with("CmdOptions", IMongoCmdOptions.class);
    protected static final TypedProperty<String> PID_FILE = TypedProperty.with("PidFile", String.class);
    protected static final TypedProperty<String> USERNAME = TypedProperty.with("UserName", String.class);
    protected static final TypedProperty<String> PASSWORD = TypedProperty.with("Password", String.class);
    protected static final TypedProperty<String> DBNAME = TypedProperty.with("DbName", String.class);

    public AbstractMongoConfigBuilder() throws UnknownHostException, IOException {
        this.timeout().setDefault(new Timeout());
        this.net().setDefault(new Net());
        this.cmdOptions().setDefault(new MongoCmdOptionsBuilder().build());
        this.username().setDefault("");
        this.password().setDefault("");
        this.dbName().setDefault("");
    }

    protected IProperty<IFeatureAwareVersion> version() {
        return this.property(VERSION);
    }

    protected IProperty<Timeout> timeout() {
        return this.property(TIMEOUT);
    }

    protected IProperty<String> username() {
        return this.property(USERNAME);
    }

    protected IProperty<String> password() {
        return this.property(PASSWORD);
    }

    protected IProperty<String> dbName() {
        return this.property(DBNAME);
    }

    protected IProperty<Net> net() {
        return this.property(NET);
    }

    protected IProperty<IMongoCmdOptions> cmdOptions() {
        return this.property(CMD_OPTIONS);
    }

    protected IProperty<String> pidFile() {
        return this.property(PID_FILE);
    }

    static class ImmutableMongoConfig
    implements IMongoConfig {
        private final ISupportConfig _supportConfig;
        private final IFeatureAwareVersion _version;
        private final Timeout _timeout;
        private final Net _net;
        private final IMongoCmdOptions _cmdOptions;
        private final String _pidFile;
        private final String _userName;
        private final String _password;

        public ImmutableMongoConfig(ISupportConfig supportConfig, IFeatureAwareVersion version, Net net, String userName, String password, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile) {
            this._supportConfig = supportConfig;
            this._version = version;
            this._net = net;
            this._timeout = timeout;
            this._cmdOptions = cmdOptions;
            this._pidFile = pidFile;
            this._userName = userName;
            this._password = password;
        }

        @Override
        public IFeatureAwareVersion version() {
            return this._version;
        }

        @Override
        public Timeout timeout() {
            return this._timeout;
        }

        @Override
        public Net net() {
            return this._net;
        }

        @Override
        public IMongoCmdOptions cmdOptions() {
            return this._cmdOptions;
        }

        @Override
        public String password() {
            return this._password;
        }

        @Override
        public String userName() {
            return this._userName;
        }

        @Override
        public String pidFile() {
            return this._pidFile;
        }

        @Override
        public ISupportConfig supportConfig() {
            return this._supportConfig;
        }
    }
}

