/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.handler.EntityAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.crud.ZCRMTag;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TagAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private ZCRMModule module;

    private TagAPIHandler(ZCRMModule zcrmModule) {
        this.module = zcrmModule;
    }

    private TagAPIHandler() {
    }

    public static TagAPIHandler getInstance(ZCRMModule zcrmModule) {
        return new TagAPIHandler(zcrmModule);
    }

    public static TagAPIHandler getInstance() {
        return new TagAPIHandler();
    }

    public BulkAPIResponse getTags() throws ZCRMException {
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/tags";
            this.requestQueryParams.put("module", this.module.getApiName());
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMTag> tags = new ArrayList<ZCRMTag>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray tagsArray = responseJSON.optJSONArray(this.jsonRootKey, new JSONArray());
            for (int index = 0; index < tagsArray.length(); ++index) {
                JSONObject tagDetails = tagsArray.getJSONObject(index);
                ZCRMTag tag = ZCRMTag.getInstance(Long.parseLong(tagDetails.getString("id")));
                this.setTagProperties(tag, tagDetails);
                tags.add(tag);
            }
            response.setData(tags);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getTagCount(long tagId) throws ZCRMException {
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/tags/" + tagId + "/actions/records_count";
            this.requestQueryParams.put("module", this.module.getApiName());
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject tagDetails = response.getResponseJSON();
            ZCRMTag tag = ZCRMTag.getInstance(tagId);
            this.setTagProperties(tag, tagDetails);
            response.setData(tag);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse createTags(List<ZCRMTag> tags) throws ZCRMException {
        if (tags.size() > 50) {
            throw new ZCRMException("Cannot process more than 50 tags at a time.");
        }
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = "settings/tags";
            this.requestQueryParams.put("module", this.module.getApiName());
            JSONObject requestBodyObject = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMTag tag : tags) {
                if (tag.getId() == null || tag.getId() == 0L) {
                    dataArray.put(this.getZCRMTagAsJSON(tag));
                    continue;
                }
                throw new ZCRMException("Tag ID MUST be null for CreateTags operation.");
            }
            requestBodyObject.put("tags", dataArray);
            this.requestBody = requestBodyObject;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMTag> createtags = new ArrayList<ZCRMTag>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject tagDetails = responseData.getJSONObject("details");
                    ZCRMTag newTag = tags.get(i);
                    this.setTagProperties(newTag, tagDetails);
                    createtags.add(newTag);
                    entResponse.setData(newTag);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(createtags);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse updateTags(List<ZCRMTag> tags) throws ZCRMException {
        if (tags.size() > 50) {
            throw new ZCRMException("Cannot process more than 50 tags at a time.");
        }
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = "settings/tags";
            this.requestQueryParams.put("module", this.module.getApiName());
            JSONObject requestBodyObject = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMTag tag : tags) {
                dataArray.put(this.getZCRMTagAsJSON(tag));
            }
            requestBodyObject.put("tags", dataArray);
            this.requestBody = requestBodyObject;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMTag> updatetags = new ArrayList<ZCRMTag>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject tagDetails = responseData.getJSONObject("details");
                    ZCRMTag updatedTag = tags.get(i);
                    this.setTagProperties(updatedTag, tagDetails);
                    updatetags.add(updatedTag);
                    entResponse.setData(updatedTag);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(updatetags);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse delete(long tagid) throws ZCRMException {
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.DELETE;
            this.urlPath = "settings/tags/" + tagid;
            return APIRequest.getInstance(this).getAPIResponse();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse merge(long tagId, long mergetagId) throws ZCRMException {
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = "settings/tags/" + mergetagId + "/actions/merge";
            JSONObject requestBodyObject = new JSONObject();
            JSONArray dataArray = new JSONArray();
            JSONObject TagJSON = new JSONObject();
            TagJSON.put("conflict_id", tagId);
            dataArray.put(TagJSON);
            requestBodyObject.put("tags", dataArray);
            this.requestBody = requestBodyObject;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject tagDetails = responseData.getJSONObject("details");
            ZCRMTag mergetag = ZCRMTag.getInstance(Long.parseLong(tagDetails.getString("id")));
            this.setTagProperties(mergetag, tagDetails);
            response.setData(mergetag);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse update(ZCRMTag tag) throws ZCRMException {
        try {
            this.jsonRootKey = "tags";
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = "settings/tags/" + tag.getId();
            this.requestQueryParams.put("module", tag.getModuleAPIName());
            JSONObject requestBodyObject = new JSONObject();
            JSONArray dataArray = new JSONArray();
            JSONObject TagJSON = new JSONObject();
            TagJSON.put("name", tag.getName());
            dataArray.put(TagJSON);
            requestBodyObject.put("tags", dataArray);
            this.requestBody = requestBodyObject;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject tagDetails = responseData.getJSONObject("details");
            ZCRMTag updatetag = tag;
            this.setTagProperties(updatetag, tagDetails);
            response.setData(updatetag);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse addTags(ZCRMRecord record, List<String> tagNames) throws ZCRMException {
        if (tagNames.size() > 10) {
            throw new ZCRMException("Cannot process more than 10 tags at a time.");
        }
        try {
            this.jsonRootKey = "data";
            String tagname = "";
            this.requestMethod = APIConstants.RequestMethod.POST;
            for (String name : tagNames) {
                tagname = tagname + name + ",";
            }
            this.urlPath = "" + record.getModuleAPIName() + "/" + record.getEntityId() + "/actions/add_tags";
            this.requestQueryParams.put("tag_names", tagname);
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray("data");
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject recordDetails = responseData.getJSONObject("details");
            ZCRMRecord recordIns = record;
            EntityAPIHandler.getInstance(recordIns).setRecordProperties(recordDetails);
            response.setData(recordIns);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse addTagsToRecords(List<Long> recordId, List<String> tagNames) throws ZCRMException {
        if (tagNames.size() > 10) {
            throw new ZCRMException("Cannot process more than 10 tags at a time.");
        }
        if (recordId.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.jsonRootKey = "data";
            String tagname = "";
            String recordid = "";
            this.requestMethod = APIConstants.RequestMethod.POST;
            Iterator<Object> i$ = recordId.iterator();
            while (i$.hasNext()) {
                long id = i$.next();
                recordid = recordid + id + ",";
            }
            for (String tag : tagNames) {
                tagname = tagname + tag + ",";
            }
            this.urlPath = "" + this.module.getApiName() + "/actions/add_tags";
            this.requestQueryParams.put("ids", recordid);
            this.requestQueryParams.put("tag_names", tagname);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> recordList = new ArrayList<ZCRMRecord>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject recordDetails = responseData.getJSONObject("details");
                    ZCRMRecord addTag = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordDetails.getString("id")));
                    EntityAPIHandler.getInstance(addTag).setRecordProperties(recordDetails);
                    recordList.add(addTag);
                    entResponse.setData(addTag);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(recordList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse removeTags(ZCRMRecord record, List<String> tagNames) throws ZCRMException {
        if (tagNames.size() > 10) {
            throw new ZCRMException("Cannot process more than 10 tags at a time.");
        }
        try {
            this.jsonRootKey = "data";
            String tagname = "";
            this.requestMethod = APIConstants.RequestMethod.POST;
            for (String name : tagNames) {
                tagname = tagname + name + ",";
            }
            this.urlPath = "" + record.getModuleAPIName() + "/" + record.getEntityId() + "/actions/remove_tags";
            this.requestQueryParams.put("tag_names", tagname);
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray("data");
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject recordDetails = responseData.getJSONObject("details");
            ZCRMRecord recordIns = record;
            EntityAPIHandler.getInstance(recordIns).setRecordProperties(recordDetails);
            response.setData(recordIns);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse removeTagsFromRecords(List<Long> recordId, List<String> tagNames) throws ZCRMException {
        if (tagNames.size() > 10) {
            throw new ZCRMException("Cannot process more than 10 tags at a time.");
        }
        if (recordId.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.jsonRootKey = "data";
            String tagname = "";
            String recordid = "";
            this.requestMethod = APIConstants.RequestMethod.POST;
            Iterator<Object> i$ = recordId.iterator();
            while (i$.hasNext()) {
                long id = i$.next();
                recordid = recordid + id + ",";
            }
            for (String tag : tagNames) {
                tagname = tagname + tag + ",";
            }
            this.urlPath = "" + this.module.getApiName() + "/actions/remove_tags";
            this.requestQueryParams.put("ids", recordid);
            this.requestQueryParams.put("tag_names", tagname);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> recordList = new ArrayList<ZCRMRecord>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject recordDetails = responseData.getJSONObject("details");
                    ZCRMRecord recordIns = ZCRMRecord.getInstance(this.module.getApiName(), Long.parseLong(recordDetails.getString("id")));
                    EntityAPIHandler.getInstance(recordIns).setRecordProperties(recordDetails);
                    recordList.add(recordIns);
                    entResponse.setData(recordIns);
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(recordList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private void setTagProperties(ZCRMTag tag, JSONObject tagJSONObject) {
        NullableJSONObject tagDetails = new NullableJSONObject(tagJSONObject);
        Iterator<String> jsonItr = tagDetails.keys();
        while (jsonItr.hasNext()) {
            String fieldAPIName = jsonItr.next();
            if ("id".equals(fieldAPIName)) {
                tag.setTagId(Long.parseLong(tagJSONObject.getString(fieldAPIName)));
                continue;
            }
            if ("name".equals(fieldAPIName)) {
                tag.setName(tagJSONObject.getString(fieldAPIName));
                continue;
            }
            if ("created_by".equals(fieldAPIName)) {
                JSONObject createdByObj = tagJSONObject.getJSONObject(fieldAPIName);
                ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                tag.setCreatedBy(createdBy);
                continue;
            }
            if ("modified_by".equals(fieldAPIName)) {
                JSONObject modifiedByObj = tagJSONObject.getJSONObject(fieldAPIName);
                ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
                tag.setModifiedBy(modifiedBy);
                continue;
            }
            if ("created_time".equals(fieldAPIName)) {
                tag.setCreatedTime(tagJSONObject.getString(fieldAPIName));
                continue;
            }
            if ("modified_time".equals(fieldAPIName)) {
                tag.setModifiedTime(tagJSONObject.getString(fieldAPIName));
                continue;
            }
            if (!"count".equals(fieldAPIName)) continue;
            tag.setTagCount(tagJSONObject.getInt(fieldAPIName));
        }
    }

    public JSONObject getZCRMTagAsJSON(ZCRMTag tagvalue) {
        JSONObject TagJSON = new JSONObject();
        if (tagvalue.getName() != null) {
            TagJSON.put("name", tagvalue.getName());
        }
        if (tagvalue.getId() != null && tagvalue.getId() != 0L) {
            TagJSON.put("id", tagvalue.getId());
        }
        return TagJSON;
    }

    @Override
    public String getJsonRootKey() {
        return this.jsonRootKey;
    }
}

