/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.OperationReadConcernHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import com.mongodb.session.SessionContext;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

@Deprecated
public class ParallelCollectionScanOperation<T>
implements AsyncReadOperation<List<AsyncBatchCursor<T>>>,
ReadOperation<List<BatchCursor<T>>> {
    private final MongoNamespace namespace;
    private final int numCursors;
    private int batchSize = 0;
    private final Decoder<T> decoder;

    public ParallelCollectionScanOperation(MongoNamespace namespace, int numCursors, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        Assertions.isTrue("numCursors >= 1", numCursors >= 1);
        this.numCursors = numCursors;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public int getNumCursors() {
        return this.numCursors;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ParallelCollectionScanOperation<T> batchSize(int batchSize) {
        Assertions.isTrue("batchSize >= 0", batchSize >= 0);
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public List<BatchCursor<T>> execute(final ReadBinding binding) {
        return (List)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<List<BatchCursor<T>>>(){

            @Override
            public List<BatchCursor<T>> call(ConnectionSource source, Connection connection) {
                OperationHelper.validateReadConcern(connection, binding.getSessionContext().getReadConcern());
                return (List)CommandOperationHelper.executeWrappedCommandProtocol(binding, ParallelCollectionScanOperation.this.namespace.getDatabaseName(), ParallelCollectionScanOperation.this.getCommand(binding.getSessionContext()), CommandResultDocumentCodec.create(ParallelCollectionScanOperation.this.decoder, "firstBatch"), connection, ParallelCollectionScanOperation.this.transformer(source));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<List<AsyncBatchCursor<T>>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, source, connection);
                    OperationHelper.validateReadConcern(source, connection, binding.getSessionContext().getReadConcern(), new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, ParallelCollectionScanOperation.this.namespace.getDatabaseName(), ParallelCollectionScanOperation.this.getCommand(binding.getSessionContext()), CommandResultDocumentCodec.create(ParallelCollectionScanOperation.this.decoder, "firstBatch"), connection, ParallelCollectionScanOperation.this.asyncTransformer(source, connection), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, List<BatchCursor<T>>> transformer(final ConnectionSource source) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, List<BatchCursor<T>>>(){

            @Override
            public List<BatchCursor<T>> apply(BsonDocument result2, ServerAddress serverAddress) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result2)) {
                    cursors.add(new QueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), ParallelCollectionScanOperation.this.decoder, source));
                }
                return cursors;
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, List<AsyncBatchCursor<T>>> asyncTransformer(final AsyncConnectionSource source, final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, List<AsyncBatchCursor<T>>>(){

            @Override
            public List<AsyncBatchCursor<T>> apply(BsonDocument result2, ServerAddress serverAddress) {
                ArrayList cursors = new ArrayList();
                for (BsonValue cursorValue : ParallelCollectionScanOperation.this.getCursorDocuments(result2)) {
                    cursors.add(new AsyncQueryBatchCursor(ParallelCollectionScanOperation.this.createQueryResult(ParallelCollectionScanOperation.this.getCursorDocument(cursorValue.asDocument()), source.getServerDescription().getAddress()), 0, ParallelCollectionScanOperation.this.getBatchSize(), 0L, ParallelCollectionScanOperation.this.decoder, source, connection));
                }
                return cursors;
            }
        };
    }

    private BsonArray getCursorDocuments(BsonDocument result2) {
        return result2.getArray("cursors");
    }

    private BsonDocument getCursorDocument(BsonDocument cursorDocument) {
        return cursorDocument.getDocument("cursor");
    }

    private QueryResult<T> createQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        return OperationHelper.cursorDocumentToQueryResult(cursorDocument, serverAddress);
    }

    private BsonDocument getCommand(SessionContext sessionContext) {
        BsonDocument document = new BsonDocument("parallelCollectionScan", new BsonString(this.namespace.getCollectionName())).append("numCursors", new BsonInt32(this.getNumCursors()));
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, document);
        return document;
    }
}

