/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.internal.operation.WriteConcernHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonValue;

final class WriteCommandResultHelper {
    static boolean hasError(BsonDocument result2) {
        return result2.get("writeErrors") != null || result2.get("writeConcernError") != null;
    }

    static BulkWriteResult getBulkWriteResult(WriteRequest.Type type, BsonDocument result2) {
        int count = WriteCommandResultHelper.getCount(result2);
        List<BulkWriteUpsert> upsertedItems = WriteCommandResultHelper.getUpsertedItems(result2);
        return BulkWriteResult.acknowledged(type, count - upsertedItems.size(), WriteCommandResultHelper.getModifiedCount(type, result2), upsertedItems);
    }

    static MongoBulkWriteException getBulkWriteException(WriteRequest.Type type, BsonDocument result2, ServerAddress serverAddress) {
        if (!WriteCommandResultHelper.hasError(result2)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new MongoBulkWriteException(WriteCommandResultHelper.getBulkWriteResult(type, result2), WriteCommandResultHelper.getWriteErrors(result2), WriteCommandResultHelper.getWriteConcernError(result2), serverAddress);
    }

    private static List<BulkWriteError> getWriteErrors(BsonDocument result2) {
        ArrayList<BulkWriteError> writeErrors = new ArrayList<BulkWriteError>();
        BsonArray writeErrorsDocuments = (BsonArray)result2.get("writeErrors");
        if (writeErrorsDocuments != null) {
            for (BsonValue cur : writeErrorsDocuments) {
                BsonDocument curDocument = (BsonDocument)cur;
                writeErrors.add(new BulkWriteError(curDocument.getNumber("code").intValue(), curDocument.getString("errmsg").getValue(), curDocument.getDocument("errInfo", new BsonDocument()), curDocument.getNumber("index").intValue()));
            }
        }
        return writeErrors;
    }

    private static WriteConcernError getWriteConcernError(BsonDocument result2) {
        BsonDocument writeConcernErrorDocument = (BsonDocument)result2.get("writeConcernError");
        if (writeConcernErrorDocument == null) {
            return null;
        }
        return WriteConcernHelper.createWriteConcernError(writeConcernErrorDocument);
    }

    private static List<BulkWriteUpsert> getUpsertedItems(BsonDocument result2) {
        BsonValue upsertedValue = result2.get("upserted");
        if (upsertedValue == null) {
            return Collections.emptyList();
        }
        ArrayList<BulkWriteUpsert> bulkWriteUpsertList = new ArrayList<BulkWriteUpsert>();
        for (BsonValue upsertedItem : (BsonArray)upsertedValue) {
            BsonDocument upsertedItemDocument = (BsonDocument)upsertedItem;
            bulkWriteUpsertList.add(new BulkWriteUpsert(upsertedItemDocument.getNumber("index").intValue(), upsertedItemDocument.get("_id")));
        }
        return bulkWriteUpsertList;
    }

    private static int getCount(BsonDocument result2) {
        return result2.getNumber("n").intValue();
    }

    private static Integer getModifiedCount(WriteRequest.Type type, BsonDocument result2) {
        BsonNumber modifiedCount = result2.getNumber("nModified", type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? null : new BsonInt32(0));
        return modifiedCount == null ? null : Integer.valueOf(modifiedCount.intValue());
    }

    private WriteCommandResultHelper() {
    }
}

