/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi.internal;

import com.kenai.jffi.Util;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;

public class StubLoader {
    public static final int VERSION_MAJOR = StubLoader.getVersionField("MAJOR");
    public static final int VERSION_MINOR = StubLoader.getVersionField("MINOR");
    private static final String versionClassName = "com.kenai.jffi.Version";
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", VERSION_MAJOR, VERSION_MINOR);
    private static volatile OS os = null;
    private static volatile CPU cpu = null;
    private static volatile Throwable failureCause = null;
    private static volatile boolean loaded = false;

    public static final boolean isLoaded() {
        return loaded;
    }

    public static final Throwable getFailureCause() {
        return failureCause;
    }

    private static OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Util.startsWithIgnoreCase(osName, "mac", LOCALE) || Util.startsWithIgnoreCase(osName, "darwin", LOCALE)) {
            return OS.DARWIN;
        }
        if (Util.startsWithIgnoreCase(osName, "linux", LOCALE)) {
            return OS.LINUX;
        }
        if (Util.startsWithIgnoreCase(osName, "sunos", LOCALE) || Util.startsWithIgnoreCase(osName, "solaris", LOCALE)) {
            return OS.SOLARIS;
        }
        if (Util.startsWithIgnoreCase(osName, "aix", LOCALE)) {
            return OS.AIX;
        }
        if (Util.startsWithIgnoreCase(osName, "openbsd", LOCALE)) {
            return OS.OPENBSD;
        }
        if (Util.startsWithIgnoreCase(osName, "freebsd", LOCALE)) {
            return OS.FREEBSD;
        }
        if (Util.startsWithIgnoreCase(osName, "windows", LOCALE)) {
            return OS.WINDOWS;
        }
        throw new RuntimeException("cannot determine operating system");
    }

    private static CPU determineCPU() {
        String archString = System.getProperty("os.arch", "unknown");
        if (Util.equalsIgnoreCase("x86", archString, LOCALE) || Util.equalsIgnoreCase("i386", archString, LOCALE) || Util.equalsIgnoreCase("i86pc", archString, LOCALE)) {
            return CPU.I386;
        }
        if (Util.equalsIgnoreCase("x86_64", archString, LOCALE) || Util.equalsIgnoreCase("amd64", archString, LOCALE)) {
            return CPU.X86_64;
        }
        if (Util.equalsIgnoreCase("ppc", archString, LOCALE) || Util.equalsIgnoreCase("powerpc", archString, LOCALE)) {
            return CPU.PPC;
        }
        if (Util.equalsIgnoreCase("ppc64", archString, LOCALE) || Util.equalsIgnoreCase("powerpc64", archString, LOCALE)) {
            if ("little".equals(System.getProperty("sun.cpu.endian"))) {
                return CPU.PPC64LE;
            }
            return CPU.PPC64;
        }
        if (Util.equalsIgnoreCase("ppc64le", archString, LOCALE) || Util.equalsIgnoreCase("powerpc64le", archString, LOCALE)) {
            return CPU.PPC64LE;
        }
        if (Util.equalsIgnoreCase("s390", archString, LOCALE) || Util.equalsIgnoreCase("s390x", archString, LOCALE)) {
            return CPU.S390X;
        }
        if (Util.equalsIgnoreCase("arm", archString, LOCALE)) {
            return CPU.ARM;
        }
        for (CPU cpu : CPU.values()) {
            if (!Util.equalsIgnoreCase(cpu.name(), archString, LOCALE)) continue;
            return cpu;
        }
        throw new RuntimeException("cannot determine CPU");
    }

    public static CPU getCPU() {
        return cpu != null ? cpu : (cpu = StubLoader.determineCPU());
    }

    public static OS getOS() {
        return os != null ? os : (os = StubLoader.determineOS());
    }

    private static String getStubLibraryName() {
        return stubLibraryName;
    }

    public static String getPlatformName() {
        if (StubLoader.getOS().equals((Object)OS.DARWIN)) {
            return "Darwin";
        }
        String osName = System.getProperty("os.name").split(" ")[0];
        return StubLoader.getCPU().name().toLowerCase(LOCALE) + "-" + osName;
    }

    private static String getStubLibraryPath() {
        return "jni/" + StubLoader.getPlatformName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    static void load() {
        String libName = StubLoader.getStubLibraryName();
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        String bootPath = StubLoader.getBootPath();
        if (bootPath != null && StubLoader.loadFromBootPath(libName, bootPath, errors)) {
            return;
        }
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath != null && StubLoader.loadFromBootPath(libName, libraryPath, errors)) {
            return;
        }
        try {
            StubLoader.loadFromJar();
            return;
        }
        catch (Throwable t) {
            errors.add(t);
            if (!errors.isEmpty()) {
                Collections.reverse(errors);
                CharArrayWriter caw = new CharArrayWriter();
                PrintWriter pw = new PrintWriter(caw);
                for (Throwable t2 : errors) {
                    t2.printStackTrace(pw);
                }
                throw new UnsatisfiedLinkError(new String(caw.toCharArray()));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = StubLoader.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
                String string = p.getProperty(bootLibraryPropertyName);
                return string;
            }
            catch (IOException ex) {
                String string = null;
                return string;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return null;
    }

    private static String getAlternateLibraryPath(String path) {
        if (path.endsWith("dylib")) {
            return path.substring(0, path.lastIndexOf("dylib")) + "jnilib";
        }
        return path.substring(0, path.lastIndexOf("jnilib")) + "dylib";
    }

    private static boolean loadFromBootPath(String libName, String bootPath, Collection<Throwable> errors) {
        String[] dirs2 = bootPath.split(File.pathSeparator);
        for (int i = 0; i < dirs2.length; ++i) {
            String soname = System.mapLibraryName(libName);
            File stub = new File(new File(dirs2[i], StubLoader.getPlatformName()), soname);
            if (!stub.isFile()) {
                stub = new File(new File(dirs2[i]), soname);
            }
            String path = stub.getAbsolutePath();
            try {
                System.load(path);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                errors.add(ex);
                if (StubLoader.getOS() != OS.DARWIN) continue;
                try {
                    System.load(StubLoader.getAlternateLibraryPath(path));
                    return true;
                }
                catch (UnsatisfiedLinkError ex2) {
                    errors.add(ex2);
                }
                continue;
            }
        }
        return false;
    }

    private static String dlExtension() {
        switch (StubLoader.getOS()) {
            case WINDOWS: {
                return "dll";
            }
            case DARWIN: {
                return "dylib";
            }
        }
        return "so";
    }

    private static void loadFromJar() throws IOException, UnsatisfiedLinkError {
        InputStream is = StubLoader.getStubLibraryStream();
        FileOutputStream os = null;
        try {
            File dstFile = File.createTempFile("jffi", "." + StubLoader.dlExtension());
            dstFile.deleteOnExit();
            os = new FileOutputStream(dstFile);
            ReadableByteChannel srcChannel = Channels.newChannel(is);
            long pos = 0L;
            while (is.available() > 0) {
                pos += os.getChannel().transferFrom(srcChannel, pos, Math.max(4096, is.available()));
            }
            os.close();
            os = null;
            System.load(dstFile.getAbsolutePath());
            dstFile.delete();
        }
        catch (IOException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
        finally {
            if (os != null) {
                os.close();
            }
            is.close();
        }
    }

    private static InputStream getStubLibraryStream() {
        Object[] paths;
        String stubPath = StubLoader.getStubLibraryPath();
        for (String string : paths = new String[]{stubPath, "/" + stubPath}) {
            InputStream is = StubLoader.getResourceAsStream(string);
            if (is == null && StubLoader.getOS() == OS.DARWIN) {
                is = StubLoader.getResourceAsStream(StubLoader.getAlternateLibraryPath(string));
            }
            if (is == null) continue;
            return is;
        }
        throw new UnsatisfiedLinkError("could not locate stub library in jar file.  Tried " + Arrays.deepToString(paths));
    }

    private static InputStream getResourceAsStream(String resourceName) {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), StubLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            InputStream is;
            if (cl == null || (is = cl.getResourceAsStream(resourceName)) == null) continue;
            return is;
        }
        return null;
    }

    private static int getVersionField(String name) {
        try {
            Class<?> c = Class.forName(versionClassName);
            return (Integer)c.getField(name).get(c);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            StubLoader.load();
            loaded = true;
        }
        catch (Throwable t) {
            failureCause = t;
        }
    }

    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        PPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }
}

