/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.springframework.http.HttpHeaders;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public class StandardMultipartHttpServletRequest
extends AbstractMultipartHttpServletRequest {
    private static final String CONTENT_DISPOSITION = "content-disposition";
    private static final String FILENAME_KEY = "filename=";

    public StandardMultipartHttpServletRequest(HttpServletRequest request) throws MultipartException {
        super(request);
        try {
            Collection parts = request.getParts();
            LinkedMultiValueMap<String, MultipartFile> files2 = new LinkedMultiValueMap<String, MultipartFile>(parts.size());
            for (Part part : parts) {
                String filename = this.extractFilename(part.getHeader(CONTENT_DISPOSITION));
                if (filename == null) continue;
                files2.add(part.getName(), new StandardMultipartFile(part, filename));
            }
            this.setMultipartFiles(files2);
        }
        catch (Exception ex) {
            throw new MultipartException("Could not parse multipart servlet request", ex);
        }
    }

    private String extractFilename(String contentDisposition) {
        if (contentDisposition == null) {
            return null;
        }
        int startIndex = contentDisposition.indexOf(FILENAME_KEY);
        if (startIndex == -1) {
            return null;
        }
        String filename = contentDisposition.substring(startIndex + FILENAME_KEY.length());
        if (filename.startsWith("\"")) {
            int endIndex = filename.indexOf("\"", 1);
            if (endIndex != -1) {
                return filename.substring(1, endIndex);
            }
        } else {
            int endIndex = filename.indexOf(";");
            if (endIndex != -1) {
                return filename.substring(0, endIndex);
            }
        }
        return filename;
    }

    public String getMultipartContentType(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            return part != null ? part.getContentType() : null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        try {
            Part part = this.getPart(paramOrFileName);
            if (part != null) {
                HttpHeaders headers = new HttpHeaders();
                for (String headerName : part.getHeaderNames()) {
                    headers.put(headerName, (List<String>)new ArrayList<String>(part.getHeaders(headerName)));
                }
                return headers;
            }
            return null;
        }
        catch (Exception ex) {
            throw new MultipartException("Could not access multipart servlet request", ex);
        }
    }

    private static class StandardMultipartFile
    implements MultipartFile {
        private final Part part;
        private final String filename;

        public StandardMultipartFile(Part part, String filename) {
            this.part = part;
            this.filename = filename;
        }

        public String getName() {
            return this.part.getName();
        }

        public String getOriginalFilename() {
            return this.filename;
        }

        public String getContentType() {
            return this.part.getContentType();
        }

        public boolean isEmpty() {
            return this.part.getSize() == 0L;
        }

        public long getSize() {
            return this.part.getSize();
        }

        public byte[] getBytes() throws IOException {
            return FileCopyUtils.copyToByteArray(this.part.getInputStream());
        }

        public InputStream getInputStream() throws IOException {
            return this.part.getInputStream();
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            this.part.write(dest.getPath());
        }
    }
}

