/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.Iterator;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestBindingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsatisfiedServletRequestParameterException
extends ServletRequestBindingException {
    private final String[] paramConditions;
    private final Map<String, String[]> actualParams;

    public UnsatisfiedServletRequestParameterException(String[] paramConditions, Map actualParams) {
        super("");
        this.paramConditions = paramConditions;
        this.actualParams = actualParams;
    }

    @Override
    public String getMessage() {
        return "Parameter conditions \"" + StringUtils.arrayToDelimitedString(this.paramConditions, ", ") + "\" not met for actual request parameters: " + UnsatisfiedServletRequestParameterException.requestParameterMapToString(this.actualParams);
    }

    private static String requestParameterMapToString(Map<String, String[]> actualParams) {
        StringBuilder result2 = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> it = actualParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String[]> entry = it.next();
            result2.append(entry.getKey()).append('=').append(ObjectUtils.nullSafeToString(entry.getValue()));
            if (!it.hasNext()) continue;
            result2.append(", ");
        }
        return result2.toString();
    }

    public final String[] getParamConditions() {
        return this.paramConditions;
    }

    public final Map<String, String[]> getActualParams() {
        return this.actualParams;
    }
}

