/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.io.Serializable;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractErrors
implements Errors,
Serializable {
    private String nestedPath = "";
    private final Stack<String> nestedPathStack = new Stack();

    @Override
    public void setNestedPath(String nestedPath) {
        this.doSetNestedPath(nestedPath);
        this.nestedPathStack.clear();
    }

    @Override
    public String getNestedPath() {
        return this.nestedPath;
    }

    @Override
    public void pushNestedPath(String subPath) {
        this.nestedPathStack.push(this.getNestedPath());
        this.doSetNestedPath(this.getNestedPath() + subPath);
    }

    @Override
    public void popNestedPath() throws IllegalArgumentException {
        try {
            String formerNestedPath = this.nestedPathStack.pop();
            this.doSetNestedPath(formerNestedPath);
        }
        catch (EmptyStackException ex) {
            throw new IllegalStateException("Cannot pop nested path: no nested path on stack");
        }
    }

    protected void doSetNestedPath(String nestedPath) {
        if (nestedPath == null) {
            nestedPath = "";
        }
        if ((nestedPath = this.canonicalFieldName(nestedPath)).length() > 0 && !nestedPath.endsWith(".")) {
            nestedPath = nestedPath + ".";
        }
        this.nestedPath = nestedPath;
    }

    protected String fixedField(String field2) {
        if (StringUtils.hasLength(field2)) {
            return this.getNestedPath() + this.canonicalFieldName(field2);
        }
        String path = this.getNestedPath();
        return path.endsWith(".") ? path.substring(0, path.length() - ".".length()) : path;
    }

    protected String canonicalFieldName(String field2) {
        return field2;
    }

    @Override
    public void reject(String errorCode) {
        this.reject(errorCode, null, null);
    }

    @Override
    public void reject(String errorCode, String defaultMessage) {
        this.reject(errorCode, null, defaultMessage);
    }

    @Override
    public void rejectValue(String field2, String errorCode) {
        this.rejectValue(field2, errorCode, null, null);
    }

    @Override
    public void rejectValue(String field2, String errorCode, String defaultMessage) {
        this.rejectValue(field2, errorCode, null, defaultMessage);
    }

    @Override
    public boolean hasErrors() {
        return !this.getAllErrors().isEmpty();
    }

    @Override
    public int getErrorCount() {
        return this.getAllErrors().size();
    }

    @Override
    public List<ObjectError> getAllErrors() {
        LinkedList<ObjectError> result2 = new LinkedList<ObjectError>();
        result2.addAll(this.getGlobalErrors());
        result2.addAll(this.getFieldErrors());
        return Collections.unmodifiableList(result2);
    }

    @Override
    public boolean hasGlobalErrors() {
        return this.getGlobalErrorCount() > 0;
    }

    @Override
    public int getGlobalErrorCount() {
        return this.getGlobalErrors().size();
    }

    @Override
    public ObjectError getGlobalError() {
        List<ObjectError> globalErrors = this.getGlobalErrors();
        return !globalErrors.isEmpty() ? globalErrors.get(0) : null;
    }

    @Override
    public boolean hasFieldErrors() {
        return this.getFieldErrorCount() > 0;
    }

    @Override
    public int getFieldErrorCount() {
        return this.getFieldErrors().size();
    }

    @Override
    public FieldError getFieldError() {
        List<FieldError> fieldErrors = this.getFieldErrors();
        return !fieldErrors.isEmpty() ? fieldErrors.get(0) : null;
    }

    @Override
    public boolean hasFieldErrors(String field2) {
        return this.getFieldErrorCount(field2) > 0;
    }

    @Override
    public int getFieldErrorCount(String field2) {
        return this.getFieldErrors(field2).size();
    }

    @Override
    public List<FieldError> getFieldErrors(String field2) {
        List<FieldError> fieldErrors = this.getFieldErrors();
        LinkedList<FieldError> result2 = new LinkedList<FieldError>();
        String fixedField = this.fixedField(field2);
        for (FieldError error : fieldErrors) {
            if (!this.isMatchingFieldError(fixedField, error)) continue;
            result2.add(error);
        }
        return Collections.unmodifiableList(result2);
    }

    @Override
    public FieldError getFieldError(String field2) {
        List<FieldError> fieldErrors = this.getFieldErrors(field2);
        return !fieldErrors.isEmpty() ? fieldErrors.get(0) : null;
    }

    @Override
    public Class<?> getFieldType(String field2) {
        Object value = this.getFieldValue(field2);
        return value != null ? value.getClass() : null;
    }

    protected boolean isMatchingFieldError(String field2, FieldError fieldError) {
        if (field2.equals(fieldError.getField())) {
            return true;
        }
        int endIndex = field2.length() - 1;
        return endIndex >= 0 && field2.charAt(endIndex) == '*' && (endIndex == 0 || field2.regionMatches(0, fieldError.getField(), 0, endIndex));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": ").append(this.getErrorCount()).append(" errors");
        for (ObjectError error : this.getAllErrors()) {
            sb.append('\n').append(error);
        }
        return sb.toString();
    }
}

