/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.authentication.configurers.ldap;

import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.encoding.PlaintextPasswordEncoder;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;
import org.springframework.security.ldap.authentication.BindAuthenticator;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.security.ldap.search.FilterBasedLdapUserSearch;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.server.ApacheDSContainer;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapAuthenticationProviderConfigurer<B extends ProviderManagerBuilder<B>>
extends SecurityConfigurerAdapter<AuthenticationManager, B> {
    private String groupRoleAttribute = "cn";
    private String groupSearchBase = "";
    private String groupSearchFilter = "(uniqueMember={0})";
    private String rolePrefix = "ROLE_";
    private String userSearchBase = "";
    private String userSearchFilter = null;
    private String[] userDnPatterns;
    private BaseLdapPathContextSource contextSource;
    private ContextSourceBuilder contextSourceBuilder = new ContextSourceBuilder();
    private UserDetailsContextMapper userDetailsContextMapper;
    private org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder;
    private String passwordAttribute;
    private LdapAuthoritiesPopulator ldapAuthoritiesPopulator;

    private LdapAuthenticationProvider build() throws Exception {
        BaseLdapPathContextSource contextSource = this.getContextSource();
        LdapAuthenticator ldapAuthenticator = this.createLdapAuthenticator(contextSource);
        LdapAuthoritiesPopulator authoritiesPopulator = this.getLdapAuthoritiesPopulator();
        LdapAuthenticationProvider ldapAuthenticationProvider = new LdapAuthenticationProvider(ldapAuthenticator, authoritiesPopulator);
        SimpleAuthorityMapper simpleAuthorityMapper = new SimpleAuthorityMapper();
        simpleAuthorityMapper.setPrefix(this.rolePrefix);
        simpleAuthorityMapper.afterPropertiesSet();
        ldapAuthenticationProvider.setAuthoritiesMapper((GrantedAuthoritiesMapper)simpleAuthorityMapper);
        if (this.userDetailsContextMapper != null) {
            ldapAuthenticationProvider.setUserDetailsContextMapper(this.userDetailsContextMapper);
        }
        return ldapAuthenticationProvider;
    }

    public LdapAuthenticationProviderConfigurer<B> ldapAuthoritiesPopulator(LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> withObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.addObjectPostProcessor(objectPostProcessor);
        return this;
    }

    private LdapAuthoritiesPopulator getLdapAuthoritiesPopulator() {
        if (this.ldapAuthoritiesPopulator != null) {
            return this.ldapAuthoritiesPopulator;
        }
        DefaultLdapAuthoritiesPopulator defaultAuthoritiesPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)this.contextSource, this.groupSearchBase);
        defaultAuthoritiesPopulator.setGroupRoleAttribute(this.groupRoleAttribute);
        defaultAuthoritiesPopulator.setGroupSearchFilter(this.groupSearchFilter);
        this.ldapAuthoritiesPopulator = defaultAuthoritiesPopulator;
        return defaultAuthoritiesPopulator;
    }

    private LdapAuthenticator createLdapAuthenticator(BaseLdapPathContextSource contextSource) {
        BindAuthenticator ldapAuthenticator = this.passwordEncoder == null ? this.createBindAuthenticator(contextSource) : this.createPasswordCompareAuthenticator(contextSource);
        LdapUserSearch userSearch = this.createUserSearch();
        if (userSearch != null) {
            ldapAuthenticator.setUserSearch(userSearch);
        }
        if (this.userDnPatterns != null && this.userDnPatterns.length > 0) {
            ldapAuthenticator.setUserDnPatterns(this.userDnPatterns);
        }
        return (LdapAuthenticator)this.postProcess(ldapAuthenticator);
    }

    private PasswordComparisonAuthenticator createPasswordCompareAuthenticator(BaseLdapPathContextSource contextSource) {
        PasswordComparisonAuthenticator ldapAuthenticator = new PasswordComparisonAuthenticator(contextSource);
        ldapAuthenticator.setPasswordAttributeName(this.passwordAttribute);
        ldapAuthenticator.setPasswordEncoder((Object)this.passwordEncoder);
        return ldapAuthenticator;
    }

    private BindAuthenticator createBindAuthenticator(BaseLdapPathContextSource contextSource) {
        return new BindAuthenticator(contextSource);
    }

    private LdapUserSearch createUserSearch() {
        if (this.userSearchFilter == null) {
            return null;
        }
        return new FilterBasedLdapUserSearch(this.userSearchBase, this.userSearchFilter, this.contextSource);
    }

    public LdapAuthenticationProviderConfigurer<B> contextSource(BaseLdapPathContextSource contextSource) {
        this.contextSource = contextSource;
        return this;
    }

    public ContextSourceBuilder contextSource() {
        return this.contextSourceBuilder;
    }

    public LdapAuthenticationProviderConfigurer<B> passwordEncoder(org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> passwordEncoder(final PasswordEncoder passwordEncoder) {
        Assert.notNull(passwordEncoder, "passwordEncoder must not be null.");
        this.passwordEncoder(new org.springframework.security.authentication.encoding.PasswordEncoder(){

            public String encodePassword(String rawPass, Object salt) {
                this.checkSalt(salt);
                return passwordEncoder.encode(rawPass);
            }

            public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
                this.checkSalt(salt);
                return passwordEncoder.matches(rawPass, encPass);
            }

            private void checkSalt(Object salt) {
                Assert.isNull(salt, "Salt value must be null when used with crypto module PasswordEncoder");
            }
        });
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userDnPatterns(String ... userDnPatterns) {
        this.userDnPatterns = userDnPatterns;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userDetailsContextMapper(UserDetailsContextMapper userDetailsContextMapper) {
        this.userDetailsContextMapper = userDetailsContextMapper;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupRoleAttribute(String groupRoleAttribute) {
        this.groupRoleAttribute = groupRoleAttribute;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupSearchBase(String groupSearchBase) {
        this.groupSearchBase = groupSearchBase;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> groupSearchFilter(String groupSearchFilter) {
        this.groupSearchFilter = groupSearchFilter;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> rolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userSearchBase(String userSearchBase) {
        this.userSearchBase = userSearchBase;
        return this;
    }

    public LdapAuthenticationProviderConfigurer<B> userSearchFilter(String userSearchFilter) {
        this.userSearchFilter = userSearchFilter;
        return this;
    }

    @Override
    public void configure(B builder) throws Exception {
        LdapAuthenticationProvider provider = this.postProcess(this.build());
        builder.authenticationProvider((AuthenticationProvider)provider);
    }

    private BaseLdapPathContextSource getContextSource() throws Exception {
        if (this.contextSource == null) {
            this.contextSource = this.contextSourceBuilder.build();
        }
        return this.contextSource;
    }

    public PasswordCompareConfigurer passwordCompare() {
        return new PasswordCompareConfigurer().passwordAttribute("password").passwordEncoder(new PlaintextPasswordEncoder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ContextSourceBuilder {
        private String ldif = "classpath*:*.ldif";
        private String managerPassword;
        private String managerDn;
        private int port = 33389;
        private String root = "dc=springframework,dc=org";
        private String url;

        public ContextSourceBuilder ldif(String ldif) {
            this.ldif = ldif;
            return this;
        }

        public ContextSourceBuilder managerDn(String managerDn) {
            this.managerDn = managerDn;
            return this;
        }

        public ContextSourceBuilder managerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
            return this;
        }

        public ContextSourceBuilder port(int port) {
            this.port = port;
            return this;
        }

        public ContextSourceBuilder root(String root) {
            this.root = root;
            return this;
        }

        public ContextSourceBuilder url(String url) {
            this.url = url;
            return this;
        }

        public LdapAuthenticationProviderConfigurer<B> and() {
            return LdapAuthenticationProviderConfigurer.this;
        }

        private DefaultSpringSecurityContextSource build() throws Exception {
            DefaultSpringSecurityContextSource contextSource = new DefaultSpringSecurityContextSource(this.getProviderUrl());
            if (this.managerDn != null) {
                contextSource.setUserDn(this.managerDn);
                if (this.managerPassword == null) {
                    throw new IllegalStateException("managerPassword is required if managerDn is supplied");
                }
                contextSource.setPassword(this.managerPassword);
            }
            contextSource = (DefaultSpringSecurityContextSource)LdapAuthenticationProviderConfigurer.this.postProcess(contextSource);
            if (this.url != null) {
                return contextSource;
            }
            ApacheDSContainer apacheDsContainer = new ApacheDSContainer(this.root, this.ldif);
            apacheDsContainer.setPort(this.port);
            LdapAuthenticationProviderConfigurer.this.postProcess(apacheDsContainer);
            return contextSource;
        }

        private String getProviderUrl() {
            if (this.url == null) {
                return "ldap://127.0.0.1:" + this.port + "/" + this.root;
            }
            return this.url;
        }

        private ContextSourceBuilder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class PasswordCompareConfigurer {
        public PasswordCompareConfigurer passwordEncoder(org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder) {
            LdapAuthenticationProviderConfigurer.this.passwordEncoder = passwordEncoder;
            return this;
        }

        public PasswordCompareConfigurer passwordAttribute(String passwordAttribute) {
            LdapAuthenticationProviderConfigurer.this.passwordAttribute = passwordAttribute;
            return this;
        }

        public LdapAuthenticationProviderConfigurer<B> and() {
            return LdapAuthenticationProviderConfigurer.this;
        }

        private PasswordCompareConfigurer() {
        }
    }
}

