/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.support;

import java.util.Collection;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataAccessUtils {
    public static <T> T singleResult(Collection<T> results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static <T> T requiredSingleResult(Collection<T> results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (results.size() > 1) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static <T> T uniqueResult(Collection<T> results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            return null;
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static <T> T requiredUniqueResult(Collection<T> results) throws IncorrectResultSizeDataAccessException {
        int size;
        int n = size = results != null ? results.size() : 0;
        if (size == 0) {
            throw new EmptyResultDataAccessException(1);
        }
        if (!CollectionUtils.hasUniqueObject(results)) {
            throw new IncorrectResultSizeDataAccessException(1, size);
        }
        return results.iterator().next();
    }

    public static <T> T objectResult(Collection<?> results, Class<T> requiredType) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        Object result2 = DataAccessUtils.requiredUniqueResult(results);
        if (requiredType != null && !requiredType.isInstance(result2)) {
            if (String.class.equals(requiredType)) {
                result2 = result2.toString();
            } else if (Number.class.isAssignableFrom(requiredType) && Number.class.isInstance(result2)) {
                try {
                    result2 = NumberUtils.convertNumberToTargetClass((Number)result2, requiredType);
                }
                catch (IllegalArgumentException ex) {
                    throw new TypeMismatchDataAccessException(ex.getMessage());
                }
            } else {
                throw new TypeMismatchDataAccessException("Result object is of type [" + result2.getClass().getName() + "] and could not be converted to required type [" + requiredType.getName() + "]");
            }
        }
        return (T)result2;
    }

    public static int intResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return DataAccessUtils.objectResult(results, Number.class).intValue();
    }

    public static long longResult(Collection results) throws IncorrectResultSizeDataAccessException, TypeMismatchDataAccessException {
        return DataAccessUtils.objectResult(results, Number.class).longValue();
    }

    public static RuntimeException translateIfNecessary(RuntimeException rawException, PersistenceExceptionTranslator pet) {
        Assert.notNull(pet, "PersistenceExceptionTranslator must not be null");
        DataAccessException dex = pet.translateExceptionIfPossible(rawException);
        return dex != null ? dex : rawException;
    }
}

