/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheOperation {
    private Set<String> cacheNames = Collections.emptySet();
    private String condition = "";
    private String key = "";
    private String name = "";

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheName(String cacheName) {
        Assert.hasText(cacheName);
        this.cacheNames = Collections.singleton(cacheName);
    }

    public void setCacheNames(String[] cacheNames) {
        Assert.notEmpty(cacheNames);
        this.cacheNames = new LinkedHashSet<String>(cacheNames.length);
        for (String string : cacheNames) {
            this.cacheNames.add(string);
        }
    }

    public void setCondition(String condition) {
        Assert.notNull(condition);
        this.condition = condition;
    }

    public void setKey(String key) {
        Assert.notNull(key);
        this.key = key;
    }

    public void setName(String name) {
        Assert.hasText(name);
        this.name = name;
    }

    public boolean equals(Object other) {
        return other instanceof CacheOperation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getOperationDescription().toString();
    }

    protected StringBuilder getOperationDescription() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.getClass().getSimpleName());
        result2.append("[");
        result2.append(this.name);
        result2.append("] caches=");
        result2.append(this.cacheNames);
        result2.append(" | key='");
        result2.append(this.key);
        result2.append("' | condition='");
        result2.append(this.condition);
        result2.append("'");
        return result2;
    }
}

