/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ValueReadQuery;

public class CursoredStream
extends Cursor {
    protected int marker;

    public CursoredStream() {
    }

    public CursoredStream(DatabaseCall call, CursoredStreamPolicy policy) {
        super(call, policy);
        try {
            this.setLimits();
        }
        catch (RuntimeException exception) {
            try {
                this.close();
            }
            catch (RuntimeException runtimeException) {}
            throw exception;
        }
    }

    public boolean atEnd() throws DatabaseException {
        if (this.position + 1 <= this.objectCollection.size()) {
            return false;
        }
        if (this.nextRow != null) {
            return false;
        }
        if (this.isClosed()) {
            return true;
        }
        int oldSize = this.objectCollection.size();
        this.retrieveNextPage();
        return this.objectCollection.size() == oldSize;
    }

    public int available() throws DatabaseException {
        return this.objectCollection.size() - this.position;
    }

    public Expression buildCountDistinctExpression(List includeFields, ExpressionBuilder builder) {
        ExpressionOperator countOperator = new ExpressionOperator();
        countOperator.setType(3);
        Vector<String> databaseStrings = new Vector<String>();
        databaseStrings.add("COUNT(DISTINCT ");
        databaseStrings.add(")");
        countOperator.printsAs(databaseStrings);
        countOperator.bePrefix();
        countOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        Expression firstFieldExpression = builder.getField(((DatabaseField)includeFields.get(0)).getQualifiedName());
        return countOperator.expressionForArguments(firstFieldExpression, new ArrayList(0));
    }

    protected List<Object> copy(int startIndex, int endIndex) throws QueryException {
        while (this.objectCollection.size() < endIndex) {
            if (this.retrieveNextObject() != null) continue;
            throw QueryException.readBeyondStream(this.query);
        }
        return Helper.copyVector(this.objectCollection, startIndex, endIndex);
    }

    @Override
    protected int getCursorSize() throws DatabaseException, QueryException {
        ValueReadQuery query;
        if (!((CursoredStreamPolicy)this.policy).hasSizeQuery()) {
            if (this.query.isCallQuery()) {
                throw QueryException.additionalSizeQueryNotSpecified(this.query);
            }
            if (!this.query.isExpressionQuery()) {
                throw QueryException.sizeOnlySupportedOnExpressionQueries(this.query);
            }
            SQLSelectStatement selectStatement = new SQLSelectStatement();
            IdentityHashMap clonedExpressions = new IdentityHashMap();
            selectStatement.setWhereClause(((ExpressionQueryMechanism)this.query.getQueryMechanism()).buildBaseSelectionCriteria(false, clonedExpressions));
            ClassDescriptor descriptor = this.query.getDescriptor();
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getWithAllSubclassesExpression() != null) {
                Expression branchIndicator = descriptor.getInheritancePolicy().getWithAllSubclassesExpression();
                if (branchIndicator != null && selectStatement.getWhereClause() != null) {
                    selectStatement.setWhereClause(selectStatement.getWhereClause().and(branchIndicator));
                } else if (branchIndicator != null) {
                    selectStatement.setWhereClause((Expression)branchIndicator.clone());
                }
            }
            selectStatement.setTables((Vector)descriptor.getTables().clone());
            if (((ReadAllQuery)this.query).shouldDistinctBeUsed() && this.query.getCall().getFields().size() == 1) {
                selectStatement.addField(this.buildCountDistinctExpression(this.query.getCall().getFields(), ((ReadAllQuery)this.query).getExpressionBuilder()));
            } else {
                selectStatement.computeDistinct();
                if (selectStatement.shouldDistinctBeUsed() && descriptor.getPrimaryKeyFields().size() == 1) {
                    selectStatement.addField(this.buildCountDistinctExpression(descriptor.getPrimaryKeyFields(), ((ReadAllQuery)this.query).getExpressionBuilder()));
                } else {
                    selectStatement.addField(((ReadAllQuery)this.query).getExpressionBuilder().count());
                }
                selectStatement.dontUseDistinct();
            }
            selectStatement.normalize(this.getSession(), descriptor, clonedExpressions);
            query = new ValueReadQuery();
            query.setSQLStatement(selectStatement);
        } else {
            query = ((CursoredStreamPolicy)this.policy).getSizeQuery();
        }
        Number value = (Number)this.getSession().executeQuery((DatabaseQuery)query, this.query.getTranslationRow());
        if (value == null) {
            throw QueryException.incorrectSizeQueryForCursorStream(this.query);
        }
        return value.intValue();
    }

    protected int getInitialReadSize() {
        return ((CursoredStreamPolicy)this.policy).getInitialReadSize();
    }

    protected int getMarker() {
        return this.marker;
    }

    @Override
    public int getPageSize() {
        return ((CursoredStreamPolicy)this.policy).getPageSize();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean hasMoreElements() {
        return !this.atEnd();
    }

    @Override
    public boolean hasNext() {
        return !this.atEnd();
    }

    public void mark(int readAheadLimit) {
        this.marker = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public Object nextElement() {
        return this.read();
    }

    public Object next() {
        return this.read();
    }

    public Vector nextElements(int numberOfElements) {
        Vector<Object> nextElements = new Vector<Object>(numberOfElements);
        while (nextElements.size() < numberOfElements) {
            if (this.atEnd()) {
                return nextElements;
            }
            nextElements.add(this.nextElement());
        }
        return nextElements;
    }

    public List<Object> next(int numberOfElements) {
        return this.nextElements(numberOfElements);
    }

    public Object peek() throws DatabaseException {
        Object object = this.read();
        --this.position;
        return object;
    }

    public Object read() throws DatabaseException, QueryException {
        if (this.objectCollection.size() == this.position) {
            this.retrieveNextPage();
        }
        if (this.atEnd()) {
            throw QueryException.readBeyondStream(this.query);
        }
        Object object = this.objectCollection.get(this.position);
        ++this.position;
        return object;
    }

    public List<Object> read(int number) throws DatabaseException {
        List<Object> result2 = this.copy(this.position, this.position + number);
        this.position += result2.size();
        return result2;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.position == 0) {
            return;
        }
        this.objectCollection = Helper.copyVector(this.objectCollection, this.position, this.objectCollection.size());
        this.position = 0;
    }

    public void releasePrevious() {
        this.clear();
    }

    public void reset() {
        this.position = this.marker;
    }

    @Override
    protected Object retrieveNextObject() throws DatabaseException {
        AbstractRecord row;
        Object object;
        do {
            JoinedAttributeManager joinManager;
            row = null;
            if (this.nextRow == null) {
                if (this.isClosed()) {
                    return null;
                }
                row = this.getAccessor().cursorRetrieveNextRow(this.fields, this.resultSet, this.executionSession);
            } else {
                row = this.nextRow;
                this.nextRow = null;
            }
            if (row == null) {
                this.close();
                return null;
            }
            if (!this.query.isObjectLevelReadQuery() || !((ObjectLevelReadQuery)this.query).hasJoining() || this.isClosed() || !(joinManager = ((ObjectLevelReadQuery)this.query).getJoinedAttributeManager()).isToManyJoin()) continue;
            this.nextRow = joinManager.processDataResults(row, this, true);
            if (this.nextRow != null) continue;
            this.close();
        } while ((object = this.buildAndRegisterObject(row)) == InvalidObject.instance);
        if (object != null) {
            this.objectCollection.add(object);
        }
        return object;
    }

    protected Object retrieveNextPage() throws DatabaseException {
        Object last = null;
        int pageSize = this.getPageSize();
        int index = 0;
        while (index < pageSize) {
            last = this.retrieveNextObject();
            if (last == null) {
                return null;
            }
            ++index;
        }
        return last;
    }

    protected void setLimits() {
        this.position = 0;
        this.marker = 0;
        int readSize = this.getInitialReadSize();
        int index = 0;
        while (index < readSize) {
            this.retrieveNextObject();
            ++index;
        }
    }

    protected void setMarker(int value) {
        this.marker = value;
    }
}

