/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.CollectionReferenceMapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCollectionReferenceMapping
extends XMLObjectReferenceMapping
implements CollectionReferenceMapping<AbstractSession, AttributeAccessor, ContainerPolicy, ClassDescriptor, DatabaseField, UnmarshalRecord, XMLField, XMLRecord>,
ContainerMapping {
    protected ContainerPolicy containerPolicy;
    private static final String SPACE = " ";
    private DatabaseField field;
    private boolean defaultEmptyContainer = true;
    private boolean usesSingleNode;
    private boolean reuseContainer;
    private AbstractNullPolicy wrapperNullPolicy;

    public XMLCollectionReferenceMapping() {
        this.sourceToTargetKeyFieldAssociations = new HashMap();
        this.sourceToTargetKeys = new NonSynchronizedVector();
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
        this.usesSingleNode = false;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    @Override
    public void setField(DatabaseField field2) {
        this.field = field2;
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    @Override
    public Object buildFieldValue(Object targetObject, XMLField xmlFld, AbstractSession session) {
        if (targetObject == null) {
            return null;
        }
        ClassDescriptor descriptor = this.referenceDescriptor;
        if (descriptor == null) {
            descriptor = session.getClassDescriptor(targetObject);
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object primaryKey = objectBuilder.extractPrimaryKeyFromObject(targetObject, session);
        XMLField tgtXMLField = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlFld);
        int idx = 0;
        if (this.referenceClass != null && ClassConstants.OBJECT != this.referenceClass && (idx = descriptor.getPrimaryKeyFields().indexOf(tgtXMLField)) == -1) {
            return null;
        }
        if (primaryKey instanceof CacheId) {
            return ((CacheId)primaryKey).getPrimaryKey()[idx];
        }
        return primaryKey;
    }

    @Override
    public void buildReference(UnmarshalRecord record, XMLField xmlField, Object object, AbstractSession session, Object container) {
        this.buildReference(record.getCurrentObject(), xmlField, object, session, container, record.getReferenceResolver());
    }

    public void buildReference(Object srcObject, XMLField xmlField, Object object, AbstractSession session, Object container, ReferenceResolver resolver) {
        if (resolver == null) {
            return;
        }
        Reference reference = resolver.getReference(this, srcObject, xmlField);
        if (reference == null) {
            reference = new Reference(this, srcObject, this.referenceClass, new HashMap(), container);
            resolver.addReference(reference);
        }
        if (this.referenceClass == null || ClassConstants.OBJECT == this.referenceClass) {
            HashMap primaryKeyMap = reference.getPrimaryKeyMap();
            CacheId pks = (CacheId)primaryKeyMap.get(null);
            if (pks == null) {
                Object[] pkValues = new Object[1];
                pks = new CacheId(pkValues);
                primaryKeyMap.put(null, pks);
            }
            if (this.usesSingleNode) {
                StringTokenizer stok = new StringTokenizer((String)object);
                while (stok.hasMoreTokens()) {
                    pks.add(stok.nextToken());
                    reference = resolver.getReference(this, srcObject, xmlField);
                    if (reference == null) {
                        reference = new Reference(this, srcObject, this.referenceClass, new HashMap(), container);
                        resolver.addReference(reference);
                    }
                    if ((pks = (CacheId)(primaryKeyMap = reference.getPrimaryKeyMap()).get(null)) != null) continue;
                    Object[] pkValues = new Object[1];
                    pks = new CacheId(pkValues);
                    primaryKeyMap.put(null, pks);
                }
            } else {
                pks.add(object);
            }
        } else {
            XMLField tgtFld = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xmlField);
            String tgtXPath = tgtFld.getXPath();
            HashMap primaryKeyMap = reference.getPrimaryKeyMap();
            CacheId pks = (CacheId)primaryKeyMap.get(tgtXPath);
            ClassDescriptor descriptor = session.getClassDescriptor(this.referenceClass);
            if (pks == null) {
                pks = new CacheId(new Object[0]);
                primaryKeyMap.put(tgtXPath, pks);
            }
            Class type = descriptor.getTypedField(tgtFld).getType();
            XMLConversionManager xmlConversionManager = (XMLConversionManager)session.getDatasourcePlatform().getConversionManager();
            if (this.usesSingleNode) {
                StringTokenizer stok = new StringTokenizer((String)object);
                while (stok.hasMoreTokens()) {
                    Object value = xmlConversionManager.convertObject(stok.nextToken(), type);
                    if (value != null) {
                        pks.add(value);
                    }
                    if ((reference = resolver.getReference(this, srcObject, xmlField)) == null) {
                        reference = new Reference(this, srcObject, this.referenceClass, new HashMap(), container);
                        resolver.addReference(reference);
                    }
                    if ((pks = (CacheId)(primaryKeyMap = reference.getPrimaryKeyMap()).get(null)) != null) continue;
                    pks = new CacheId(new Object[0]);
                    primaryKeyMap.put(tgtXPath, pks);
                }
            } else {
                Object value = xmlConversionManager.convertObject(object, type);
                if (value != null) {
                    pks.add(value);
                }
            }
        }
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        super.initialize(session);
        if (this.getField() != null) {
            this.setField(((ClassDescriptor)this.getDescriptor()).buildField(this.getField()));
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
    }

    @Override
    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object container = null;
        if (this.reuseContainer) {
            Object currentObject = ((XMLRecord)databaseRow).getCurrentObject();
            container = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(currentObject);
        }
        if (container == null) {
            container = cp.containerInstance();
        }
        return this.readFromRowIntoObject(databaseRow, joinManager, targetObject, parentCacheKey, sourceQuery, executionSession, isTargetProtected, container);
    }

    public Object readFromRowIntoObject(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object targetObject, CacheKey parentCacheKey, ObjectBuildingQuery sourceQuery, AbstractSession executionSession, boolean isTargetProtected, Object container) throws DatabaseException {
        sourceQuery.getSession().getClassDescriptor(this.getReferenceClass());
        if (container == null) {
            this.readFromRowIntoObject(databaseRow, joinManager, targetObject, parentCacheKey, sourceQuery, executionSession, isTargetProtected);
        }
        for (XMLField fld : this.getFields()) {
            Object fieldValue = databaseRow.getValues(fld);
            if (fieldValue == null || fieldValue instanceof String || !(fieldValue instanceof Vector)) {
                return container;
            }
            for (Object nextValue : (Vector)fieldValue) {
                DOMRecord domRecord = (DOMRecord)databaseRow;
                this.buildReference(domRecord.getCurrentObject(), fld, nextValue, sourceQuery.getSession(), container, domRecord.getReferenceResolver());
            }
        }
        return null;
    }

    @Override
    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        if (this.containerPolicy instanceof MapContainerPolicy) {
            ((MapContainerPolicy)this.containerPolicy).setElementClass(this.getReferenceClass());
        }
    }

    @Override
    public void useCollectionClass(Class concreteContainerClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteContainerClass));
    }

    @Override
    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void useListClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new ListContainerPolicy(concreteContainerClassName));
    }

    @Override
    public void useMapClass(Class concreteContainerClass, String methodName) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteContainerClass);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    @Override
    public void useMapClassName(String concreteContainerClass, String methodName) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        MapContainerPolicy policy = new MapContainerPolicy(concreteContainerClass);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }

    @Override
    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    @Override
    public void setUsesSingleNode(boolean useSingleNode) {
        this.usesSingleNode = useSingleNode;
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        for (XMLField xmlField : this.getFields()) {
            QName schemaType;
            Object fieldValue;
            Object objectValue;
            ContainerPolicy cp = this.getContainerPolicy();
            Object collection = ((AttributeAccessor)this.getAttributeAccessor()).getAttributeValueFromObject(object);
            if (collection == null) {
                return;
            }
            StringBuilder stringValueBuilder = new StringBuilder();
            Object iterator = cp.iteratorFor(collection);
            if (this.usesSingleNode()) {
                while (cp.hasNext(iterator)) {
                    String newValue;
                    objectValue = cp.next(iterator, session);
                    fieldValue = this.buildFieldValue(objectValue, xmlField, session);
                    if (fieldValue == null || (newValue = this.getValueToWrite(schemaType = this.getSchemaType(xmlField, fieldValue, session), fieldValue, session)) == null) continue;
                    stringValueBuilder.append(newValue);
                    if (!cp.hasNext(iterator)) continue;
                    stringValueBuilder.append(SPACE);
                }
                if (stringValueBuilder.length() <= 0) continue;
                row.put(xmlField, (Object)stringValueBuilder.toString());
                continue;
            }
            ArrayList<String> keyValues = new ArrayList<String>();
            while (cp.hasNext(iterator)) {
                objectValue = cp.next(iterator, session);
                fieldValue = this.buildFieldValue(objectValue, xmlField, session);
                if (fieldValue == null) continue;
                schemaType = this.getSchemaType(xmlField, fieldValue, session);
                String stringValue = this.getValueToWrite(schemaType, fieldValue, session);
                keyValues.add(stringValue);
            }
            row.put(xmlField, (Object)keyValues);
        }
    }

    @Override
    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        for (XMLField xmlField : this.getFields()) {
            Object fieldValue = this.buildFieldValue(value, xmlField, session);
            if (fieldValue == null) continue;
            QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
            String stringValue = this.getValueToWrite(schemaType, fieldValue, session);
            row.add(xmlField, stringValue);
        }
    }

    @Override
    public boolean isCollectionMapping() {
        return true;
    }

    @Override
    public boolean getReuseContainer() {
        return this.reuseContainer;
    }

    @Override
    public void setReuseContainer(boolean reuseContainer) {
        this.reuseContainer = reuseContainer;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.defaultEmptyContainer;
    }

    @Override
    public void setDefaultEmptyContainer(boolean defaultEmptyContainer) {
        this.defaultEmptyContainer = defaultEmptyContainer;
    }

    @Override
    public AbstractNullPolicy getWrapperNullPolicy() {
        return this.wrapperNullPolicy;
    }

    @Override
    public void setWrapperNullPolicy(AbstractNullPolicy policy) {
        this.wrapperNullPolicy = policy;
    }
}

