/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathPredicate;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.oxm.record.XMLEntry;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLNodeList;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UnmarshalXPathEngine<XML_FIELD extends Field> {
    private static UnmarshalXPathEngine instance = null;
    private XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();

    public static UnmarshalXPathEngine getInstance() {
        if (instance == null) {
            instance = new UnmarshalXPathEngine();
        }
        return instance;
    }

    public Object selectSingleNode(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver, boolean checkForXsiNil) throws XMLMarshalException {
        Object result2;
        block7: {
            block6: {
                try {
                    if (contextNode != null) break block6;
                    return null;
                }
                catch (Exception x) {
                    throw XMLMarshalException.invalidXPathString(xmlField.getXPath(), x);
                }
            }
            XPathFragment xPathFragment = xmlField.getXPathFragment();
            if (xPathFragment.shouldExecuteSelectNodes()) {
                return this.xmlPlatform.selectSingleNodeAdvanced(contextNode, xmlField.getXPath(), xmlNamespaceResolver);
            }
            result2 = this.selectSingleNode(contextNode, xPathFragment, xmlNamespaceResolver, checkForXsiNil);
            if (result2 != XMLRecord.noEntry) break block7;
            if (xmlField.getLastXPathFragment().nameIsText() || xmlField.getLastXPathFragment().isAttribute()) {
                return result2;
            }
            return null;
        }
        return result2;
    }

    public Object selectSingleNode(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver) throws XMLMarshalException {
        return this.selectSingleNode(contextNode, xmlField, xmlNamespaceResolver, false);
    }

    private Object selectSingleNode(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, boolean checkForXsiNil) {
        String nil;
        Node resultNode = this.getSingleNode(contextNode, xPathFragment, xmlNamespaceResolver);
        if (checkForXsiNil && (nil = ((Element)contextNode).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil")).equals("true")) {
            return XMLRecord.NIL;
        }
        if (resultNode == null) {
            if (!xPathFragment.nameIsText()) {
                return XMLRecord.noEntry;
            }
            return null;
        }
        if (xPathFragment.getNextFragment() == null) {
            return resultNode;
        }
        return this.selectSingleNode(resultNode, xPathFragment.getNextFragment(), xmlNamespaceResolver, checkForXsiNil);
    }

    public NodeList selectNodes(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver) throws XMLMarshalException {
        return this.selectNodes(contextNode, xmlField, xmlNamespaceResolver, null);
    }

    public NodeList selectNodes(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver, AbstractNullPolicy nullPolicy) throws XMLMarshalException {
        return this.selectNodes(contextNode, xmlField, xmlNamespaceResolver, nullPolicy, false);
    }

    public NodeList selectNodes(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver, AbstractNullPolicy nullPolicy, boolean omitText) throws XMLMarshalException {
        return this.selectNodes(contextNode, xmlField, xmlNamespaceResolver, nullPolicy, omitText, true);
    }

    public NodeList selectNodes(Node contextNode, XML_FIELD xmlField, XMLNamespaceResolver xmlNamespaceResolver, AbstractNullPolicy nullPolicy, boolean omitText, boolean concatinateTextNodes) {
        block4: {
            try {
                if (contextNode != null) break block4;
                return null;
            }
            catch (Exception x) {
                throw XMLMarshalException.invalidXPathString(xmlField.getXPath(), x);
            }
        }
        XPathFragment xPathFragment = xmlField.getXPathFragment();
        if (xPathFragment.shouldExecuteSelectNodes()) {
            return this.xmlPlatform.selectNodesAdvanced(contextNode, xmlField.getXPath(), xmlNamespaceResolver);
        }
        return this.selectNodes(contextNode, xPathFragment, xmlNamespaceResolver, nullPolicy, omitText, concatinateTextNodes);
    }

    public List<XMLEntry> selectNodes(Node contextNode, List<XML_FIELD> xmlFields, XMLNamespaceResolver xmlNamespaceResolver) throws XMLMarshalException {
        ArrayList<XMLEntry> nodes = new ArrayList<XMLEntry>();
        ArrayList<XPathFragment> firstFragments = new ArrayList<XPathFragment>(xmlFields.size());
        for (Field nextField : xmlFields) {
            firstFragments.add(nextField.getXPathFragment());
        }
        this.selectNodes(contextNode, firstFragments, xmlNamespaceResolver, nodes);
        return nodes;
    }

    private void selectNodes(Node contextNode, List<XPathFragment> xpathFragments, XMLNamespaceResolver xmlNamespaceResolver, List<XMLEntry> entries) {
        NodeList childNodes = contextNode.getChildNodes();
        int i = 0;
        int size = childNodes.getLength();
        while (i < size) {
            Node nextChild = childNodes.item(i);
            ArrayList<XPathFragment> matchingFragments = new ArrayList<XPathFragment>();
            for (XPathFragment nextFragment : xpathFragments) {
                if ((nextChild.getNodeType() == 3 || nextChild.getNodeType() == 4) && nextFragment.nameIsText()) {
                    this.addXMLEntry(nextChild, nextFragment.getXMLField(), entries);
                    continue;
                }
                if (nextChild.getNodeType() == 2 && nextFragment.isAttribute()) {
                    String attributeNamespaceURI = null;
                    if (nextFragment.hasNamespace()) {
                        attributeNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(nextFragment.getPrefix());
                    }
                    if (!this.sameName(nextChild, nextFragment.getLocalName()) || !this.sameNamespaceURI(nextChild, attributeNamespaceURI)) continue;
                    this.addXMLEntry(nextChild, nextFragment.getXMLField(), entries);
                    continue;
                }
                if (nextChild.getNodeType() != 1) continue;
                String elementNamespaceURI = null;
                if (nextFragment.hasNamespace()) {
                    elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(nextFragment.getPrefix());
                }
                if (!this.sameName(nextChild, nextFragment.getLocalName()) || !this.sameNamespaceURI(nextChild, elementNamespaceURI)) continue;
                if (nextFragment.getNextFragment() == null) {
                    this.addXMLEntry(nextChild, nextFragment.getXMLField(), entries);
                    continue;
                }
                matchingFragments.add(nextFragment.getNextFragment());
            }
            if (matchingFragments.size() > 0) {
                this.selectNodes(nextChild, matchingFragments, xmlNamespaceResolver, entries);
            }
            ++i;
        }
    }

    private void addXMLEntry(Node entryNode, XML_FIELD xmlField, List<XMLEntry> entries) {
        XMLEntry entry = new XMLEntry();
        entry.setValue(entryNode);
        entry.setXMLField((Field)xmlField);
        entries.add(entry);
    }

    private NodeList selectNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, AbstractNullPolicy nullPolicy, boolean omitText, boolean concatText) {
        NodeList resultNodes = this.getNodes(contextNode, xPathFragment, xmlNamespaceResolver, nullPolicy, concatText);
        if (!(xPathFragment.getNextFragment() == null || omitText && xPathFragment.getNextFragment().nameIsText())) {
            XMLNodeList result2 = new XMLNodeList();
            int numberOfResultNodes = resultNodes.getLength();
            int x = 0;
            while (x < numberOfResultNodes) {
                Node resultNode = resultNodes.item(x);
                result2.addAll(this.selectNodes(resultNode, xPathFragment.getNextFragment(), xmlNamespaceResolver, nullPolicy, omitText, concatText));
                ++x;
            }
            return result2;
        }
        return resultNodes;
    }

    private Node getSingleNode(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        if (xPathFragment.isAttribute()) {
            return this.selectSingleAttribute(contextNode, xPathFragment, xmlNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectSingleText(contextNode);
        }
        if (xPathFragment.isSelfFragment()) {
            return contextNode;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver);
    }

    private NodeList getNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, AbstractNullPolicy nullPolicy, boolean concatText) {
        if (xPathFragment.isAttribute()) {
            return this.selectAttributeNodes(contextNode, xPathFragment, xmlNamespaceResolver);
        }
        if (xPathFragment.nameIsText()) {
            return this.selectTextNodes(contextNode, nullPolicy, concatText);
        }
        if (xPathFragment.isSelfFragment()) {
            XMLNodeList xmlNodeList = new XMLNodeList(1);
            xmlNodeList.add(contextNode);
            return xmlNodeList;
        }
        if (xPathFragment.containsIndex()) {
            return this.selectElementNodes(contextNode, xPathFragment, xmlNamespaceResolver, xPathFragment.getIndexValue());
        }
        return this.selectElementNodes(contextNode, xPathFragment, xmlNamespaceResolver);
    }

    private Node selectSingleAttribute(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        if (xPathFragment.hasNamespace()) {
            if (1 == contextNode.getNodeType()) {
                String attributeNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
                return contextNode.getAttributes().getNamedItemNS(attributeNamespaceURI, xPathFragment.getLocalName());
            }
            return null;
        }
        if (1 == contextNode.getNodeType()) {
            return contextNode.getAttributes().getNamedItem(xPathFragment.getShortName());
        }
        return null;
    }

    private NodeList selectAttributeNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleAttribute(contextNode, xPathFragment, xmlNamespaceResolver);
        if (child != null) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        Node child = contextNode.getFirstChild();
        while (child != null) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() == 1 && this.sameName(child, xPathFragment.getLocalName()) && this.sameNamespaceURI(child, elementNamespaceURI)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public NodeList selectElementNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = contextNode.getFirstChild();
        while (child != null) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() == 1 && this.sameName(child, xPathFragment.getLocalName()) && this.sameNamespaceURI(child, elementNamespaceURI)) {
                XPathPredicate predicate = xPathFragment.getPredicate();
                if (predicate != null) {
                    Attr attr;
                    XPathFragment predicateFragment = predicate.getXPathFragment();
                    if (predicateFragment.isAttribute() && child.getAttributes() != null && (attr = (Attr)child.getAttributes().getNamedItemNS(predicateFragment.getNamespaceURI(), predicateFragment.getLocalName())) != null) {
                        String attribute = attr.getValue();
                        if (xPathFragment.getPredicate().getValue().equals(attribute)) {
                            xmlNodeList.add(child);
                        }
                    }
                } else {
                    xmlNodeList.add(child);
                }
            }
            child = child.getNextSibling();
        }
        return xmlNodeList;
    }

    private Node selectSingleElement(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, int position) {
        Node child = contextNode.getFirstChild();
        while (child != null) {
            String elementNamespaceURI = null;
            if (xmlNamespaceResolver != null) {
                elementNamespaceURI = xmlNamespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix());
            }
            if (child.getNodeType() == 1 && this.sameName(child, xPathFragment.getShortName()) && this.sameNamespaceURI(child, elementNamespaceURI) && --position == 0) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private NodeList selectElementNodes(Node contextNode, XPathFragment xPathFragment, XMLNamespaceResolver xmlNamespaceResolver, int position) {
        XMLNodeList xmlNodeList = new XMLNodeList();
        Node child = this.selectSingleElement(contextNode, xPathFragment, xmlNamespaceResolver, position);
        if (child != null) {
            xmlNodeList.add(child);
        }
        return xmlNodeList;
    }

    private Node selectSingleText(Node contextNode) {
        NodeList childrenNodes = contextNode.getChildNodes();
        int numberOfNodes = childrenNodes.getLength();
        if (numberOfNodes == 0) {
            return null;
        }
        if (numberOfNodes == 1) {
            Node child = childrenNodes.item(0);
            if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                return child;
            }
            return null;
        }
        String returnVal = null;
        int i = 0;
        while (i < numberOfNodes) {
            String val;
            Node next = childrenNodes.item(i);
            if ((next.getNodeType() == 3 || next.getNodeType() == 4) && (val = next.getNodeValue()) != null) {
                if (returnVal == null) {
                    returnVal = "";
                }
                if (next.getNodeType() == 4) {
                    val = val.trim();
                }
                returnVal = String.valueOf(returnVal) + val;
            }
            ++i;
        }
        if (returnVal != null) {
            return contextNode.getOwnerDocument().createTextNode(returnVal);
        }
        return null;
    }

    private NodeList selectTextNodes(Node contextNode, AbstractNullPolicy nullPolicy, boolean concatText) {
        if (!concatText) {
            return this.selectAllText(contextNode);
        }
        Node n = this.selectSingleText(contextNode);
        XMLNodeList xmlNodeList = new XMLNodeList();
        if (n == null && nullPolicy != null) {
            if (nullPolicy.valueIsNull((Element)contextNode)) {
                if (nullPolicy.getMarshalNullRepresentation() != XMLNullRepresentationType.ABSENT_NODE) {
                    xmlNodeList.add(n);
                }
            } else {
                xmlNodeList.add(contextNode.getOwnerDocument().createTextNode(""));
            }
        } else if (nullPolicy != null && nullPolicy.isNullRepresentedByXsiNil() && nullPolicy.valueIsNull((Element)contextNode)) {
            xmlNodeList.add(null);
        } else if (n != null) {
            xmlNodeList.add(n);
        }
        return xmlNodeList;
    }

    private NodeList selectAllText(Node contextNode) {
        XMLNodeList nodes = new XMLNodeList();
        NodeList children = contextNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node next = children.item(i);
            if (next.getNodeType() == 3 || next.getNodeType() == 4) {
                nodes.add(next);
            }
            ++i;
        }
        return nodes;
    }

    private boolean sameNamespaceURI(Node node, String namespaceURI) {
        String nodeNamespaceURI = node.getNamespaceURI();
        if (nodeNamespaceURI == namespaceURI) {
            return true;
        }
        if (nodeNamespaceURI == null && namespaceURI.length() == 0) {
            return true;
        }
        if (namespaceURI == null && nodeNamespaceURI.length() == 0) {
            return true;
        }
        return nodeNamespaceURI != null && nodeNamespaceURI.equals(namespaceURI);
    }

    private boolean sameName(Node node, String name) {
        return name.equals(node.getLocalName()) || name.equals(node.getNodeName());
    }
}

