/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class CascadeLockingPolicy {
    protected Class m_parentClass;
    protected ReadObjectQuery m_query;
    protected ClassDescriptor m_descriptor;
    protected ClassDescriptor m_parentDescriptor;
    protected Map<DatabaseField, DatabaseField> m_queryKeyFields;
    protected Map<DatabaseField, DatabaseField> m_mappedQueryKeyFields;
    protected Map<DatabaseField, DatabaseField> m_unmappedQueryKeyFields;
    protected DatabaseMapping m_parentMapping;
    protected boolean m_lookForParentMapping;
    protected boolean m_shouldHandleUnmappedFields;
    protected boolean m_hasCheckedForUnmappedFields;
    protected DataReadQuery m_unmappedFieldsQuery;

    public CascadeLockingPolicy(ClassDescriptor parentDescriptor, ClassDescriptor descriptor) {
        this.m_descriptor = descriptor;
        this.m_parentDescriptor = parentDescriptor;
        this.m_parentClass = this.m_parentDescriptor.getJavaClass();
    }

    protected ReadObjectQuery getQuery() {
        if (this.m_query == null) {
            this.m_query = new ReadObjectQuery(this.m_parentClass);
            Expression selectionCriteria = null;
            Iterator<DatabaseField> keys = this.m_queryKeyFields.keySet().iterator();
            ExpressionBuilder builder = new ExpressionBuilder();
            while (keys.hasNext()) {
                String keyField = keys.next().getQualifiedName();
                if (selectionCriteria == null) {
                    selectionCriteria = builder.getField(keyField).equal(builder.getParameter(keyField));
                } else {
                    selectionCriteria.and(builder.getField(keyField).equal(builder.getParameter(keyField)));
                }
                this.m_query.addArgument(keyField);
            }
            this.m_query.setSelectionCriteria(selectionCriteria);
            this.m_query.setShouldUseWrapperPolicy(false);
        }
        return this.m_query;
    }

    protected DatabaseMapping getParentMapping() {
        if (this.m_parentMapping == null && this.m_lookForParentMapping && this.m_query == null) {
            Iterator<DatabaseField> itFields = this.m_queryKeyFields.values().iterator();
            while (itFields.hasNext()) {
                DatabaseMapping mapping = this.m_descriptor.getObjectBuilder().getMappingForField(itFields.next());
                if (mapping == null) {
                    this.m_parentMapping = null;
                    break;
                }
                if (!mapping.isObjectReferenceMapping()) continue;
                if (this.m_parentMapping == null) {
                    this.m_parentMapping = mapping;
                    continue;
                }
                if (this.m_parentMapping == mapping) continue;
                this.m_parentMapping = null;
                break;
            }
        }
        return this.m_parentMapping;
    }

    protected ClassDescriptor getParentDescriptorFromInheritancePolicy(Object parentObj) {
        InheritancePolicy inheritancePolicy;
        ClassDescriptor childDescriptor;
        ClassDescriptor realParentDescriptor = this.m_parentDescriptor;
        if (realParentDescriptor.hasInheritance() && (childDescriptor = (inheritancePolicy = realParentDescriptor.getInheritancePolicy()).getDescriptor(parentObj.getClass())) != null) {
            realParentDescriptor = childDescriptor;
        }
        return realParentDescriptor;
    }

    protected AbstractRecord getMappedTranslationRow(Object changedObj, UnitOfWorkImpl uow) {
        DatabaseRecord translationRow = new DatabaseRecord();
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_mappedQueryKeyFields.entrySet()) {
            Object value = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(changedObj, entry.getValue(), uow);
            translationRow.add(entry.getKey(), value);
        }
        return translationRow;
    }

    protected AbstractRecord getUnmappedTranslationRow(Object changedObj, UnitOfWorkImpl uow) {
        DatabaseRecord unmappedFieldsQueryTranslationRow = new DatabaseRecord();
        for (DatabaseField primaryKey : this.m_descriptor.getPrimaryKeyFields()) {
            Object value = this.m_descriptor.getObjectBuilder().extractValueFromObjectForField(changedObj, primaryKey, uow);
            unmappedFieldsQueryTranslationRow.add(primaryKey, value);
        }
        List result2 = (List)uow.executeQuery((DatabaseQuery)this.m_unmappedFieldsQuery, unmappedFieldsQueryTranslationRow);
        if (result2 == null || result2.isEmpty()) {
            return null;
        }
        AbstractRecord unmappedValues = (AbstractRecord)result2.get(0);
        DatabaseRecord translationRow = new DatabaseRecord();
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_unmappedQueryKeyFields.entrySet()) {
            Object value = unmappedValues.get(entry.getValue());
            translationRow.add(entry.getKey(), value);
        }
        return translationRow;
    }

    public void initUnmappedFields(UnitOfWorkImpl uow) {
        if (!this.m_hasCheckedForUnmappedFields) {
            this.m_mappedQueryKeyFields = new HashMap<DatabaseField, DatabaseField>();
            this.m_unmappedQueryKeyFields = new HashMap<DatabaseField, DatabaseField>();
            for (Map.Entry<DatabaseField, DatabaseField> entry : this.m_queryKeyFields.entrySet()) {
                if (this.m_descriptor.getObjectBuilder().getMappingForField(entry.getValue()) == null) {
                    this.m_unmappedQueryKeyFields.put(entry.getKey(), entry.getValue());
                    continue;
                }
                this.m_mappedQueryKeyFields.put(entry.getKey(), entry.getValue());
            }
            if (this.m_unmappedQueryKeyFields.isEmpty()) {
                this.m_unmappedQueryKeyFields = null;
                this.m_mappedQueryKeyFields = this.m_queryKeyFields;
            }
            this.initUnmappedFieldsQuery(uow);
            this.m_hasCheckedForUnmappedFields = true;
        }
    }

    public void initUnmappedFieldsQuery(UnitOfWorkImpl uow) {
        if (this.m_unmappedFieldsQuery == null) {
            this.m_unmappedFieldsQuery = new DataReadQuery();
            Expression whereClause = null;
            ExpressionBuilder builder = new ExpressionBuilder();
            for (DatabaseField primaryKey : this.m_descriptor.getPrimaryKeyFields()) {
                Expression expression = ((Expression)builder).getField(primaryKey).equal(builder.getParameter(primaryKey));
                whereClause = expression.and(whereClause);
                this.m_unmappedFieldsQuery.addArgument(primaryKey.getQualifiedName());
            }
            SQLSelectStatement statement = new SQLSelectStatement();
            for (DatabaseField field2 : this.m_unmappedQueryKeyFields.values()) {
                statement.addField(field2);
            }
            statement.setWhereClause(whereClause);
            statement.normalize(uow.getParent(), this.m_descriptor);
            this.m_unmappedFieldsQuery.setSQLStatement(statement);
            this.m_unmappedFieldsQuery.setSessionName(this.m_descriptor.getSessionName());
        }
    }

    public void lockNotifyParent(Object obj, UnitOfWorkChangeSet changeSet, UnitOfWorkImpl uow) {
        Object parentObj = null;
        DatabaseMapping parentMapping = this.getParentMapping();
        if (parentMapping != null && parentMapping.isObjectReferenceMapping()) {
            parentObj = parentMapping.getRealAttributeValueFromObject(obj, uow);
        }
        if (parentObj == null) {
            AbstractRecord translationRow;
            if (this.m_shouldHandleUnmappedFields) {
                this.initUnmappedFields(uow);
                if (this.m_unmappedQueryKeyFields != null) {
                    AbstractRecord unmappedTranslationRow = this.getUnmappedTranslationRow(obj, uow);
                    if (unmappedTranslationRow == null) {
                        return;
                    }
                    translationRow = this.getMappedTranslationRow(obj, uow);
                    translationRow.putAll((Map)unmappedTranslationRow);
                } else {
                    translationRow = this.getMappedTranslationRow(obj, uow);
                }
            } else {
                translationRow = this.getMappedTranslationRow(obj, uow);
            }
            parentObj = uow.executeQuery((DatabaseQuery)this.getQuery(), translationRow);
        } else if (this.m_parentDescriptor.hasWrapperPolicy()) {
            this.m_parentDescriptor.getWrapperPolicy().unwrapObject(parentObj, uow);
        }
        ClassDescriptor realParentDescriptor = this.m_parentDescriptor;
        if (parentObj != null) {
            realParentDescriptor = this.getParentDescriptorFromInheritancePolicy(parentObj);
        }
        if (parentObj != null) {
            ObjectChangeSet ocs;
            if (realParentDescriptor.usesOptimisticLocking() && realParentDescriptor.getOptimisticLockingPolicy().isCascaded() && !(ocs = realParentDescriptor.getObjectBuilder().createObjectChangeSet(parentObj, changeSet, uow)).hasForcedChangesFromCascadeLocking()) {
                ocs.setHasForcedChangesFromCascadeLocking(true);
                changeSet.addObjectChangeSet(ocs, uow, true);
            }
            if (realParentDescriptor.hasCascadeLockingPolicies()) {
                for (CascadeLockingPolicy policy : realParentDescriptor.getCascadeLockingPolicies()) {
                    policy.lockNotifyParent(parentObj, changeSet, uow);
                }
            }
        }
    }

    public void setQueryKeyFields(Map<DatabaseField, DatabaseField> queryKeyFields) {
        this.setQueryKeyFields(queryKeyFields, true);
    }

    public void setQueryKeyFields(Map<DatabaseField, DatabaseField> queryKeyFields, boolean lookForParentMapping) {
        this.m_queryKeyFields = queryKeyFields;
        this.m_mappedQueryKeyFields = this.m_queryKeyFields;
        this.m_lookForParentMapping = lookForParentMapping;
    }

    public void setShouldHandleUnmappedFields(boolean shouldHandleUnmappedFields) {
        this.m_shouldHandleUnmappedFields = shouldHandleUnmappedFields;
    }

    public boolean shouldHandleUnmappedFields() {
        return this.m_shouldHandleUnmappedFields;
    }
}

