/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.codegen;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.internal.codegen.CodeDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;

public abstract class MethodDefinition
extends CodeDefinition {
    protected boolean isAbstract;
    protected boolean isConstructor = false;
    protected String returnType = "void";
    protected Vector argumentNames;
    protected Vector lines = new Vector();
    protected Vector exceptions = new Vector();
    protected StringBuffer storedBuffer = new StringBuffer();

    public void addException(String exceptionTypeName) {
        this.exceptions.add(exceptionTypeName);
    }

    public void addLine(String line) {
        this.storedBuffer.append(line);
        this.getLines().addElement(this.storedBuffer.toString());
        this.storedBuffer = new StringBuffer();
    }

    public void addToBuffer(String partOfLine) {
        this.storedBuffer.append(partOfLine);
    }

    private void adjustExceptions(Map typeNameMap) {
        for (String exceptionName : new Vector(this.getExceptions())) {
            String adjustedExceptionName;
            if (exceptionName.equals(adjustedExceptionName = MethodDefinition.adjustTypeName(exceptionName, typeNameMap))) continue;
            this.replaceException(exceptionName, adjustedExceptionName);
        }
    }

    private void adjustLine(String line, Map typeNameMap) {
        StringBuffer lineInProgress = new StringBuffer(line);
        Set typeNames = MethodDefinition.parseForTypeNames(lineInProgress.toString());
        for (String typeName : typeNames) {
            String adjustedTypeName;
            if (typeName.equals(adjustedTypeName = MethodDefinition.adjustTypeName(typeName, typeNameMap))) continue;
            int typeNameStartIndex = lineInProgress.toString().indexOf(typeName);
            while (typeNameStartIndex != -1) {
                lineInProgress.replace(typeNameStartIndex, typeNameStartIndex + typeName.length(), adjustedTypeName);
                typeNameStartIndex = lineInProgress.toString().indexOf(typeName);
            }
        }
        this.replaceLine(line, lineInProgress.toString());
    }

    private void adjustLines(Map typeNameMap) {
        Iterator i = new Vector(this.getLines()).iterator();
        while (i.hasNext()) {
            this.adjustLine((String)i.next(), typeNameMap);
        }
    }

    private void adjustReturnType(Map typeNameMap) {
        String adjustedReturnType = MethodDefinition.adjustTypeName(this.getReturnType(), typeNameMap);
        if (!this.getReturnType().equals(adjustedReturnType)) {
            this.setReturnType(adjustedReturnType);
        }
    }

    protected void adjustTypeNames(Map typeNameMap) {
        this.adjustReturnType(typeNameMap);
        this.adjustExceptions(typeNameMap);
        this.adjustLines(typeNameMap);
    }

    protected abstract boolean argumentsEqual(MethodDefinition var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodDefinition)) {
            return false;
        }
        MethodDefinition methodDefinition = (MethodDefinition)object;
        if (this.name == null && methodDefinition.getName() != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(methodDefinition.getName())) {
            return false;
        }
        if (!this.accessLevel.equals(methodDefinition.getAccessLevel())) {
            return false;
        }
        if (!this.returnType.equals(methodDefinition.getReturnType())) {
            return false;
        }
        if (!this.argumentsEqual(methodDefinition)) {
            return false;
        }
        return this.exceptionsEqual(methodDefinition);
    }

    protected boolean exceptionsEqual(MethodDefinition methodDefinition) {
        Object[] exceptions2;
        Object[] exceptions1 = this.getExceptions().toArray();
        if (exceptions1.length == (exceptions2 = methodDefinition.getExceptions().toArray()).length) {
            int i = 0;
            while (i < exceptions1.length) {
                if (exceptions1[i] == null && exceptions1[i] != exceptions2[i] || !exceptions1[i].equals(exceptions2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected Vector getArgumentNames() {
        if (this.argumentNames == null) {
            this.argumentNames = new Vector(5);
        }
        return this.argumentNames;
    }

    public String getArgumentName(int index) {
        return (String)this.getArgumentNames().get(index);
    }

    public Iterator argumentNames() {
        return this.getArgumentNames().iterator();
    }

    public int argumentNamesSize() {
        return this.getArgumentNames().size();
    }

    protected abstract Vector getArgumentTypeNames();

    protected abstract Vector getArgumentTypes();

    public Vector getLines() {
        return this.lines;
    }

    protected Vector getExceptions() {
        return this.exceptions;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        int hash = this.accessLevel.hashCode();
        hash ^= this.returnType.hashCode();
        hash ^= this.getArgumentTypes().hashCode();
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        if (this.name != null) {
            hash ^= this.name.hashCode();
        }
        return hash ^= this.getExceptions().hashCode();
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    protected void putTypeNamesInMap(Map typeNameMap) {
        MethodDefinition.putTypeNameInMap(this.getReturnType(), typeNameMap);
        Iterator i = this.getExceptions().iterator();
        while (i.hasNext()) {
            MethodDefinition.putTypeNameInMap((String)i.next(), typeNameMap);
        }
        i = this.getArgumentTypeNames().iterator();
        while (i.hasNext()) {
            MethodDefinition.putTypeNameInMap((String)i.next(), typeNameMap);
        }
    }

    protected void replaceException(String oldExceptionName, String newExceptionName) {
        int index = this.getExceptions().indexOf(oldExceptionName);
        this.getExceptions().remove(oldExceptionName);
        this.getExceptions().insertElementAt(newExceptionName, index);
    }

    protected void replaceLine(String oldLine, String newLine) {
        int index = this.getLines().indexOf(oldLine);
        this.getLines().remove(oldLine);
        this.getLines().insertElementAt(newLine, index);
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void setReturnType(String returnType2) {
        this.returnType = returnType2;
    }

    @Override
    public void writeBody(CodeGenerator generator) {
        if (!this.isConstructor()) {
            generator.writeType(this.getReturnType());
            generator.write(" ");
        }
        generator.write(this.getName());
        generator.write("(");
        this.writeArguments(generator);
        generator.write(")");
        if (!this.exceptions.isEmpty()) {
            this.writeThrowsClause(generator);
        }
        if (this.isAbstract()) {
            generator.write(";");
        } else {
            generator.write(" {");
            generator.cr();
            Enumeration linesEnum = this.getLines().elements();
            while (linesEnum.hasMoreElements()) {
                generator.tab();
                generator.writeln(linesEnum.nextElement());
            }
            generator.write("}");
        }
    }

    protected abstract void writeArguments(CodeGenerator var1);

    protected void writeThrowsClause(CodeGenerator generator) {
        generator.write(" throws ");
        Iterator exceptionIterator = this.exceptions.iterator();
        while (exceptionIterator.hasNext()) {
            generator.write(exceptionIterator.next());
            if (!exceptionIterator.hasNext()) continue;
            generator.write(", ");
        }
    }
}

