/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;

public class SelectedFieldsLockingPolicy
extends FieldsLockingPolicy {
    protected Map<DatabaseTable, List<DatabaseField>> lockFieldsByTable = new HashMap<DatabaseTable, List<DatabaseField>>(4);
    protected List<DatabaseField> lockFields = new ArrayList<DatabaseField>();

    public void addLockFieldName(String fieldName) {
        this.getLockFields().add(new DatabaseField(fieldName));
    }

    @Override
    public void addLockValuesToTranslationRow(ObjectLevelModifyQuery query) throws DatabaseException {
        this.verifyUsage(query.getSession());
        Object object = query.isDeleteObjectQuery() ? query.getObject() : query.getBackupClone();
        if (query.isUpdateObjectQuery()) {
            query.setShouldValidateUpdateCallCacheUse(true);
        }
        Iterator<List<DatabaseField>> fields = this.getLockFieldsByTable().values().iterator();
        while (fields.hasNext()) {
            for (DatabaseField field2 : fields.next()) {
                DatabaseMapping mapping = this.descriptor.getObjectBuilder().getMappingForField(field2);
                if (mapping == null) {
                    throw DatabaseException.specifiedLockingFieldsNotFoundInDatabase(field2.getQualifiedName());
                }
                mapping.writeFromObjectIntoRow(object, query.getTranslationRow(), query.getSession(), DatabaseMapping.WriteType.UNDEFINED);
            }
        }
    }

    @Override
    protected List<DatabaseField> getFieldsToCompare(DatabaseTable table, AbstractRecord transRow, AbstractRecord modifyRow) {
        return this.getLockFields(table);
    }

    public List<DatabaseField> getLockFields() {
        return this.lockFields;
    }

    protected List<DatabaseField> getLockFields(DatabaseTable table) {
        List<DatabaseField> temp = this.lockFieldsByTable.get(table);
        if (temp == null) {
            return Collections.EMPTY_LIST;
        }
        return temp;
    }

    protected Map<DatabaseTable, List<DatabaseField>> getLockFieldsByTable() {
        return this.lockFieldsByTable;
    }

    @Override
    public void initialize(AbstractSession session) {
        super.initialize(session);
        List<DatabaseField> lockFields = this.getLockFields();
        int size = lockFields.size();
        int index = 0;
        while (index < size) {
            DatabaseField field2 = lockFields.get(index);
            field2 = this.descriptor.buildField(field2);
            lockFields.set(index, field2);
            NonSynchronizedVector fieldsForTable = this.getLockFieldsByTable().get(field2.getTable());
            if (fieldsForTable == null) {
                fieldsForTable = NonSynchronizedVector.newInstance();
                this.getLockFieldsByTable().put(field2.getTable(), fieldsForTable);
            }
            fieldsForTable.add(field2);
            ++index;
        }
    }

    public void setLockFieldNames(List<String> lockFieldNames) {
        for (String name : lockFieldNames) {
            this.addLockFieldName(name);
        }
    }

    protected void setLockFields(List<DatabaseField> lockFields) {
        this.lockFields = lockFields;
    }

    protected void setLockFieldsByTable(Map<DatabaseTable, List<DatabaseField>> lockFieldsByTable) {
        this.lockFieldsByTable = lockFieldsByTable;
    }
}

