/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.kafka.DynamicBrokersReader;
import org.apache.storm.kafka.ZkHosts;
import org.apache.storm.kafka.trident.GlobalPartitionInformation;
import org.apache.storm.kafka.trident.IBrokerReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkBrokerReader
implements IBrokerReader {
    private static final Logger LOG = LoggerFactory.getLogger(ZkBrokerReader.class);
    List<GlobalPartitionInformation> cachedBrokers = new ArrayList<GlobalPartitionInformation>();
    DynamicBrokersReader reader;
    long lastRefreshTimeMs;
    long refreshMillis;

    public ZkBrokerReader(Map conf, String topic, ZkHosts hosts) {
        try {
            this.reader = new DynamicBrokersReader(conf, hosts.brokerZkStr, hosts.brokerZkPath, topic);
            this.cachedBrokers = this.reader.getBrokerInfo();
            this.lastRefreshTimeMs = System.currentTimeMillis();
            this.refreshMillis = (long)hosts.refreshFreqSecs * 1000L;
        }
        catch (SocketTimeoutException e) {
            LOG.warn("Failed to update brokers", e);
        }
    }

    private void refresh() {
        long currTime = System.currentTimeMillis();
        if (currTime > this.lastRefreshTimeMs + this.refreshMillis) {
            try {
                LOG.info("brokers need refreshing because " + this.refreshMillis + "ms have expired");
                this.cachedBrokers = this.reader.getBrokerInfo();
                this.lastRefreshTimeMs = currTime;
            }
            catch (SocketTimeoutException e) {
                LOG.warn("Failed to update brokers", e);
            }
        }
    }

    @Override
    public GlobalPartitionInformation getBrokerForTopic(String topic) {
        this.refresh();
        for (GlobalPartitionInformation partitionInformation : this.cachedBrokers) {
            if (!partitionInformation.topic.equals(topic)) continue;
            return partitionInformation;
        }
        return null;
    }

    @Override
    public List<GlobalPartitionInformation> getAllBrokers() {
        this.refresh();
        return this.cachedBrokers;
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

