/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.storm.kafka.MessageMetadataScheme;
import org.apache.storm.kafka.Partition;
import org.apache.storm.kafka.StringScheme;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class StringMessageAndMetadataScheme
extends StringScheme
implements MessageMetadataScheme {
    private static final long serialVersionUID = -5441841920447947374L;
    public static final String STRING_SCHEME_PARTITION_KEY = "partition";
    public static final String STRING_SCHEME_OFFSET = "offset";

    @Override
    public List<Object> deserializeMessageWithMetadata(ByteBuffer message, Partition partition, long offset) {
        String stringMessage = StringScheme.deserializeString(message);
        return new Values(new Object[]{stringMessage, partition.partition, offset});
    }

    @Override
    public Fields getOutputFields() {
        return new Fields(new String[]{"str", STRING_SCHEME_PARTITION_KEY, STRING_SCHEME_OFFSET});
    }
}

