/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.token.delegation;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class TokenInformation {
    private KafkaPrincipal owner;
    private Collection<KafkaPrincipal> renewers;
    private long issueTimestamp;
    private long maxTimestamp;
    private long expiryTimestamp;
    private String tokenId;

    public TokenInformation(String tokenId, KafkaPrincipal owner, Collection<KafkaPrincipal> renewers, long issueTimestamp, long maxTimestamp, long expiryTimestamp) {
        this.tokenId = tokenId;
        this.owner = owner;
        this.renewers = renewers;
        this.issueTimestamp = issueTimestamp;
        this.maxTimestamp = maxTimestamp;
        this.expiryTimestamp = expiryTimestamp;
    }

    public KafkaPrincipal owner() {
        return this.owner;
    }

    public String ownerAsString() {
        return this.owner.toString();
    }

    public Collection<KafkaPrincipal> renewers() {
        return this.renewers;
    }

    public Collection<String> renewersAsString() {
        ArrayList<String> renewerList = new ArrayList<String>();
        for (KafkaPrincipal renewer : this.renewers) {
            renewerList.add(renewer.toString());
        }
        return renewerList;
    }

    public long issueTimestamp() {
        return this.issueTimestamp;
    }

    public long expiryTimestamp() {
        return this.expiryTimestamp;
    }

    public void setExpiryTimestamp(long expiryTimestamp) {
        this.expiryTimestamp = expiryTimestamp;
    }

    public String tokenId() {
        return this.tokenId;
    }

    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    public boolean ownerOrRenewer(KafkaPrincipal principal) {
        return this.owner.equals(principal) || this.renewers.contains(principal);
    }

    public String toString() {
        return "TokenInformation{owner=" + this.owner + ", renewers=" + this.renewers + ", issueTimestamp=" + this.issueTimestamp + ", maxTimestamp=" + this.maxTimestamp + ", expiryTimestamp=" + this.expiryTimestamp + ", tokenId='" + this.tokenId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenInformation that = (TokenInformation)o;
        if (this.issueTimestamp != that.issueTimestamp) {
            return false;
        }
        if (this.maxTimestamp != that.maxTimestamp) {
            return false;
        }
        if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) {
            return false;
        }
        if (this.renewers != null ? !this.renewers.equals(that.renewers) : that.renewers != null) {
            return false;
        }
        return this.tokenId != null ? this.tokenId.equals(that.tokenId) : that.tokenId == null;
    }

    public int hashCode() {
        int result2 = this.owner != null ? this.owner.hashCode() : 0;
        result2 = 31 * result2 + (this.renewers != null ? this.renewers.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.issueTimestamp ^ this.issueTimestamp >>> 32);
        result2 = 31 * result2 + (int)(this.maxTimestamp ^ this.maxTimestamp >>> 32);
        result2 = 31 * result2 + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return result2;
    }
}

