/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.MultiSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RecordsSend;
import org.apache.kafka.common.requests.ResponseHeader;

public class FetchResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_HEADER_KEY_NAME = "partition_header";
    private static final String HIGH_WATERMARK_KEY_NAME = "high_watermark";
    private static final String LAST_STABLE_OFFSET_KEY_NAME = "last_stable_offset";
    private static final String LOG_START_OFFSET_KEY_NAME = "log_start_offset";
    private static final String ABORTED_TRANSACTIONS_KEY_NAME = "aborted_transactions";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String FIRST_OFFSET_KEY_NAME = "first_offset";
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V0 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("high_watermark", Type.INT64, "Last committed offset."));
    private static final Schema FETCH_RESPONSE_PARTITION_V0 = new Schema(new Field("partition_header", FETCH_RESPONSE_PARTITION_HEADER_V0), new Field("record_set", Type.RECORDS));
    private static final Schema FETCH_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(FETCH_RESPONSE_PARTITION_V0)));
    private static final Schema FETCH_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(FETCH_RESPONSE_TOPIC_V0)));
    private static final Schema FETCH_RESPONSE_V1;
    private static final Schema FETCH_RESPONSE_V2;
    private static final Schema FETCH_RESPONSE_V3;
    private static final Schema FETCH_RESPONSE_ABORTED_TRANSACTION_V4;
    private static final Schema FETCH_RESPONSE_ABORTED_TRANSACTION_V5;
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V4;
    private static final Schema FETCH_RESPONSE_PARTITION_HEADER_V5;
    private static final Schema FETCH_RESPONSE_PARTITION_V4;
    private static final Schema FETCH_RESPONSE_PARTITION_V5;
    private static final Schema FETCH_RESPONSE_TOPIC_V4;
    private static final Schema FETCH_RESPONSE_TOPIC_V5;
    private static final Schema FETCH_RESPONSE_V4;
    private static final Schema FETCH_RESPONSE_V5;
    private static final Schema FETCH_RESPONSE_V6;
    public static final Field.Int32 SESSION_ID;
    private static final Schema FETCH_RESPONSE_V7;
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    private final int throttleTimeMs;
    private final Errors error;
    private final int sessionId;
    private final LinkedHashMap<TopicPartition, PartitionData> responseData;

    public static Schema[] schemaVersions() {
        return new Schema[]{FETCH_RESPONSE_V0, FETCH_RESPONSE_V1, FETCH_RESPONSE_V2, FETCH_RESPONSE_V3, FETCH_RESPONSE_V4, FETCH_RESPONSE_V5, FETCH_RESPONSE_V6, FETCH_RESPONSE_V7};
    }

    public FetchResponse(Errors error, LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTimeMs, int sessionId) {
        this.error = error;
        this.responseData = responseData;
        this.throttleTimeMs = throttleTimeMs;
        this.sessionId = sessionId;
    }

    public FetchResponse(Struct struct) {
        LinkedHashMap<TopicPartition, PartitionData> responseData = new LinkedHashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Object[] abortedTransactionsArray;
                Struct partitionResponse = (Struct)partitionResponseObj;
                Struct partitionResponseHeader = partitionResponse.getStruct(PARTITION_HEADER_KEY_NAME);
                int partition = partitionResponseHeader.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partitionResponseHeader.get(CommonFields.ERROR_CODE));
                long highWatermark = partitionResponseHeader.getLong(HIGH_WATERMARK_KEY_NAME);
                long lastStableOffset = -1L;
                if (partitionResponseHeader.hasField(LAST_STABLE_OFFSET_KEY_NAME)) {
                    lastStableOffset = partitionResponseHeader.getLong(LAST_STABLE_OFFSET_KEY_NAME);
                }
                long logStartOffset = -1L;
                if (partitionResponseHeader.hasField(LOG_START_OFFSET_KEY_NAME)) {
                    logStartOffset = partitionResponseHeader.getLong(LOG_START_OFFSET_KEY_NAME);
                }
                Records records = partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                ArrayList<AbortedTransaction> abortedTransactions = null;
                if (partitionResponseHeader.hasField(ABORTED_TRANSACTIONS_KEY_NAME) && (abortedTransactionsArray = partitionResponseHeader.getArray(ABORTED_TRANSACTIONS_KEY_NAME)) != null) {
                    abortedTransactions = new ArrayList<AbortedTransaction>(abortedTransactionsArray.length);
                    for (Object abortedTransactionObj : abortedTransactionsArray) {
                        Struct abortedTransactionStruct = (Struct)abortedTransactionObj;
                        long producerId = abortedTransactionStruct.getLong(PRODUCER_ID_KEY_NAME);
                        long firstOffset = abortedTransactionStruct.getLong(FIRST_OFFSET_KEY_NAME);
                        abortedTransactions.add(new AbortedTransaction(producerId, firstOffset));
                    }
                }
                PartitionData partitionData = new PartitionData(error, highWatermark, lastStableOffset, logStartOffset, abortedTransactions, records);
                responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
        this.responseData = responseData;
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.getOrElse(CommonFields.ERROR_CODE, (short)0));
        this.sessionId = struct.getOrElse(SESSION_ID, 0);
    }

    @Override
    public Struct toStruct(short version) {
        return FetchResponse.toStruct(version, this.throttleTimeMs, this.error, this.responseData.entrySet().iterator(), this.sessionId);
    }

    @Override
    protected Send toSend(String dest, ResponseHeader responseHeader, short apiVersion) {
        Struct responseHeaderStruct = responseHeader.toStruct();
        Struct responseBodyStruct = this.toStruct(apiVersion);
        ByteBuffer buffer = ByteBuffer.allocate(responseHeaderStruct.sizeOf() + 4);
        buffer.putInt(responseHeaderStruct.sizeOf() + responseBodyStruct.sizeOf());
        responseHeaderStruct.writeTo(buffer);
        buffer.rewind();
        ArrayDeque<Send> sends = new ArrayDeque<Send>();
        sends.add(new ByteBufferSend(dest, buffer));
        FetchResponse.addResponseData(responseBodyStruct, this.throttleTimeMs, dest, sends);
        return new MultiSend(dest, sends);
    }

    public Errors error() {
        return this.error;
    }

    public LinkedHashMap<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public int sessionId() {
        return this.sessionId;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionData response : this.responseData.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static FetchResponse parse(ByteBuffer buffer, short version) {
        return new FetchResponse(ApiKeys.FETCH.responseSchema(version).read(buffer));
    }

    private static void addResponseData(Struct struct, int throttleTimeMs, String dest, Queue<Send> sends) {
        ByteBuffer buffer;
        Object[] allTopicData = struct.getArray(RESPONSES_KEY_NAME);
        if (struct.hasField(CommonFields.ERROR_CODE)) {
            buffer = ByteBuffer.allocate(14);
            buffer.putInt(throttleTimeMs);
            buffer.putShort(struct.get(CommonFields.ERROR_CODE));
            buffer.putInt(struct.get(SESSION_ID));
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else if (struct.hasField(CommonFields.THROTTLE_TIME_MS)) {
            buffer = ByteBuffer.allocate(8);
            buffer.putInt(throttleTimeMs);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else {
            buffer = ByteBuffer.allocate(4);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        }
        for (Object topicData : allTopicData) {
            FetchResponse.addTopicData(dest, sends, (Struct)topicData);
        }
    }

    private static void addTopicData(String dest, Queue<Send> sends, Struct topicData) {
        String topic = topicData.get(CommonFields.TOPIC_NAME);
        Object[] allPartitionData = topicData.getArray(PARTITIONS_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(Type.STRING.sizeOf(topic) + 4);
        Type.STRING.write(buffer, topic);
        buffer.putInt(allPartitionData.length);
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        for (Object partitionData : allPartitionData) {
            FetchResponse.addPartitionData(dest, sends, (Struct)partitionData);
        }
    }

    private static void addPartitionData(String dest, Queue<Send> sends, Struct partitionData) {
        Struct header = partitionData.getStruct(PARTITION_HEADER_KEY_NAME);
        Records records = partitionData.getRecords(RECORD_SET_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + 4);
        header.writeTo(buffer);
        buffer.putInt(records.sizeInBytes());
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        sends.add(new RecordsSend(dest, records));
    }

    private static Struct toStruct(short version, int throttleTimeMs, Errors error, Iterator<Map.Entry<TopicPartition, PartitionData>> partIterator, int sessionId) {
        Struct struct = new Struct(ApiKeys.FETCH.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)throttleTimeMs);
        struct.setIfExists(CommonFields.ERROR_CODE, (Object)error.code());
        struct.setIfExists(SESSION_ID, (Object)sessionId);
        List topicsData = FetchRequest.TopicAndPartitionData.batchByTopic(partIterator);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (FetchRequest.TopicAndPartitionData topicEntry : topicsData) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                short errorCode = fetchPartitionData.error.code();
                if (errorCode == Errors.KAFKA_STORAGE_ERROR.code() && version <= 5) {
                    errorCode = Errors.NOT_LEADER_FOR_PARTITION.code();
                }
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                Struct partitionDataHeader = partitionData.instance(PARTITION_HEADER_KEY_NAME);
                partitionDataHeader.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionDataHeader.set(CommonFields.ERROR_CODE, errorCode);
                partitionDataHeader.set(HIGH_WATERMARK_KEY_NAME, (Object)fetchPartitionData.highWatermark);
                if (partitionDataHeader.hasField(LAST_STABLE_OFFSET_KEY_NAME)) {
                    partitionDataHeader.set(LAST_STABLE_OFFSET_KEY_NAME, (Object)fetchPartitionData.lastStableOffset);
                    if (fetchPartitionData.abortedTransactions == null) {
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, null);
                    } else {
                        ArrayList<Struct> abortedTransactionStructs = new ArrayList<Struct>(fetchPartitionData.abortedTransactions.size());
                        for (AbortedTransaction abortedTransaction : fetchPartitionData.abortedTransactions) {
                            Struct abortedTransactionStruct = partitionDataHeader.instance(ABORTED_TRANSACTIONS_KEY_NAME);
                            abortedTransactionStruct.set(PRODUCER_ID_KEY_NAME, (Object)abortedTransaction.producerId);
                            abortedTransactionStruct.set(FIRST_OFFSET_KEY_NAME, (Object)abortedTransaction.firstOffset);
                            abortedTransactionStructs.add(abortedTransactionStruct);
                        }
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, (Object)abortedTransactionStructs.toArray());
                    }
                }
                if (partitionDataHeader.hasField(LOG_START_OFFSET_KEY_NAME)) {
                    partitionDataHeader.set(LOG_START_OFFSET_KEY_NAME, (Object)fetchPartitionData.logStartOffset);
                }
                partitionData.set(PARTITION_HEADER_KEY_NAME, (Object)partitionDataHeader);
                partitionData.set(RECORD_SET_KEY_NAME, (Object)fetchPartitionData.records);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        return struct;
    }

    public static int sizeOf(short version, Iterator<Map.Entry<TopicPartition, PartitionData>> partIterator) {
        return 4 + FetchResponse.toStruct(version, 0, Errors.NONE, partIterator, 0).sizeOf();
    }

    static {
        FETCH_RESPONSE_V3 = FETCH_RESPONSE_V2 = (FETCH_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V0))));
        FETCH_RESPONSE_ABORTED_TRANSACTION_V5 = FETCH_RESPONSE_ABORTED_TRANSACTION_V4 = new Schema(new Field(PRODUCER_ID_KEY_NAME, Type.INT64, "The producer id associated with the aborted transactions"), new Field(FIRST_OFFSET_KEY_NAME, Type.INT64, "The first offset in the aborted transaction"));
        FETCH_RESPONSE_PARTITION_HEADER_V4 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(HIGH_WATERMARK_KEY_NAME, Type.INT64, "Last committed offset."), new Field(LAST_STABLE_OFFSET_KEY_NAME, Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field(ABORTED_TRANSACTIONS_KEY_NAME, ArrayOf.nullable(FETCH_RESPONSE_ABORTED_TRANSACTION_V4)));
        FETCH_RESPONSE_PARTITION_HEADER_V5 = new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(HIGH_WATERMARK_KEY_NAME, Type.INT64, "Last committed offset."), new Field(LAST_STABLE_OFFSET_KEY_NAME, Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field(LOG_START_OFFSET_KEY_NAME, Type.INT64, "Earliest available offset."), new Field(ABORTED_TRANSACTIONS_KEY_NAME, ArrayOf.nullable(FETCH_RESPONSE_ABORTED_TRANSACTION_V5)));
        FETCH_RESPONSE_PARTITION_V4 = new Schema(new Field(PARTITION_HEADER_KEY_NAME, FETCH_RESPONSE_PARTITION_HEADER_V4), new Field(RECORD_SET_KEY_NAME, Type.RECORDS));
        FETCH_RESPONSE_PARTITION_V5 = new Schema(new Field(PARTITION_HEADER_KEY_NAME, FETCH_RESPONSE_PARTITION_HEADER_V5), new Field(RECORD_SET_KEY_NAME, Type.RECORDS));
        FETCH_RESPONSE_TOPIC_V4 = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(FETCH_RESPONSE_PARTITION_V4)));
        FETCH_RESPONSE_TOPIC_V5 = new Schema(CommonFields.TOPIC_NAME, new Field(PARTITIONS_KEY_NAME, new ArrayOf(FETCH_RESPONSE_PARTITION_V5)));
        FETCH_RESPONSE_V4 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V4)));
        FETCH_RESPONSE_V6 = FETCH_RESPONSE_V5 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V5)));
        SESSION_ID = new Field.Int32("session_id", "The fetch session ID");
        FETCH_RESPONSE_V7 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, SESSION_ID, new Field(RESPONSES_KEY_NAME, new ArrayOf(FETCH_RESPONSE_TOPIC_V5)));
    }

    public static final class PartitionData {
        public final Errors error;
        public final long highWatermark;
        public final long lastStableOffset;
        public final long logStartOffset;
        public final List<AbortedTransaction> abortedTransactions;
        public final Records records;

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, List<AbortedTransaction> abortedTransactions, Records records) {
            this.error = error;
            this.highWatermark = highWatermark;
            this.lastStableOffset = lastStableOffset;
            this.logStartOffset = logStartOffset;
            this.abortedTransactions = abortedTransactions;
            this.records = records;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.error == that.error && this.highWatermark == that.highWatermark && this.lastStableOffset == that.lastStableOffset && this.logStartOffset == that.logStartOffset && (this.abortedTransactions == null ? that.abortedTransactions == null : this.abortedTransactions.equals(that.abortedTransactions)) && (this.records == null ? that.records == null : this.records.equals(that.records));
        }

        public int hashCode() {
            int result2 = this.error != null ? this.error.hashCode() : 0;
            result2 = 31 * result2 + (int)(this.highWatermark ^ this.highWatermark >>> 32);
            result2 = 31 * result2 + (int)(this.lastStableOffset ^ this.lastStableOffset >>> 32);
            result2 = 31 * result2 + (int)(this.logStartOffset ^ this.logStartOffset >>> 32);
            result2 = 31 * result2 + (this.abortedTransactions != null ? this.abortedTransactions.hashCode() : 0);
            result2 = 31 * result2 + (this.records != null ? this.records.hashCode() : 0);
            return result2;
        }

        public String toString() {
            return "(error=" + (Object)((Object)this.error) + ", highWaterMark=" + this.highWatermark + ", lastStableOffset = " + this.lastStableOffset + ", logStartOffset = " + this.logStartOffset + ", abortedTransactions = " + this.abortedTransactions + ", recordsSizeInBytes=" + this.records.sizeInBytes() + ")";
        }
    }

    public static final class AbortedTransaction {
        public final long producerId;
        public final long firstOffset;

        public AbortedTransaction(long producerId, long firstOffset) {
            this.producerId = producerId;
            this.firstOffset = firstOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbortedTransaction that = (AbortedTransaction)o;
            return this.producerId == that.producerId && this.firstOffset == that.firstOffset;
        }

        public int hashCode() {
            int result2 = (int)(this.producerId ^ this.producerId >>> 32);
            result2 = 31 * result2 + (int)(this.firstOffset ^ this.firstOffset >>> 32);
            return result2;
        }

        public String toString() {
            return "(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }
    }
}

