/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.utils.timer.SystemTimer$;
import kafka.utils.timer.Timer;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import kafka.utils.timer.TimerTaskList;
import kafka.utils.timer.TimingWheel;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u0001%\u00111bU=ti\u0016lG+[7fe*\u00111\u0001B\u0001\u0006i&lWM\u001d\u0006\u0003\u000b\u0019\tQ!\u001e;jYNT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001!\u0002\u0005\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!!\u0002+j[\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019\u0015DXmY;u_Jt\u0015-\\3\u0011\u0005]qbB\u0001\r\u001d!\tIB\"D\u0001\u001b\u0015\tY\u0002\"\u0001\u0004=e>|GOP\u0005\u0003;1\ta\u0001\u0015:fI\u00164\u0017BA\u0010!\u0005\u0019\u0019FO]5oO*\u0011Q\u0004\u0004\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u00051A/[2l\u001bN\u0004\"a\u0003\u0013\n\u0005\u0015b!\u0001\u0002'p]\u001eD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\no\",W\r\\*ju\u0016\u0004\"aC\u0015\n\u0005)b!aA%oi\"AA\u0006\u0001B\u0001B\u0003%1%A\u0004ti\u0006\u0014H/T:\t\u000b9\u0002A\u0011A\u0018\u0002\rqJg.\u001b;?)\u0015\u0001\u0014GM\u001a5!\t\t\u0002\u0001C\u0003\u0016[\u0001\u0007a\u0003C\u0004#[A\u0005\t\u0019A\u0012\t\u000f\u001dj\u0003\u0013!a\u0001Q!9A&\fI\u0001\u0002\u0004\u0019\u0003B\u0002\u001c\u0001A\u0003%q'\u0001\u0007uCN\\W\t_3dkR|'\u000f\u0005\u00029\u007f5\t\u0011H\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qj\u0014\u0001B;uS2T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002As\tyQ\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004C\u0001\u0001\u0006IaQ\u0001\u000bI\u0016d\u0017-_)vKV,\u0007c\u0001\u001dE\r&\u0011Q)\u000f\u0002\u000b\t\u0016d\u0017-_)vKV,\u0007CA\tH\u0013\tA%AA\u0007US6,'\u000fV1tW2K7\u000f\u001e\u0005\u0007\u0015\u0002\u0001\u000b\u0011B&\u0002\u0017Q\f7o[\"pk:$XM\u001d\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001df\na!\u0019;p[&\u001c\u0017B\u0001)N\u00055\tEo\\7jG&sG/Z4fe\"1!\u000b\u0001Q\u0001\nM\u000b1\u0002^5nS:<w\u000b[3fYB\u0011\u0011\u0003V\u0005\u0003+\n\u00111\u0002V5nS:<w\u000b[3fY\"1q\u000b\u0001Q\u0001\na\u000bQB]3bI^\u0013\u0018\u000e^3M_\u000e\\\u0007CA-]\u001b\u0005Q&BA.:\u0003\u0015awnY6t\u0013\ti&L\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u0019y\u0006\u0001)A\u0005A\u0006A!/Z1e\u0019>\u001c7\u000e\u0005\u0002bI6\t!M\u0003\u0002d5\u00061\"+Z3oiJ\fg\u000e\u001e*fC\u0012<&/\u001b;f\u0019>\u001c7.\u0003\u0002fE\nA!+Z1e\u0019>\u001c7\u000e\u0003\u0004h\u0001\u0001\u0006I\u0001[\u0001\noJLG/\u001a'pG.\u0004\"!Y5\n\u0005)\u0014'!C,sSR,Gj\\2l\u0011\u0015a\u0007\u0001\"\u0001n\u0003\r\tG\r\u001a\u000b\u0003]F\u0004\"aC8\n\u0005Ad!\u0001B+oSRDQA]6A\u0002M\f\u0011\u0002^5nKJ$\u0016m]6\u0011\u0005E!\u0018BA;\u0003\u0005%!\u0016.\\3s)\u0006\u001c8\u000eC\u0003x\u0001\u0011%\u00010A\tbI\u0012$\u0016.\\3s)\u0006\u001c8.\u00128uef$\"A\\=\t\u000bi4\b\u0019A>\u0002\u001dQLW.\u001a:UCN\\WI\u001c;ssB\u0011\u0011\u0003`\u0005\u0003{\n\u0011a\u0002V5nKJ$\u0016m]6F]R\u0014\u0018\u0010C\u0004\u0000\u0001\u0001\u0006I!!\u0001\u0002\u0011I,\u0017N\\:feR\u0004RaCA\u0002w:L1!!\u0002\r\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002\n\u0001!\t!a\u0003\u0002\u0019\u0005$g/\u00198dK\u000ecwnY6\u0015\t\u00055\u00111\u0003\t\u0004\u0017\u0005=\u0011bAA\t\u0019\t9!i\\8mK\u0006t\u0007bBA\u000b\u0003\u000f\u0001\raI\u0001\ni&lWm\\;u\u001bNDq!!\u0007\u0001\t\u0003\tY\"\u0001\u0003tSj,W#\u0001\u0015\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"\u0005A1\u000f[;uI><h\u000eF\u0001oQ\r\u0001\u0011Q\u0005\t\u0005\u0003O\tI#D\u0001\u0005\u0013\r\tY\u0003\u0002\u0002\u000bi\"\u0014X-\u00193tC\u001a,w!CA\u0018\u0005\u0005\u0005\t\u0012AA\u0019\u0003-\u0019\u0016p\u001d;f[RKW.\u001a:\u0011\u0007E\t\u0019D\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u001b'\r\t\u0019D\u0003\u0005\b]\u0005MB\u0011AA\u001d)\t\t\t\u0004\u0003\u0006\u0002>\u0005M\u0012\u0013!C\u0001\u0003\u007f\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA!U\r\u0019\u00131I\u0016\u0003\u0003\u000b\u0002B!a\u0012\u0002R5\u0011\u0011\u0011\n\u0006\u0005\u0003\u0017\ni%A\u0005v]\u000eDWmY6fI*\u0019\u0011q\n\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002T\u0005%#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011qKA\u001a#\u0003%\t!!\u0017\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYFK\u0002)\u0003\u0007B!\"a\u0018\u00024E\u0005I\u0011AA \u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class SystemTimer
implements Timer {
    public final String kafka$utils$timer$SystemTimer$$executorName;
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue;
    private final AtomicInteger taskCounter;
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Function1<TimerTaskEntry, BoxedUnit> reinsert;

    public static long $lessinit$greater$default$4() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$3();
    }

    public static long $lessinit$greater$default$2() {
        return SystemTimer$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void add(TimerTask timerTask) {
        this.readLock.lock();
        try {
            this.addTimerTaskEntry(new TimerTaskEntry(timerTask, timerTask.delayMs() + Time.SYSTEM.hiResClockMs()));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskEntry timerTaskEntry) {
        block0: {
            if (this.timingWheel.add(timerTaskEntry) || timerTaskEntry.cancelled()) break block0;
            this.taskExecutor.submit(timerTaskEntry.timerTask());
        }
    }

    @Override
    public boolean advanceClock(long timeoutMs) {
        boolean bl;
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this.reinsert);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    public SystemTimer(String executorName, long tickMs, int wheelSize, long startMs) {
        this.kafka$utils$timer$SystemTimer$$executorName = executorName;
        this.taskExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(this){
            private final /* synthetic */ SystemTimer $outer;

            public Thread newThread(Runnable runnable) {
                return KafkaThread.nonDaemon("executor-" + this.$outer.kafka$utils$timer$SystemTimer$$executorName, runnable);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.delayQueue = new DelayQueue();
        this.taskCounter = new AtomicInteger(0);
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.reinsert = (Function1<TimerTaskEntry, Object> & Serializable & scala.Serializable)timerTaskEntry -> {
            this.addTimerTaskEntry(timerTaskEntry);
            return BoxedUnit.UNIT;
        };
    }
}

