/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import kafka.utils.json.JsonValue;
import kafka.utils.json.JsonValue$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Json$ {
    public static Json$ MODULE$;
    private final ObjectMapper mapper;

    static {
        new Json$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    public Option<JsonValue> parseFull(String input) {
        Option option;
        try {
            option = Option$.MODULE$.apply(this.mapper().readTree(input)).map((Function1<JsonNode, JsonValue> & Serializable & scala.Serializable)x$1 -> JsonValue$.MODULE$.apply((JsonNode)x$1));
        }
        catch (JsonProcessingException jsonProcessingException) {
            String escapedInput = input.replaceAll("\\\\", "\\\\\\\\");
            try {
                option = Option$.MODULE$.apply(this.mapper().readTree(escapedInput)).map((Function1<JsonNode, JsonValue> & Serializable & scala.Serializable)x$2 -> JsonValue$.MODULE$.apply((JsonNode)x$2));
            }
            catch (JsonProcessingException jsonProcessingException2) {
                option = None$.MODULE$;
            }
        }
        return option;
    }

    public Option<JsonValue> parseBytes(byte[] input) {
        Option option;
        try {
            option = Option$.MODULE$.apply(this.mapper().readTree(input)).map((Function1<JsonNode, JsonValue> & Serializable & scala.Serializable)x$3 -> JsonValue$.MODULE$.apply((JsonNode)x$3));
        }
        catch (JsonProcessingException jsonProcessingException) {
            option = None$.MODULE$;
        }
        return option;
    }

    public Either<JsonProcessingException, JsonValue> tryParseBytes(byte[] input) {
        Either either;
        try {
            either = package$.MODULE$.Right().apply(this.mapper().readTree(input)).right().map((Function1<JsonNode, JsonValue> & Serializable & scala.Serializable)x$4 -> JsonValue$.MODULE$.apply((JsonNode)x$4));
        }
        catch (JsonProcessingException e) {
            either = package$.MODULE$.Left().apply(e);
        }
        return either;
    }

    public String legacyEncodeAsString(Object obj2) {
        String string;
        block9: {
            Seq seq;
            while (true) {
                if ((seq = obj2) == null) {
                    string = "null";
                    break block9;
                }
                if (seq instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean(seq);
                    string = ((Object)BoxesRunTime.boxToBoolean(bl)).toString();
                    break block9;
                }
                if (seq instanceof String) {
                    String string2 = (String)((Object)seq);
                    string = this.mapper().writeValueAsString(string2);
                    break block9;
                }
                if (seq instanceof Number) {
                    Number number = (Number)((Object)seq);
                    string = number.toString();
                    break block9;
                }
                if (seq instanceof Map) {
                    Map map = (Map)((Object)seq);
                    string = "{" + ((TraversableOnce)map.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid map element '", "' in ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tuple2, obj2})));
                        }
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = MODULE$.legacyEncodeAsString(k) + ":" + MODULE$.legacyEncodeAsString(v);
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",") + "}";
                    break block9;
                }
                if (!ScalaRunTime$.MODULE$.isArray(seq, 1)) break;
                Seq seq2 = seq;
                obj2 = Predef$.MODULE$.genericArrayOps(seq2).toSeq();
            }
            if (seq instanceof Iterable) {
                Iterable iterable = seq;
                string = "[" + ((TraversableOnce)iterable.map((Function1<Object, String> & Serializable & scala.Serializable)obj -> MODULE$.legacyEncodeAsString(obj), Iterable$.MODULE$.canBuildFrom())).mkString(",") + "]";
            } else {
                if (seq instanceof Object) {
                    Seq seq3 = seq;
                    throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown argument of type ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{seq3.getClass(), seq3})));
                }
                throw new MatchError(seq);
            }
        }
        return string;
    }

    public String encodeAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    public byte[] encodeAsBytes(Object obj) {
        return this.mapper().writeValueAsBytes(obj);
    }

    private Json$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
    }
}

