/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.ToolsUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Integer> nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic = options.valueOf(topicOpt);
        String partitionList = options.valueOf(partitionOpt);
        long time = options.valueOf(timeOpt);
        int nOffsets = options.valueOf(nOffsetsOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.head()).topic().equals(topic)) {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})) + "kafka-list-topic.sh to verify");
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        String string = partitionList;
        String string2 = "";
        Seq partitions = !(string != null ? !string.equals(string2) : string2 != null) ? ((TopicMetadata)topicsMetadata.head()).partitionsMetadata().map((Function1<PartitionMetadata, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1.partitionId()), Seq$.MODULE$.canBuildFrom()) : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])partitionList.split(","))).map((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(GetOffsetShell$.$anonfun$main$2(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq();
        partitions.foreach((JFunction1$mcVI$sp & scala.Serializable)partitionId -> {
            Option partitionMetadataOpt = ((TopicMetadata)topicsMetadata.head()).partitionsMetadata().find((Function1<PartitionMetadata, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(GetOffsetShell$.$anonfun$main$4(partitionId, x$3)));
            Option option = partitionMetadataOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                PartitionMetadata metadata = (PartitionMetadata)some.value();
                Option<BrokerEndPoint> option2 = metadata.leader();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    BrokerEndPoint leader = (BrokerEndPoint)some2.value();
                    SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, clientId);
                    TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionId);
                    OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(time, nOffsets))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                    Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets();
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s:%d:%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(partitionId), offsets.mkString(",")})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option2)) {
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(option2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
    }

    public static final /* synthetic */ int $anonfun$main$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$main$4(int partitionId$1, PartitionMetadata x$3) {
        return x$3.partitionId() == partitionId$1;
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

