/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import kafka.cluster.BrokerEndPoint;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NetworkClientUtils;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011!DU3qY&\u001c\u0017MR3uG\",'O\u00117pG.LgnZ*f]\u0012T!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ta!\t\\8dW&twmU3oI\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u000591\r\\;ti\u0016\u0014\u0018BA\r\u0017\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u001fuI!A\b\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u00059Q.\u001a;sS\u000e\u001c\bC\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0011%\u0015\t)c%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011Af\t\u0002\b\u001b\u0016$(/[2t\u0011!q\u0003A!A!\u0002\u0013y\u0013\u0001\u0002;j[\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\n$\u0001\u0002+j[\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"!\u0003\u001d\n\u0005eR!aA%oi\"A1\b\u0001B\u0001B\u0003%A(\u0001\u0005dY&,g\u000e^%e!\tiDI\u0004\u0002?\u0005B\u0011qHC\u0007\u0002\u0001*\u0011\u0011IB\u0001\u0007yI|w\u000e\u001e \n\u0005\rS\u0011A\u0002)sK\u0012,g-\u0003\u0002F\r\n11\u000b\u001e:j]\u001eT!a\u0011\u0006\t\u0011!\u0003!\u0011!Q\u0001\n%\u000b!\u0002\\8h\u0007>tG/\u001a=u!\t\u0001$*\u0003\u0002Lc\tQAj\\4D_:$X\r\u001f;\t\u000b5\u0003A\u0011\u0001(\u0002\rqJg.\u001b;?)!y\u0005+\u0015*T)V3\u0006CA\b\u0001\u0011\u0015\u0019B\n1\u0001\u0015\u0011\u0015YB\n1\u0001\u001d\u0011\u0015\u0001C\n1\u0001\"\u0011\u0015qC\n1\u00010\u0011\u00151D\n1\u00018\u0011\u0015YD\n1\u0001=\u0011\u0015AE\n1\u0001J\u0011\u001dA\u0006A1A\u0005\ne\u000b!b]8ve\u000e,gj\u001c3f+\u0005Q\u0006CA.]\u001b\u0005!\u0013BA/%\u0005\u0011qu\u000eZ3\t\r}\u0003\u0001\u0015!\u0003[\u0003-\u0019x.\u001e:dK:{G-\u001a\u0011\t\u000f\u0005\u0004!\u0019!C\u0005E\u0006i1o\\2lKR$\u0016.\\3pkR,\u0012a\u000e\u0005\u0007I\u0002\u0001\u000b\u0011B\u001c\u0002\u001dM|7m[3u)&lWm\\;uA!9a\r\u0001b\u0001\n\u00139\u0017!\u00048fi^|'o[\"mS\u0016tG/F\u0001i!\tIG.D\u0001k\u0015\tYg%A\u0004dY&,g\u000e^:\n\u00055T'!\u0004(fi^|'o[\"mS\u0016tG\u000f\u0003\u0004p\u0001\u0001\u0006I\u0001[\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0011\u0015\t\b\u0001\"\u0011s\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\u0005M4\bCA5u\u0013\t)(N\u0001\bDY&,g\u000e\u001e*fgB|gn]3\t\u000b]\u0004\b\u0019\u0001=\u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feB\u001a\u00110!\b\u0011\u000bi\f\u0019\"!\u0007\u000f\u0007m\fiAD\u0002}\u0003\u0013q1!`A\u0004\u001d\rq\u0018Q\u0001\b\u0004\u007f\u0006\rabA \u0002\u0002%\t!&\u0003\u0002)S%\u0011QaJ\u0005\u0003K\u0019J1!a\u0003%\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\b\u0003#\tq\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0006\u0004\u0003\u0017!\u0013\u0002BA\u000b\u0003/\u0011qAQ;jY\u0012,'O\u0003\u0003\u0002\u0010\u0005E\u0001\u0003BA\u000e\u0003;a\u0001\u0001B\u0006\u0002 Y\f\t\u0011!A\u0003\u0002\u0005\u0005\"aA0%eE!\u00111EA\u0015!\rI\u0011QE\u0005\u0004\u0003OQ!a\u0002(pi\"Lgn\u001a\t\u0005\u0003W\ti#\u0004\u0002\u0002\u0012%!\u0011qFA\t\u0005=\t%m\u001d;sC\u000e$(+Z9vKN$\bbBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0006G2|7/\u001a\u000b\u0003\u0003o\u00012!CA\u001d\u0013\r\tYD\u0003\u0002\u0005+:LG\u000f")
public class ReplicaFetcherBlockingSend
implements BlockingSend {
    private final BrokerEndPoint sourceBroker;
    private final Time time;
    private final Node sourceNode;
    private final int socketTimeout;
    private final NetworkClient networkClient;

    private Node sourceNode() {
        return this.sourceNode;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        ClientResponse clientResponse;
        try {
            if (!NetworkClientUtils.awaitReady(this.networkClient(), this.sourceNode(), this.time, this.socketTimeout())) {
                throw new SocketTimeoutException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.socketTimeout())})));
            }
            ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger(this.sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
            clientResponse = NetworkClientUtils.sendAndReceive(this.networkClient(), clientRequest, this.time);
        }
        catch (Throwable e) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger(this.sourceBroker.id())).toString());
            throw e;
        }
        return clientResponse;
    }

    @Override
    public void close() {
        this.networkClient().close();
    }

    public ReplicaFetcherBlockingSend(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, Metrics metrics, Time time, int fetcherId, String clientId, LogContext logContext) {
        this.sourceBroker = sourceBroker;
        this.time = time;
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(brokerConfig.interBrokerSecurityProtocol(), JaasContext.Type.SERVER, brokerConfig, brokerConfig.interBrokerListenerName(), brokerConfig.saslMechanismInterBrokerProtocol(), brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), ((Object)BoxesRunTime.boxToInteger(sourceBroker.id())).toString()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), ((Object)BoxesRunTime.boxToInteger(fetcherId)).toString())}))).asJava(), false, channelBuilder, logContext);
        this.networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), clientId, 1, 0L, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), time, false, new ApiVersions(), logContext);
    }
}

