/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.common.requests.Resource;
import org.apache.kafka.common.requests.ResourceType;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0001\u0003\u0001\u001d\u0011A\"\u00113nS:l\u0015M\\1hKJT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0005\u0001!qA\u0003\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oOB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\b[\u0016$(/[2t\u0013\tIbCA\tLC\u001a\\\u0017-T3ue&\u001c7o\u0012:pkBD\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0007G>tg-[4\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005;\u000591m\u001c8gS\u001e\u0004\u0003\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0016\u0003\u0015\u0002\"AJ\u0018\u000e\u0003\u001dR!a\u0006\u0015\u000b\u0005%R\u0013AB2p[6|gN\u0003\u0002\u0006W)\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0013\t\u0001tEA\u0004NKR\u0014\u0018nY:\t\u0011I\u0002!\u0011!Q\u0001\n\u0015\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u0005iQ.\u001a;bI\u0006$\u0018mQ1dQ\u0016,\u0012A\u000e\t\u0003=]J!\u0001\u000f\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!Q\u0004A!A!\u0002\u00131\u0014AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\ty\u0001\u0011)\u0019!C\u0001{\u0005A!p[\"mS\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\tE!\u0001\u0002{W&\u00111\t\u0011\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0011\u0015\u0003!\u0011!Q\u0001\ny\n\u0011B_6DY&,g\u000e\u001e\u0011\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0015I%j\u0013'N!\tq\u0002\u0001C\u0003\u001c\r\u0002\u0007Q\u0004C\u0003\u0018\r\u0002\u0007Q\u0005C\u00035\r\u0002\u0007a\u0007C\u0003=\r\u0002\u0007a\bC\u0004P\u0001\t\u0007I\u0011\u0002)\u0002\u001dQ|\u0007/[2QkJ<\u0017\r^8ssV\t\u0011\u000bE\u0002\u001f%RK!a\u0015\u0002\u00033\u0011+G.Y=fI>\u0003XM]1uS>t\u0007+\u001e:hCR|'/\u001f\t\u0003=UK!A\u0016\u0002\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0007B\u0002-\u0001A\u0003%\u0011+A\bu_BL7\rU;sO\u0006$xN]=!\u0011\u001dQ\u0006A1A\u0005\nm\u000bQ\"\u00193nS:T6n\u00117jK:$X#\u0001/\u0011\u0005}j\u0016B\u00010A\u00055\tE-\\5o5.\u001cE.[3oi\"1\u0001\r\u0001Q\u0001\nq\u000ba\"\u00193nS:T6n\u00117jK:$\b\u0005C\u0004c\u0001\t\u0007I\u0011B2\u0002#\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u00170F\u0001e!\rIQmZ\u0005\u0003M*\u0011aa\u00149uS>t\u0007C\u00015m\u001b\u0005I'B\u00016l\u0003\u0019\u0001x\u000e\\5ds*\u00111AK\u0005\u0003[&\u0014\u0011c\u0011:fCR,Gk\u001c9jGB{G.[2z\u0011\u0019y\u0007\u0001)A\u0005I\u0006\u00112M]3bi\u0016$v\u000e]5d!>d\u0017nY=!\u0011\u001d\t\bA1A\u0005\nI\f\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\u0005\u0019\bcA\u0005fiB\u0011\u0001.^\u0005\u0003m&\u0014\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0011\u0019A\b\u0001)A\u0005g\u0006\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!\u0011\u0015Q\b\u0001\"\u0001|\u0003eA\u0017m\u001d#fY\u0006LX\r\u001a+pa&\u001cw\n]3sCRLwN\\:\u0016\u0003q\u0004\"!C?\n\u0005yT!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003\u0005\"(/_\"p[BdW\r^3EK2\f\u00170\u001a3U_BL7m\u00149fe\u0006$\u0018n\u001c8t)\u0011\t)!a\u0003\u0011\u0007%\t9!C\u0002\u0002\n)\u0011A!\u00168ji\"9\u0011QB@A\u0002\u0005=\u0011!\u0002;pa&\u001c\u0007\u0003BA\t\u0003?qA!a\u0005\u0002\u001cA\u0019\u0011Q\u0003\u0006\u000e\u0005\u0005]!bAA\r\r\u00051AH]8pizJ1!!\b\u000b\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011EA\u0012\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0004\u0006\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005a1M]3bi\u0016$v\u000e]5dgRQ\u0011QAA\u0016\u0003k\tI$a\u001c\t\u0011\u00055\u0012Q\u0005a\u0001\u0003_\tq\u0001^5nK>,H\u000fE\u0002\n\u0003cI1!a\r\u000b\u0005\rIe\u000e\u001e\u0005\b\u0003o\t)\u00031\u0001}\u000311\u0018\r\\5eCR,wJ\u001c7z\u0011!\tY$!\nA\u0002\u0005u\u0012AC2sK\u0006$X-\u00138g_BA\u0011qHA#\u0003\u001f\tI%\u0004\u0002\u0002B)\u0019\u00111\t\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#aA'baB!\u00111JA5\u001d\u0011\ti%a\u0019\u000f\t\u0005=\u0013q\f\b\u0005\u0003#\niF\u0004\u0003\u0002T\u0005mc\u0002BA+\u00033rA!!\u0006\u0002X%\ta&\u0003\u0002-[%\u0011QaK\u0005\u0003S)J1!!\u0019)\u0003!\u0011X-];fgR\u001c\u0018\u0002BA3\u0003O\n1c\u0011:fCR,Gk\u001c9jGN\u0014V-];fgRT1!!\u0019)\u0013\u0011\tY'!\u001c\u0003\u0019Q{\u0007/[2EKR\f\u0017\u000e\\:\u000b\t\u0005\u0015\u0014q\r\u0005\t\u0003c\n)\u00031\u0001\u0002t\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\b\u0013\u0005U\u0014\u0011PA\u0003\u0013\r\t9H\u0003\u0002\n\rVt7\r^5p]F\u0002\u0002\"a\u0010\u0002F\u0005=\u00111\u0010\t\u0005\u0003{\ny(\u0004\u0002\u0002h%!\u0011\u0011QA4\u0005!\t\u0005/[#se>\u0014\bbBAC\u0001\u0011\u0005\u0011qQ\u0001\rI\u0016dW\r^3U_BL7m\u001d\u000b\t\u0003\u000b\tI)a#\u0002\u0016\"A\u0011QFAB\u0001\u0004\ty\u0003\u0003\u0005\u0002\u000e\u0006\r\u0005\u0019AAH\u0003\u0019!x\u000e]5dgB1\u0011qHAI\u0003\u001fIA!a%\u0002B\t\u00191+\u001a;\t\u0011\u0005E\u00141\u0011a\u0001\u0003/\u0003r!CA;\u00033\u000b)\u0001\u0005\u0005\u0002@\u0005\u0015\u0013qBAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQQ\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002&\u0006}%AB#se>\u00148\u000fC\u0004\u0002*\u0002!\t!a+\u0002!\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cH\u0003DA\u0003\u0003[\u000by+!2\u0002H\u0006]\u0007\u0002CA\u0017\u0003O\u0003\r!a\f\t\u0011\u0005E\u0016q\u0015a\u0001\u0003g\u000bQB\\3x!\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA \u0003\u000b\ny!!.\u0011\t\u0005]\u0016\u0011Y\u0007\u0003\u0003sSA!a/\u0002>\u0006)\u0011\rZ7j]*\u0019\u0011q\u0018\u0016\u0002\u000f\rd\u0017.\u001a8ug&!\u00111YA]\u00055qUm\u001e)beRLG/[8og\"9\u0011qGAT\u0001\u0004a\b\u0002CAe\u0003O\u0003\r!a3\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5)\u0003\u001dqW\r^<pe.LA!!6\u0002P\naA*[:uK:,'OT1nK\"A\u0011\u0011\\AT\u0001\u0004\t\u0019(\u0001\u0005dC2d'-Y2l\u0011\u001d\ti\u000e\u0001C\u0001\u0003?\fq\u0002Z3tGJL'-Z\"p]\u001aLwm\u001d\u000b\u0007\u0003C\f90a@\u0011\u0011\u0005}\u0012QIAr\u0003S\u0004B!! \u0002f&!\u0011q]A4\u0005!\u0011Vm]8ve\u000e,\u0007\u0003BAv\u0003ctA!! \u0002n&!\u0011q^A4\u0003]!Um]2sS\n,7i\u001c8gS\u001e\u001c(+Z:q_:\u001cX-\u0003\u0003\u0002t\u0006U(AB\"p]\u001aLwM\u0003\u0003\u0002p\u0006\u001d\u0004\u0002CA}\u00037\u0004\r!a?\u0002+I,7o\\;sG\u0016$vnQ8oM&<g*Y7fgBA\u0011qHA#\u0003G\fi\u0010\u0005\u0003\nK\u0006=\u0005b\u0002B\u0001\u00037\u0004\r\u0001`\u0001\u0010S:\u001cG.\u001e3f'ftwN\\=ng\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0011\u0001D1mi\u0016\u00148i\u001c8gS\u001e\u001cHC\u0002B\u0005\u0005\u0017\u0011i\u0002\u0005\u0005\u0002@\u0005\u0015\u00131]A>\u0011!\u0011iAa\u0001A\u0002\t=\u0011aB2p]\u001aLwm\u001d\t\t\u0003\u007f\t)%a9\u0003\u0012A!!1\u0003B\r\u001d\u0011\tiH!\u0006\n\t\t]\u0011qM\u0001\u0014\u00032$XM]\"p]\u001aLwm\u001d*fcV,7\u000f^\u0005\u0005\u0003g\u0014YB\u0003\u0003\u0003\u0018\u0005\u001d\u0004bBA\u001c\u0005\u0007\u0001\r\u0001 \u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0003!\u0019\b.\u001e;e_^tGCAA\u0003\u0011\u001d\u00119\u0003\u0001C\u0005\u0005S\taC]3t_V\u00148-\u001a(b[\u0016$vN\u0011:pW\u0016\u0014\u0018\n\u001a\u000b\u0005\u0003_\u0011Y\u0003\u0003\u0005\u0003.\t\u0015\u0002\u0019AA\b\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005g\taB\u0019:pW\u0016\u00148+\u001f8p]fl7\u000f\u0006\u0003\u00036\t\u001d\u0003C\u0002B\u001c\u0005\u0003\nyA\u0004\u0003\u0003:\tub\u0002BA\u000b\u0005wI\u0011aC\u0005\u0004\u0005\u007fQ\u0011a\u00029bG.\fw-Z\u0005\u0005\u0005\u0007\u0012)E\u0001\u0003MSN$(b\u0001B \u0015!A!\u0011\nB\u0018\u0001\u0004\ty!\u0001\u0003oC6,\u0007b\u0002B'\u0001\u0011%!qJ\u0001\u000bG>tg-[4UsB,GC\u0002B)\u0005G\u0012)\u0007\u0005\u0003\u0003T\tuc\u0002\u0002B+\u00053j!Aa\u0016\u000b\u0005mA\u0013\u0002\u0002B.\u0005/\n\u0011bQ8oM&<G)\u001a4\n\t\t}#\u0011\r\u0002\u0005)f\u0004XM\u0003\u0003\u0003\\\t]\u0003\u0002\u0003B%\u0005\u0017\u0002\r!a\u0004\t\u0011\t\u001d$1\na\u0001\u0005k\t\u0001b]=o_:LXn\u001d\u0005\b\u0005W\u0002A\u0011\u0002B7\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002Ba\u001c\u0003x\te$1\u0010\t\u0007\u0005o\u0011\tE!\u001d\u0011\t\u0005-(1O\u0005\u0005\u0005k\n)PA\u0007D_:4\u0017nZ*z]>t\u00170\u001c\u0005\t\u0005\u0013\u0012I\u00071\u0001\u0002\u0010!A!q\rB5\u0001\u0004\u0011)\u0004C\u0004\u0003~\t%\u0004\u0019\u0001?\u0002\u0017%\u001c8+\u001a8tSRLg/\u001a\u0005\b\u0005\u0003\u0003A\u0011\u0002BB\u0003Y\u0019'/Z1uKR{\u0007/[2D_:4\u0017nZ#oiJLH\u0003\u0003BC\u00053\u0013IK!0\u0015\r\t\u001d%Q\u0012BH!\u0011\tYO!#\n\t\t-\u0015Q\u001f\u0002\f\u0007>tg-[4F]R\u0014\u0018\u0010\u0003\u0005\u0003J\t}\u0004\u0019AA\b\u0011!\u0011\tJa A\u0002\tM\u0015!\u0002<bYV,\u0007cA\u0005\u0003\u0016&\u0019!q\u0013\u0006\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003\u001c\n}\u0004\u0019\u0001BO\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0003 \n\u0015VB\u0001BQ\u0015\r\u0011\u0019\u000bB\u0001\u0004Y><\u0017\u0002\u0002BT\u0005C\u0013\u0011\u0002T8h\u0007>tg-[4\t\u0011\t-&q\u0010a\u0001\u0005[\u000b!\u0002^8qS\u000e\u0004&o\u001c9t!\u0011\u0011yK!/\u000e\u0005\tE&\u0002\u0002BZ\u0005k\u000bA!\u001e;jY*\u0011!qW\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003<\nE&A\u0003)s_B,'\u000f^5fg\"9!\u0011\u0001B@\u0001\u0004a\bb\u0002Ba\u0001\u0011%!1Y\u0001\u0018GJ,\u0017\r^3Ce>\\WM]\"p]\u001aLw-\u00128uef$bA!2\u0003L\n=GC\u0002BD\u0005\u000f\u0014I\r\u0003\u0005\u0003J\t}\u0006\u0019AA\b\u0011!\u0011\tJa0A\u0002\tM\u0005b\u0002Bg\u0005\u007f\u0003\r\u0001`\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jO\"9!\u0011\u0001B`\u0001\u0004a\b")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AdminManager adminManager = this;
        synchronized (adminManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().delayed() != 0;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request key ", " unblocked ", " topic requests."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{key.keyLabel(), BoxesRunTime.boxToInteger(completed)})));
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequest.TopicDetails> createInfo, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Seq brokers = this.metadataCache().getAliveBrokers().map((Function1<Broker, BrokerMetadata> & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = createInfo.map((Function1<Tuple2, CreatePartitionsMetadata> & Serializable & scala.Serializable)x0$1 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                CreateTopicsRequest.TopicDetails arguments = (CreateTopicsRequest.TopicDetails)tuple2._2();
                try {
                    Properties configs = new Properties();
                    ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.configs).asScala()).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = configs.setProperty(key, value);
                        return object;
                    });
                    LogConfig$.MODULE$.validate(configs);
                    if (!(arguments.numPartitions == -1 && arguments.replicationFactor == -1 || arguments.replicasAssignments.isEmpty())) {
                        throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                    }
                    Map<Object, Seq<Object>> assignments = !arguments.replicasAssignments.isEmpty() ? (Map<Object, Seq<Object>>)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(arguments.replicasAssignments).asScala()).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        Integer partitionId = (Integer)tuple2._1();
                        java.util.List replicas = (java.util.List)tuple2._2();
                        Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToInteger(partitionId), ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).map((Function1<Integer, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(x$1), Buffer$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom()) : AdminUtils$.MODULE$.assignReplicasToBrokers(brokers, arguments.numPartitions, arguments.replicationFactor, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                    this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignments for topic ", " are ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, assignments})));
                    Option<CreateTopicPolicy> option = this.createTopicPolicy();
                    if (option instanceof Some) {
                        BoxedUnit boxedUnit;
                        Some some = (Some)option;
                        CreateTopicPolicy policy = (CreateTopicPolicy)some.value();
                        this.adminZkClient().validateCreateOrUpdateTopic(topic, assignments, configs, false);
                        Integer numPartitions = arguments.numPartitions == -1 ? null : Predef$.MODULE$.int2Integer(arguments.numPartitions);
                        Short replicationFactor = arguments.replicationFactor == -1 ? null : Predef$.MODULE$.short2Short(arguments.replicationFactor);
                        java.util.Map<Integer, java.util.List<Integer>> replicaAssignments = arguments.replicasAssignments.isEmpty() ? null : arguments.replicasAssignments;
                        policy.validate(new CreateTopicPolicy.RequestMetadata(topic, numPartitions, replicationFactor, replicaAssignments, arguments.configs));
                        if (!validateOnly) {
                            this.adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit;
                        if (validateOnly) {
                            this.adminZkClient().validateCreateOrUpdateTopic(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.adminZkClient().createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignments, configs, false);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    } else {
                        throw new MatchError(option);
                    }
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, assignments, ApiError.NONE);
                }
                catch (Throwable throwable) {
                    CreatePartitionsMetadata createPartitionsMetadata2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof PolicyViolationException ? true : throwable2 instanceof ApiException;
                    if (bl) {
                        this.info((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, arguments})), (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable2);
                        createPartitionsMetadata2 = new CreatePartitionsMetadata(topic, (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$), ApiError.fromThrowable(throwable2));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing create topic request for topic ", " with arguments ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, arguments})), (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable3);
                        createPartitionsMetadata2 = new CreatePartitionsMetadata(topic, (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$), ApiError.fromThrowable(throwable3));
                    } else {
                        throw throwable;
                    }
                    createPartitionsMetadata = createPartitionsMetadata2;
                }
            } else {
                throw new MatchError(tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata3 = createPartitionsMetadata;
            return createPartitionsMetadata3;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1<CreatePartitionsMetadata, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$createTopics$11(x$2)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1<CreatePartitionsMetadata, Tuple2> & Serializable & scala.Serializable)createTopicMetadata -> createTopicMetadata.error().isSuccess() && !validateOnly ? new Tuple2<String, ApiError>(createTopicMetadata.topic(), new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2<String, ApiError>(createTopicMetadata.topic(), createTopicMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply(results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, metadata.toSeq(), this, responseCallback);
            Seq<Object> delayedCreateKeys = ((TraversableOnce)createInfo.keys().map((Function1<String, TopicKey> & Serializable & scala.Serializable)x$3 -> new TopicKey((String)x$3), Iterable$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, delayedCreateKeys);
        }
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = topics.map((Function1<String, DeleteTopicMetadata> & Serializable & scala.Serializable)topic -> {
            DeleteTopicMetadata deleteTopicMetadata;
            try {
                this.adminZkClient().deleteTopic((String)topic);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing delete topic request for topic ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})), (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                deleteTopicMetadata = new DeleteTopicMetadata((String)topic, Errors.forException(e));
            }
            return deleteTopicMetadata;
        }, Set$.MODULE$.canBuildFrom());
        if (timeout <= 0 || !metadata.exists((Function1<DeleteTopicMetadata, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$deleteTopics$4(x$4)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1<DeleteTopicMetadata, Tuple2> & Serializable & scala.Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                return !(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null) ? new Tuple2<String, Errors>(deleteTopicMetadata.topic(), Errors.REQUEST_TIMED_OUT) : new Tuple2<String, Errors>(deleteTopicMetadata.topic(), deleteTopicMetadata.error());
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            responseCallback.apply(results);
        } else {
            DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, metadata.toSeq(), this, responseCallback);
            Seq<Object> delayedDeleteKeys = ((SetLike)topics.map((Function1<String, TopicKey> & Serializable & scala.Serializable)x$5 -> new TopicKey((String)x$5), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedDelete, delayedDeleteKeys);
        }
    }

    public void createPartitions(int timeout, Map<String, NewPartitions> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        boolean reassignPartitionsInProgress = this.zkClient().reassignPartitionsInProgress();
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = allBrokers.map((Function1<BrokerMetadata, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger(x$6.id()), Seq$.MODULE$.canBuildFrom());
        Iterable metadata = newPartitions.map((Function1<Tuple2, CreatePartitionsMetadata> & Serializable & scala.Serializable)x0$4 -> {
            CreatePartitionsMetadata createPartitionsMetadata;
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                String topic = (String)tuple2._1();
                NewPartitions newPartition = (NewPartitions)tuple2._2();
                try {
                    if (reassignPartitionsInProgress) {
                        throw new ReassignmentInProgressException("A partition reassignment is in progress.");
                    }
                    scala.collection.immutable.Map<Object, Seq<Object>> existingAssignment = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)scala.collection.immutable.Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$5 -> {
                        Tuple2 tuple2 = x0$5;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Seq replicas = (Seq)tuple2._2();
                        Tuple2<Integer, Seq> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(topicPartition.partition())), replicas);
                        return tuple22;
                    }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    if (existingAssignment.isEmpty()) {
                        throw new UnknownTopicOrPartitionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic '", "' does not exist."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
                    }
                    int oldNumPartitions = existingAssignment.size();
                    int newNumPartitions = newPartition.totalCount();
                    int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                    if (numPartitionsIncrement < 0) {
                        throw new InvalidPartitionsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic currently has ", " partitions, which is higher than the requested ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(oldNumPartitions), BoxesRunTime.boxToInteger(newNumPartitions)})));
                    }
                    if (numPartitionsIncrement == 0) {
                        throw new InvalidPartitionsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic already has ", " partitions."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(oldNumPartitions)})));
                    }
                    Option<Map<Object, Seq<Object>>> reassignment = Option$.MODULE$.apply(newPartition.assignments()).map((Function1<java.util.List, Buffer> & Serializable & scala.Serializable)x$7 -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7).asScala()).map((Function1<java.util.List, Buffer> & Serializable & scala.Serializable)x$8 -> ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8).asScala()).map((Function1<Integer, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(x$9)), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).map((Function1<Buffer, scala.collection.immutable.Map> & Serializable & scala.Serializable)assignments -> {
                        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)((TraversableOnce)assignments.flatten(Predef$.MODULE$.$conforms())).toSet().$minus$minus(allBrokerIds);
                        if (unknownBrokers.nonEmpty()) {
                            throw new InvalidReplicaAssignmentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown broker(s) in replica assignment: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{unknownBrokers.mkString(", ")})));
                        }
                        if (assignments.size() != numPartitionsIncrement) {
                            throw new InvalidReplicaAssignmentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Increasing the number of partitions by ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(numPartitionsIncrement)})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but ", " assignments provided."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(assignments.size())})));
                        }
                        return ((TraversableOnce)((TraversableLike)assignments.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$6 -> {
                            Tuple2 tuple2 = x0$6;
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            Buffer replicas = (Buffer)tuple2._1();
                            int index = tuple2._2$mcI$sp();
                            Tuple2<Integer, Buffer> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(existingAssignment.size() + index)), replicas);
                            return tuple22;
                        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    });
                    Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, existingAssignment, allBrokers, newPartition.totalCount(), reassignment, validateOnly);
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, updatedReplicaAssignment, ApiError.NONE);
                }
                catch (AdminOperationException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable(e));
                }
                catch (ApiException e) {
                    createPartitionsMetadata = new CreatePartitionsMetadata(topic, (Map<Object, Seq<Object>>)scala.collection.Map$.MODULE$.empty(), ApiError.fromThrowable(e));
                }
            } else {
                throw new MatchError(tuple2);
            }
            CreatePartitionsMetadata createPartitionsMetadata2 = createPartitionsMetadata;
            return createPartitionsMetadata2;
        }, Iterable$.MODULE$.canBuildFrom());
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1<CreatePartitionsMetadata, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$createPartitions$9(x$10)))) {
            scala.collection.immutable.Map results = ((TraversableOnce)metadata.map((Function1<CreatePartitionsMetadata, Tuple2> & Serializable & scala.Serializable)createPartitionMetadata -> createPartitionMetadata.error().isSuccess() && !validateOnly ? new Tuple2<String, ApiError>(createPartitionMetadata.topic(), new ApiError(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2<String, ApiError>(createPartitionMetadata.topic(), createPartitionMetadata.error()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            callback.apply(results);
        } else {
            DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, metadata.toSeq(), this, callback);
            Seq<Object> delayedCreateKeys = ((SetLike)newPartitions.keySet().map((Function1<String, TopicKey> & Serializable & scala.Serializable)x$11 -> new TopicKey((String)x$11), Set$.MODULE$.canBuildFrom())).toSeq();
            this.topicPurgatory().tryCompleteElseWatch(delayedCreate, delayedCreateKeys);
        }
    }

    public Map<Resource, DescribeConfigsResponse.Config> describeConfigs(Map<Resource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return ((TraversableOnce)resourceToConfigNames.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$7 -> {
            Tuple2<Resource, DescribeConfigsResponse.Config> tuple2;
            Tuple2 tuple22 = x0$7;
            if (tuple22 != null) {
                Resource resource = (Resource)tuple22._1();
                Option configNames = (Option)tuple22._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ResourceType resourceType = resource.type();
                    if (((Object)((Object)ResourceType.TOPIC)).equals((Object)resourceType)) {
                        String topic = resource.name();
                        Topic.validate(topic);
                        Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                        config = AdminManager.createResponseConfig$1(AdminManager.allConfigs$1(logConfig), (Function2<String, Object, DescribeConfigsResponse.ConfigEntry> & Serializable & scala.Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value), configNames);
                    } else if (((Object)((Object)ResourceType.BROKER)).equals((Object)resourceType)) {
                        DescribeConfigsResponse.Config config2;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            config2 = AdminManager.createResponseConfig$1(this.config().dynamicConfig().currentDynamicDefaultConfigs(), (Function2<String, Object, DescribeConfigsResponse.ConfigEntry> & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value), configNames);
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            config2 = AdminManager.createResponseConfig$1(AdminManager.allConfigs$1(this.config()), (Function2<String, Object, DescribeConfigsResponse.ConfigEntry> & Serializable & scala.Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value), configNames);
                        } else {
                            throw new InvalidRequestException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", " or empty string, but received ", ".name"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.config().brokerId()), resource})));
                        }
                        config = config2;
                    } else {
                        throw new InvalidRequestException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported resource type: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resourceType})));
                    }
                    DescribeConfigsResponse.Config resourceConfig = config;
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), resourceConfig);
                }
                catch (Throwable e) {
                    String message = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing describe configs request for resource ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource}));
                    if (e instanceof ApiException) {
                        this.info((Function0<String> & Serializable & scala.Serializable)() -> message, (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                    } else {
                        this.error((Function0<String> & Serializable & scala.Serializable)() -> message, (Function0<Throwable> & Serializable & scala.Serializable)() -> e);
                    }
                    tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), new DescribeConfigsResponse.Config(ApiError.fromThrowable(e), Collections.emptyList()));
                }
            } else {
                throw new MatchError(tuple22);
            }
            Tuple2<Resource, DescribeConfigsResponse.Config> tuple23 = tuple2;
            return tuple23;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<Resource, ApiError> alterConfigs(Map<Resource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return ((TraversableOnce)configs.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$10 -> {
            Tuple2<Resource, ApiError> tuple2;
            Tuple2 tuple22 = x0$10;
            if (tuple22 != null) {
                Resource resource = (Resource)tuple22._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)tuple22._2();
                try {
                    Tuple2<Resource, ApiError> tuple23;
                    ResourceType resourceType = resource.type();
                    if (((Object)((Object)ResourceType.TOPIC)).equals((Object)resourceType)) {
                        String topic = resource.name();
                        Properties properties = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1<AlterConfigsRequest.ConfigEntry, Object> & Serializable & scala.Serializable)configEntry -> properties.setProperty(configEntry.name(), configEntry.value()));
                        this.adminZkClient().validateTopicConfig(topic, properties);
                        this.validateConfigPolicy$1(ConfigResource.Type.TOPIC, resource, config);
                        if (!validateOnly) {
                            this.adminZkClient().changeTopicConfig(topic, properties);
                        }
                        tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), ApiError.NONE);
                    } else if (((Object)((Object)ResourceType.BROKER)).equals((Object)resourceType)) {
                        Option option;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            option = None$.MODULE$;
                        } else {
                            int id = this.resourceNameToBrokerId(resource.name());
                            if (id != this.config().brokerId()) {
                                throw new InvalidRequestException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected broker id, expected ", ", but received ", ".name"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.config().brokerId()), resource})));
                            }
                            option = new Some<Integer>(BoxesRunTime.boxToInteger(id));
                        }
                        None$ brokerId = option;
                        Properties configProps = new Properties();
                        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1<AlterConfigsRequest.ConfigEntry, Object> & Serializable & scala.Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                        boolean perBrokerConfig = brokerId.nonEmpty();
                        this.config().dynamicConfig().validate(configProps, perBrokerConfig);
                        this.validateConfigPolicy$1(ConfigResource.Type.BROKER, resource, config);
                        if (!validateOnly) {
                            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, perBrokerConfig));
                        }
                        tuple23 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), ApiError.NONE);
                    } else {
                        throw new InvalidRequestException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AlterConfigs is only supported for topics and brokers, but resource type is ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resourceType})));
                    }
                    tuple2 = tuple23;
                }
                catch (Throwable throwable) {
                    Tuple2<Resource, ApiError> tuple24;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof ConfigException ? true : throwable2 instanceof IllegalArgumentException;
                    if (bl) {
                        String message = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid config value for resource ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource, throwable2.getMessage()}));
                        this.info((Function0<String> & Serializable & scala.Serializable)() -> message);
                        tuple24 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), ApiError.fromThrowable(new InvalidRequestException(message, throwable2)));
                    } else if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        String message = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing alter configs request for resource ", ", config ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource, config}));
                        if (throwable3 instanceof ApiException || throwable3 instanceof PolicyViolationException) {
                            this.info((Function0<String> & Serializable & scala.Serializable)() -> message, (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable3);
                        } else {
                            this.error((Function0<String> & Serializable & scala.Serializable)() -> message, (Function0<Throwable> & Serializable & scala.Serializable)() -> throwable3);
                        }
                        tuple24 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resource), ApiError.fromThrowable(throwable3));
                    } else {
                        throw throwable;
                    }
                    tuple2 = tuple24;
                }
            } else {
                throw new MatchError(tuple22);
            }
            Tuple2<Resource, ApiError> tuple25 = tuple2;
            return tuple25;
        }, scala.collection.Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.createTopicPolicy().foreach((Function1<CreateTopicPolicy, Object> & Serializable & scala.Serializable)x$14 -> {
            x$14.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((JFunction0$mcV$sp & scala.Serializable)() -> this.alterConfigPolicy().foreach((Function1<AlterConfigPolicy, Object> & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    private int resourceNameToBrokerId(String resourceName) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(resourceName)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id must be an integer, but it is: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resourceName})));
        }
        return n;
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    private ConfigDef.Type configType(String name, List<String> synonyms) {
        ConfigDef.Type configType = this.config().typeOf(name);
        return configType != null ? configType : (ConfigDef.Type)((Object)synonyms.iterator().map((Function1<String, ConfigDef.Type> & Serializable & scala.Serializable)x$1 -> this.config().typeOf((String)x$1)).find((Function1<ConfigDef.Type, Object> & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$configType$2(x$16))).orNull(Predef$.MODULE$.$conforms()));
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name2, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        synonyms.foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        synonyms.foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        synonyms.foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive, allSynonyms);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)allSynonyms.dropWhile((Function1<DescribeConfigsResponse.ConfigSynonym, Object> & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$configSynonyms$6(name2, s)))).toList();
    }

    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        List<?> list;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !((Object)((Object)type)).equals((Object)type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString(value, configEntryType);
        List<?> list2 = (List<?>)LogConfig$.MODULE$.TopicConfigSynonyms().get(name).map((Function1<String, List> & Serializable & scala.Serializable)s -> this.configSynonyms((String)s, this.brokerSynonyms((String)s), isSensitive)).getOrElse((Function0<List> & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            list = list2.$plus$colon(configSynonym, List$.MODULE$.canBuildFrom());
        }
        List<?> allSynonyms = list;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        GenTraversable<Object> synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, JavaConverters$.MODULE$.seqAsJavaListConverter(synonyms).asJava());
    }

    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> allNames = this.brokerSynonyms(name);
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !((Object)((Object)type)).equals((Object)type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2;
            Object object = value;
            String string3 = object instanceof String ? (string2 = (String)object) : ConfigDef.convertToString(value, configEntryType);
            string = string3;
        }
        String valueAsString = string;
        List allSynonyms = (List)this.configSynonyms(name, allNames, isSensitive).filter((Function1<DescribeConfigsResponse.ConfigSynonym, Object> & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, x$18)));
        GenTraversable synonyms = !includeSynonyms ? List$.MODULE$.empty() : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !allNames.exists((Function1<String, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$createBrokerConfigEntry$2(elem)));
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, JavaConverters$.MODULE$.seqAsJavaListConverter(synonyms).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$11(CreatePartitionsMetadata x$2) {
        return x$2.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$4) {
        Errors errors = x$4.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$9(CreatePartitionsMetadata x$10) {
        return x$10.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$12) {
        return x$12._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return ((MapLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$describeConfigs$2(x$12)))).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String configName = (String)tuple2._1();
        boolean bl = configNames$1.forall((Function1<Set, Object> & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean(x$13.contains(configName)));
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        IndexedSeq filteredConfigPairs = ((TraversableOnce)configs.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$8 -> BoxesRunTime.boxToBoolean(AdminManager.$anonfun$describeConfigs$3(configNames$1, x0$8)))).toIndexedSeq();
        IndexedSeq configEntries = filteredConfigPairs.map((Function1<Tuple2, DescribeConfigsResponse.ConfigEntry> & Serializable & scala.Serializable)x0$9 -> {
            Tuple2 tuple2 = x0$9;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String name = (String)tuple2._1();
            Object value = tuple2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createConfigEntry.apply(name, value);
            return configEntry;
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new DescribeConfigsResponse.Config(ApiError.NONE, JavaConverters$.MODULE$.seqAsJavaListConverter(configEntries).asJava());
    }

    private final void validateConfigPolicy$1(ConfigResource.Type resourceType, Resource resource$1, AlterConfigsRequest.Config config$1) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            Some some = (Some)option;
            AlterConfigPolicy policy = (AlterConfigPolicy)some.value();
            scala.collection.immutable.Map configEntriesMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config$1.entries()).asScala()).map((Function1<AlterConfigsRequest.ConfigEntry, Tuple2> & Serializable & scala.Serializable)entry -> new Tuple2<String, String>(entry.name(), entry.value()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            policy.validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resourceType, resource$1.name()), JavaConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$configType$2(ConfigDef.Type x$16) {
        return x$16 != null;
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        map.get(name).map((Function1<String, Buffer> & Serializable & scala.Serializable)value -> {
            String configValue = isSensitive$1 ? null : value;
            return allSynonyms$1.$plus$eq(new DescribeConfigsResponse.ConfigSynonym(name, configValue, source));
        });
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$1, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        String string2 = name$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$18) {
        if (perBrokerConfig$1) return true;
        DescribeConfigsResponse.ConfigSource configSource = x$18.source();
        DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        if (configSource != null) {
            if (!((Object)((Object)configSource)).equals((Object)configSource2)) return false;
            return true;
        }
        if (configSource2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$2(String elem) {
        return DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains(elem);
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.logIdent_$eq("[Admin Manager on Broker " + config.brokerId() + "]: ");
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), DelayedOperationPurgatory$.MODULE$.apply$default$3(), DelayedOperationPurgatory$.MODULE$.apply$default$4(), DelayedOperationPurgatory$.MODULE$.apply$default$5());
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
    }
}

