/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupOverview;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupSummary;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberSummary;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering$Int$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\rev!B\u0001\u0003\u0011\u0013I\u0011!D$s_V\u0004X*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005)qM]8va*\u0011QAB\u0001\fG>|'\u000fZ5oCR|'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AC\u0006\u000e\u0003\t1Q\u0001\u0004\u0002\t\n5\u0011Qb\u0012:pkBlU\r^1eCR\f7CA\u0006\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\")Qc\u0003C\u0001-\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b1-\u0011\r\u0011\"\u0003\u001a\u0003M1\u0018\r\\5e!J,g/[8vgN#\u0018\r^3t+\u0005Q\u0002\u0003B\u000e#K!r!\u0001\b\u0011\u0011\u0005u\u0001R\"\u0001\u0010\u000b\u0005}A\u0011A\u0002\u001fs_>$h(\u0003\u0002\"!\u00051\u0001K]3eK\u001aL!a\t\u0013\u0003\u00075\u000b\u0007O\u0003\u0002\"!A\u0011!BJ\u0005\u0003O\t\u0011!b\u0012:pkB\u001cF/\u0019;f!\rY\u0012&J\u0005\u0003U\u0011\u00121aU3u\u0011\u0019a3\u0002)A\u00055\u0005!b/\u00197jIB\u0013XM^5pkN\u001cF/\u0019;fg\u0002BQAL\u0006\u0005\u0002=\n\u0011\u0002\\8bI\u001e\u0013x.\u001e9\u0015\u001fA\u001ayj!)\u0004$\u000e\u00156qUBU\u0007W\u0003\"AC\u0019\u0007\u000b1\u0011\u0001A\u0001\u001a\u0014\u0007Er1\u0007\u0005\u00025o5\tQG\u0003\u00027\r\u0005)Q\u000f^5mg&\u0011\u0001(\u000e\u0002\b\u0019><w-\u001b8h\u0011!Q\u0014G!b\u0001\n\u0003Y\u0014aB4s_V\u0004\u0018\nZ\u000b\u0002yA\u00111$P\u0005\u0003}\u0011\u0012aa\u0015;sS:<\u0007\u0002\u0003!2\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0011\u001d\u0014x.\u001e9JI\u0002B\u0001BQ\u0019\u0003\u0002\u0003\u0006I!J\u0001\rS:LG/[1m'R\fG/\u001a\u0005\u0006+E\"\t\u0001\u0012\u000b\u0004a\u00153\u0005\"\u0002\u001eD\u0001\u0004a\u0004\"\u0002\"D\u0001\u0004)\u0003\u0002\u0003%2\u0005\u0004%\tAA%\u0002\t1|7m[\u000b\u0002\u0015B\u00111\nV\u0007\u0002\u0019*\u0011QJT\u0001\u0006Y>\u001c7n\u001d\u0006\u0003\u001fB\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\t&+\u0001\u0003vi&d'\"A*\u0002\t)\fg/Y\u0005\u0003+2\u0013QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007BB,2A\u0003%!*A\u0003m_\u000e\\\u0007\u0005C\u0004Zc\u0001\u0007I\u0011\u0002.\u0002\u000bM$\u0018\r^3\u0016\u0003\u0015Bq\u0001X\u0019A\u0002\u0013%Q,A\u0005ti\u0006$Xm\u0018\u0013fcR\u0011a,\u0019\t\u0003\u001f}K!\u0001\u0019\t\u0003\tUs\u0017\u000e\u001e\u0005\bEn\u000b\t\u00111\u0001&\u0003\rAH%\r\u0005\u0007IF\u0002\u000b\u0015B\u0013\u0002\rM$\u0018\r^3!\u0011\u001d1\u0017\u00071A\u0005\u0002\u001d\fA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012\u0001\u001b\t\u0004\u001f%d\u0014B\u00016\u0011\u0005\u0019y\u0005\u000f^5p]\"9A.\ra\u0001\n\u0003i\u0017\u0001\u00059s_R|7m\u001c7UsB,w\fJ3r)\tqf\u000eC\u0004cW\u0006\u0005\t\u0019\u00015\t\rA\f\u0004\u0015)\u0003i\u00035\u0001(o\u001c;pG>dG+\u001f9fA!9!/\ra\u0001\n\u0003\u0019\u0018\u0001D4f]\u0016\u0014\u0018\r^5p]&#W#\u0001;\u0011\u0005=)\u0018B\u0001<\u0011\u0005\rIe\u000e\u001e\u0005\bqF\u0002\r\u0011\"\u0001z\u0003A9WM\\3sCRLwN\\%e?\u0012*\u0017\u000f\u0006\u0002_u\"9!m^A\u0001\u0002\u0004!\bB\u0002?2A\u0003&A/A\u0007hK:,'/\u0019;j_:LE\r\t\u0005\b}F\u0002\r\u0011\"\u0003h\u0003!aW-\u00193fe&#\u0007\"CA\u0001c\u0001\u0007I\u0011BA\u0002\u00031aW-\u00193fe&#w\fJ3r)\rq\u0016Q\u0001\u0005\bE~\f\t\u00111\u0001i\u0011\u001d\tI!\rQ!\n!\f\u0011\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0011\t\u0011\u00055\u0011\u00071A\u0005\n\u001d\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0005\n\u0003#\t\u0004\u0019!C\u0005\u0003'\tA\u0002\u001d:pi>\u001cw\u000e\\0%KF$2AXA\u000b\u0011!\u0011\u0017qBA\u0001\u0002\u0004A\u0007bBA\rc\u0001\u0006K\u0001[\u0001\naJ|Go\\2pY\u0002B\u0011\"!\b2\u0005\u0004%I!a\b\u0002\u000f5,WNY3sgV\u0011\u0011\u0011\u0005\t\b\u0003G\ti\u0003PA\u0019\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003W\u0001\u0012AC2pY2,7\r^5p]&!\u0011qFA\u0013\u0005\u001dA\u0015m\u001d5NCB\u00042ACA\u001a\u0013\r\t)D\u0001\u0002\u000f\u001b\u0016l'-\u001a:NKR\fG-\u0019;b\u0011!\tI$\rQ\u0001\n\u0005\u0005\u0012\u0001C7f[\n,'o\u001d\u0011\t\u0013\u0005u\u0012G1A\u0005\n\u0005}\u0012aB8gMN,Go]\u000b\u0003\u0003\u0003\u0002\u0002\"a\t\u0002.\u0005\r\u0013\u0011\f\t\u0005\u0003\u000b\n)&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0019\u0019w.\\7p]*\u0019q!!\u0014\u000b\t\u0005=\u0013\u0011K\u0001\u0007CB\f7\r[3\u000b\u0005\u0005M\u0013aA8sO&!\u0011qKA$\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042ACA.\u0013\r\tiF\u0001\u0002\u001e\u0007>lW.\u001b;SK\u000e|'\u000fZ'fi\u0006$\u0017\r^1B]\u0012|eMZ:fi\"A\u0011\u0011M\u0019!\u0002\u0013\t\t%\u0001\u0005pM\u001a\u001cX\r^:!\u0011%\t)'\rb\u0001\n\u0013\t9'\u0001\u000bqK:$\u0017N\\4PM\u001a\u001cX\r^\"p[6LGo]\u000b\u0003\u0003S\u0002\u0002\"a\t\u0002.\u0005\r\u00131\u000e\t\u0005\u0003[\n\t(\u0004\u0002\u0002p)\u0019\u0011\u0011\n\u0004\n\t\u0005M\u0014q\u000e\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007\u0002CA<c\u0001\u0006I!!\u001b\u0002+A,g\u000eZ5oO>3gm]3u\u0007>lW.\u001b;tA!I\u00111P\u0019C\u0002\u0013%\u0011QP\u0001\"a\u0016tG-\u001b8h)J\fgn]1di&|g.\u00197PM\u001a\u001cX\r^\"p[6LGo]\u000b\u0003\u0003\u007f\u0002\u0002\"a\t\u0002.\u0005\u0005\u0015q\u0011\t\u0004\u001f\u0005\r\u0015bAAC!\t!Aj\u001c8h!!\t\u0019#!#\u0002D\u0005e\u0013bA\u0012\u0002&!A\u0011QR\u0019!\u0002\u0013\ty(\u0001\u0012qK:$\u0017N\\4Ue\u0006t7/Y2uS>t\u0017\r\\(gMN,GoQ8n[&$8\u000f\t\u0005\n\u0003#\u000b\u0004\u0019!C\u0005\u0003'\u000b!E]3dK&4X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001cXCAAK!\ry\u0011qS\u0005\u0004\u00033\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003;\u000b\u0004\u0019!C\u0005\u0003?\u000baE]3dK&4X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fGn\u00144gg\u0016$8i\\7nSR\u001cx\fJ3r)\rq\u0016\u0011\u0015\u0005\nE\u0006m\u0015\u0011!a\u0001\u0003+C\u0001\"!*2A\u0003&\u0011QS\u0001$e\u0016\u001cW-\u001b<fIR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e^:!\u0011%\tI+\ra\u0001\n\u0013\t\u0019*A\u000fsK\u000e,\u0017N^3e\u0007>t7/^7fe>3gm]3u\u0007>lW.\u001b;t\u0011%\ti+\ra\u0001\n\u0013\ty+A\u0011sK\u000e,\u0017N^3e\u0007>t7/^7fe>3gm]3u\u0007>lW.\u001b;t?\u0012*\u0017\u000fF\u0002_\u0003cC\u0011BYAV\u0003\u0003\u0005\r!!&\t\u0011\u0005U\u0016\u0007)Q\u0005\u0003+\u000baD]3dK&4X\rZ\"p]N,X.\u001a:PM\u001a\u001cX\r^\"p[6LGo\u001d\u0011\t\u0013\u0005e\u0016\u00071A\u0005\u0002\u0005M\u0015A\u00048fo6+WNY3s\u0003\u0012$W\r\u001a\u0005\n\u0003{\u000b\u0004\u0019!C\u0001\u0003\u007f\u000b!C\\3x\u001b\u0016l'-\u001a:BI\u0012,Gm\u0018\u0013fcR\u0019a,!1\t\u0013\t\fY,!AA\u0002\u0005U\u0005\u0002CAcc\u0001\u0006K!!&\u0002\u001f9,w/T3nE\u0016\u0014\u0018\t\u001a3fI\u0002Bq!!32\t\u0003\tY-\u0001\u0004j]2{7m[\u000b\u0005\u0003\u001b\f\u0019\u000e\u0006\u0003\u0002P\u0006\u0015\b\u0003BAi\u0003'd\u0001\u0001\u0002\u0005\u0002V\u0006\u001d'\u0019AAl\u0005\u0005!\u0016\u0003BAm\u0003?\u00042aDAn\u0013\r\ti\u000e\u0005\u0002\b\u001d>$\b.\u001b8h!\ry\u0011\u0011]\u0005\u0004\u0003G\u0004\"aA!os\"I\u0011q]Ad\t\u0003\u0007\u0011\u0011^\u0001\u0004MVt\u0007#B\b\u0002l\u0006=\u0017bAAw!\tAAHY=oC6,g\bC\u0004\u0002rF\"\t!a=\u0002\u0005%\u001cH\u0003BAK\u0003kDq!a>\u0002p\u0002\u0007Q%\u0001\u0006he>,\bo\u0015;bi\u0016Dq!a?2\t\u0003\ti0A\u0002o_R$B!!&\u0002\u0000\"9\u0011q_A}\u0001\u0004)\u0003b\u0002B\u0002c\u0011\u0005!QA\u0001\u0004Q\u0006\u001cH\u0003BAK\u0005\u000fAqA!\u0003\u0003\u0002\u0001\u0007A(\u0001\u0005nK6\u0014WM]%e\u0011\u001d\u0011i!\rC\u0001\u0005\u001f\t1aZ3u)\u0011\t\tD!\u0005\t\u000f\t%!1\u0002a\u0001y!9!QC\u0019\u0005\u0002\t]\u0011\u0001C5t\u0019\u0016\fG-\u001a:\u0015\t\u0005U%\u0011\u0004\u0005\b\u0005\u0013\u0011\u0019\u00021\u0001=\u0011\u0019\u0011i\"\rC\u0001w\u0005aA.Z1eKJ|%OT;mY\"1!\u0011E\u0019\u0005\u0002m\na\u0002\u001d:pi>\u001cw\u000e\\(s\u001dVdG\u000eC\u0004\u0003&E\"\tAa\n\u0002\u0007\u0005$G\rF\u0002_\u0005SA\u0001Ba\u000b\u0003$\u0001\u0007\u0011\u0011G\u0001\u0007[\u0016l'-\u001a:\t\u000f\t=\u0012\u0007\"\u0001\u00032\u00051!/Z7pm\u0016$2A\u0018B\u001a\u0011\u001d\u0011IA!\fA\u0002qBaAa\u000e2\t\u0003Q\u0016\u0001D2veJ,g\u000e^*uCR,\u0007b\u0002B\u001ec\u0011\u0005!QH\u0001\u0016]>$\u0018,\u001a;SK*|\u0017N\\3e\u001b\u0016l'-\u001a:t+\t\u0011y\u0004\u0005\u0004\u0003B\t\u001d\u0013\u0011\u0007\b\u0004\u001f\t\r\u0013b\u0001B#!\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B%\u0005\u0017\u0012A\u0001T5ti*\u0019!Q\t\t\t\u000f\t=\u0013\u0007\"\u0001\u0003R\u0005Q\u0011\r\u001c7NK6\u0014WM]:\u0016\u0005\tM\u0003#\u0002B+\u0005/bTBAA\u0015\u0013\rQ\u0013\u0011\u0006\u0005\b\u00057\nD\u0011\u0001B\u001f\u0003E\tG\u000e\\'f[\n,'/T3uC\u0012\fG/\u0019\u0005\u0007\u0005?\nD\u0011A:\u0002%I,'-\u00197b]\u000e,G+[7f_V$Xj\u001d\u0005\b\u0005G\nD\u0011\u0001B3\u0003Y9WM\\3sCR,W*Z7cKJLEmU;gM&DXC\u0001B4!\u0011\u0011IGa\u001c\u000e\u0005\t-$b\u0001B7%\u0006!A.\u00198h\u0013\rq$1\u000e\u0005\b\u0005g\nD\u0011AAJ\u00031\u0019\u0017M\u001c*fE\u0006d\u0017M\\2f\u0011\u001d\u00119(\rC\u0001\u0005s\nA\u0002\u001e:b]NLG/[8o)>$2A\u0018B>\u0011\u001d\t9P!\u001eA\u0002\u0015BaAa 2\t\u0003Y\u0014AD:fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c\u0005\b\u0005\u0007\u000bD\u0011\u0002BC\u0003I\u0019\u0017M\u001c3jI\u0006$X\r\u0015:pi>\u001cw\u000e\\:\u0016\u0005\t\u001d\u0005#\u0002BE\u0005\u001fcTB\u0001BF\u0015\u0011\u0011i)!\u000b\u0002\u0013%lW.\u001e;bE2,\u0017b\u0001\u0016\u0003\f\"9!1S\u0019\u0005\u0002\tU\u0015!E:vaB|'\u000f^:Qe>$xnY8mgR!\u0011Q\u0013BL\u0011!\u0011IJ!%A\u0002\tm\u0015aD7f[\n,'\u000f\u0015:pi>\u001cw\u000e\\:\u0011\u0007mIC\bC\u0004\u0003 F\"\tA!)\u0002%%t\u0017\u000e\u001e(fqR<UM\\3sCRLwN\u001c\u000b\u0002=\"9!QU\u0019\u0005\u0002\t\u001d\u0016!F2veJ,g\u000e^'f[\n,'/T3uC\u0012\fG/Y\u000b\u0003\u0005S\u0003Ra\u0007\u0012=\u0005W\u0003Ra\u0004BW\u0005cK1Aa,\u0011\u0005\u0015\t%O]1z!\ry!1W\u0005\u0004\u0005k\u0003\"\u0001\u0002\"zi\u0016DqA!/2\t\u0003\u0011Y,A\u0004tk6l\u0017M]=\u0016\u0005\tu\u0006c\u0001\u0006\u0003@&\u0019!\u0011\u0019\u0002\u0003\u0019\u001d\u0013x.\u001e9Tk6l\u0017M]=\t\u000f\t\u0015\u0017\u0007\"\u0001\u0003H\u0006AqN^3sm&,w/\u0006\u0002\u0003JB\u0019!Ba3\n\u0007\t5'AA\u0007He>,\bo\u0014<feZLWm\u001e\u0005\b\u0005#\fD\u0011\u0001Bj\u0003EIg.\u001b;jC2L'0Z(gMN,Go\u001d\u000b\u0006=\nU'1\u001c\u0005\t\u0003{\u0011y\r1\u0001\u0003XBA!Q\u000bBm\u0003\u0007\nI&C\u0002$\u0003SA\u0001B!8\u0003P\u0002\u0007!q\\\u0001\u0012a\u0016tG-\u001b8h)btwJ\u001a4tKR\u001c\bCB\u000e#\u0003\u0003\u000b9\tC\u0004\u0003dF\"\tA!:\u0002)=twJ\u001a4tKR\u001cu.\\7ji\u0006\u0003\b/\u001a8e)\u0015q&q\u001dBv\u0011!\u0011IO!9A\u0002\u0005\r\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\t\u0005[\u0014\t\u000f1\u0001\u0002Z\u0005qrN\u001a4tKR<\u0016\u000e\u001e5D_6l\u0017\u000e\u001e*fG>\u0014H-T3uC\u0012\fG/\u0019\u0005\b\u0005c\fD\u0011\u0001Bz\u0003Y1\u0017-\u001b7QK:$\u0017N\\4PM\u001a\u001cX\r^,sSR,G#\u00020\u0003v\n]\b\u0002\u0003Bu\u0005_\u0004\r!a\u0011\t\u0011\te(q\u001ea\u0001\u0003W\naa\u001c4gg\u0016$\bb\u0002B\u007fc\u0011\u0005!q`\u0001\u0014aJ,\u0007/\u0019:f\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u000b\u0004=\u000e\u0005\u0001\u0002CA\u001f\u0005w\u0004\raa\u0001\u0011\rm\u0011\u00131IA6\u0011\u001d\u00199!\rC\u0001\u0007\u0013\ta\u0003\u001d:fa\u0006\u0014X\r\u0016=o\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u000b\u0006=\u000e-1q\u0002\u0005\t\u0007\u001b\u0019)\u00011\u0001\u0002\u0002\u0006Q\u0001O]8ek\u000e,'/\u00133\t\u0011\u0005u2Q\u0001a\u0001\u0007\u0007Aqaa\u00052\t\u0003\t\u0019*\u0001\u0012iCN\u0014VmY3jm\u0016$7i\u001c8tSN$XM\u001c;PM\u001a\u001cX\r^\"p[6LGo\u001d\u0005\b\u0007/\tD\u0011AB\r\u0003i1\u0017-\u001b7QK:$\u0017N\\4Uq:|eMZ:fi\u000e{W.\\5u)\u0015q61DB\u000f\u0011!\u0019ia!\u0006A\u0002\u0005\u0005\u0005\u0002\u0003Bu\u0007+\u0001\r!a\u0011\t\u000f\r\u0005\u0012\u0007\"\u0001\u0004$\u00059rN\u001c+y]>3gm]3u\u0007>lW.\u001b;BaB,g\u000e\u001a\u000b\b=\u000e\u00152qEB\u0015\u0011!\u0019iaa\bA\u0002\u0005\u0005\u0005\u0002\u0003Bu\u0007?\u0001\r!a\u0011\t\u0011\r-2q\u0004a\u0001\u00033\nQdY8n[&$(+Z2pe\u0012lU\r^1eCR\f\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\b\u0007_\tD\u0011AB\u0019\u0003y\u0019w.\u001c9mKR,\u0007+\u001a8eS:<G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fF\u0003_\u0007g\u0019)\u0004\u0003\u0005\u0004\u000e\r5\u0002\u0019AAA\u0011!\u00199d!\fA\u0002\u0005U\u0015\u0001C5t\u0007>lW.\u001b;\t\u000f\rm\u0012\u0007\"\u0001\u0004>\u0005y\u0011m\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148/\u0006\u0002\u0004@A1!Q\u000bB,\u0003\u0003Cqaa\u00112\t\u0003\u0019)%A\u0012iCN\u0004VM\u001c3j]\u001e|eMZ:fi\u000e{W.\\5ug\u001a\u0013x.\u001c)s_\u0012,8-\u001a:\u0015\t\u0005U5q\t\u0005\t\u0007\u001b\u0019\t\u00051\u0001\u0002\u0002\"911J\u0019\u0005\u0002\r5\u0013!\u0004:f[>4Xm\u00144gg\u0016$8\u000f\u0006\u0003\u0004P\rM\u0003\u0003\u0003BE\u0007#\n\u0019%a\u001b\n\u0007\r\u0012Y\t\u0003\u0005\u0004V\r%\u0003\u0019AB,\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B+\u00073\n\u0019%\u0003\u0003\u0004\\\u0005%\"aA*fc\"91qL\u0019\u0005\u0002\r\u0005\u0014\u0001\u0006:f[>4X-\u0012=qSJ,Gm\u00144gg\u0016$8\u000f\u0006\u0003\u0004\u0004\r\r\u0004\u0002CB3\u0007;\u0002\r!!!\u0002\u000fM$\u0018M\u001d;Ng\"91\u0011N\u0019\u0005\u0002\r-\u0014AC1mY>3gm]3ugV\u00111q\n\u0005\b\u0005s\fD\u0011AB8)\u0011\u0019\tha\u001d\u0011\t=I\u00171\u000e\u0005\t\u0005S\u001ci\u00071\u0001\u0002D!A1qO\u0019\u0005\u0002\t\u0019I(\u0001\rpM\u001a\u001cX\r^,ji\"\u0014VmY8sI6+G/\u00193bi\u0006$Baa\u001f\u0004~A!q\"[A-\u0011!\u0011Io!\u001eA\u0002\u0005\r\u0003BBBAc\u0011\u00051/\u0001\u0006ok6|eMZ:fiNDqa!\"2\t\u0003\t\u0019*\u0001\u0006iCN|eMZ:fiNDqa!#2\t\u0013\u0019Y)A\u000bbgN,'\u000f\u001e,bY&$GK]1og&$\u0018n\u001c8\u0015\u0007y\u001bi\tC\u0004\u0004\u0010\u000e\u001d\u0005\u0019A\u0013\u0002\u0017Q\f'oZ3u'R\fG/\u001a\u0005\b\u0007'\u000bD\u0011IBK\u0003!!xn\u0015;sS:<G#\u0001\u001f)\u0007E\u001aI\nE\u00025\u00077K1a!(6\u00055qwN\u001c;ie\u0016\fGm]1gK\")!(\fa\u0001y!)!)\fa\u0001K!)!/\fa\u0001i\")a-\fa\u0001y!1\u0011QB\u0017A\u0002qBQA`\u0017A\u0002qBq!!\b.\u0001\u0004\u0019i\u000b\u0005\u0004\u00040\u000eU\u0016\u0011\u0007\b\u0005\u0007c\u0013\u0019ED\u0002\u001e\u0007gK\u0011!E\u0005\u0005\u0007o\u0013YE\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0001")
public class GroupMetadata
implements Logging {
    private final String groupId;
    private final ReentrantLock lock;
    private GroupState state;
    private Option<String> protocolType;
    private int generationId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId;
    private Option<String> kafka$coordinator$group$GroupMetadata$$protocol;
    private final HashMap<String, MemberMetadata> members;
    private final HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets;
    private final HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits;
    private final HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits;
    private boolean receivedTransactionalOffsetCommits;
    private boolean receivedConsumerOffsetCommits;
    private boolean newMemberAdded;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static GroupMetadata loadGroup(String string, GroupState groupState, int n, String string2, String string3, String string4, Iterable<MemberMetadata> iterable) {
        return GroupMetadata$.MODULE$.loadGroup(string, groupState, n, string2, string3, string4, iterable);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        GroupMetadata groupMetadata = this;
        synchronized (groupMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String groupId() {
        return this.groupId;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    private GroupState state() {
        return this.state;
    }

    private void state_$eq(GroupState x$1) {
        this.state = x$1;
    }

    public Option<String> protocolType() {
        return this.protocolType;
    }

    public void protocolType_$eq(Option<String> x$1) {
        this.protocolType = x$1;
    }

    public int generationId() {
        return this.generationId;
    }

    public void generationId_$eq(int x$1) {
        this.generationId = x$1;
    }

    private Option<String> kafka$coordinator$group$GroupMetadata$$leaderId() {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId;
    }

    public void kafka$coordinator$group$GroupMetadata$$leaderId_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$leaderId = x$1;
    }

    private Option<String> kafka$coordinator$group$GroupMetadata$$protocol() {
        return this.kafka$coordinator$group$GroupMetadata$$protocol;
    }

    public void kafka$coordinator$group$GroupMetadata$$protocol_$eq(Option<String> x$1) {
        this.kafka$coordinator$group$GroupMetadata$$protocol = x$1;
    }

    private HashMap<String, MemberMetadata> members() {
        return this.members;
    }

    private HashMap<TopicPartition, CommitRecordMetadataAndOffset> offsets() {
        return this.offsets;
    }

    private HashMap<TopicPartition, OffsetAndMetadata> pendingOffsetCommits() {
        return this.pendingOffsetCommits;
    }

    private HashMap<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTransactionalOffsetCommits() {
        return this.pendingTransactionalOffsetCommits;
    }

    private boolean receivedTransactionalOffsetCommits() {
        return this.receivedTransactionalOffsetCommits;
    }

    private void receivedTransactionalOffsetCommits_$eq(boolean x$1) {
        this.receivedTransactionalOffsetCommits = x$1;
    }

    private boolean receivedConsumerOffsetCommits() {
        return this.receivedConsumerOffsetCommits;
    }

    private void receivedConsumerOffsetCommits_$eq(boolean x$1) {
        this.receivedConsumerOffsetCommits = x$1;
    }

    public boolean newMemberAdded() {
        return this.newMemberAdded;
    }

    public void newMemberAdded_$eq(boolean x$1) {
        this.newMemberAdded = x$1;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public boolean is(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return !(groupState2 != null ? !groupState2.equals(groupState3) : groupState3 != null);
    }

    public boolean not(GroupState groupState) {
        GroupState groupState2 = this.state();
        GroupState groupState3 = groupState;
        return groupState2 == null ? groupState3 != null : !groupState2.equals(groupState3);
    }

    public boolean has(String memberId) {
        return this.members().contains(memberId);
    }

    public MemberMetadata get(String memberId) {
        return this.members().apply(memberId);
    }

    public boolean isLeader(String memberId) {
        return this.kafka$coordinator$group$GroupMetadata$$leaderId().contains(memberId);
    }

    public String leaderOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$leaderId().orNull(Predef$.MODULE$.$conforms());
    }

    public String protocolOrNull() {
        return (String)this.kafka$coordinator$group$GroupMetadata$$protocol().orNull(Predef$.MODULE$.$conforms());
    }

    public void add(MemberMetadata member) {
        if (this.members().isEmpty()) {
            this.protocolType_$eq(new Some<String>(member.protocolType()));
        }
        String string = this.groupId();
        String string2 = member.groupId();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Object a = this.protocolType().orNull(Predef$.MODULE$.$conforms());
        String string3 = member.protocolType();
        Predef$.MODULE$.assert(!(a != null ? !a.equals(string3) : string3 != null));
        Predef$.MODULE$.assert(this.supportsProtocols(member.protocols()));
        if (this.kafka$coordinator$group$GroupMetadata$$leaderId().isEmpty()) {
            this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq(new Some<String>(member.memberId()));
        }
        this.members().put(member.memberId(), member);
    }

    public void remove(String memberId) {
        block0: {
            this.members().remove(memberId);
            if (!this.isLeader(memberId)) break block0;
            this.kafka$coordinator$group$GroupMetadata$$leaderId_$eq(this.members().isEmpty() ? None$.MODULE$ : new Some(this.members().keys().head()));
        }
    }

    public GroupState currentState() {
        return this.state();
    }

    public List<MemberMetadata> notYetRejoinedMembers() {
        return ((TraversableOnce)this.members().values().filter((Function1<MemberMetadata, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(GroupMetadata.$anonfun$notYetRejoinedMembers$1(x$1)))).toList();
    }

    public Set<String> allMembers() {
        return this.members().keySet();
    }

    public List<MemberMetadata> allMemberMetadata() {
        return this.members().values().toList();
    }

    public int rebalanceTimeoutMs() {
        return BoxesRunTime.unboxToInt(this.members().values().foldLeft(BoxesRunTime.boxToInteger(0), (Function2<Object, MemberMetadata, Object> & Serializable & scala.Serializable)(timeout, member) -> BoxesRunTime.boxToInteger(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(timeout)), member.rebalanceTimeoutMs()))));
    }

    public String generateMemberIdSuffix() {
        return UUID.randomUUID().toString();
    }

    public boolean canRebalance() {
        return ((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(PreparingRebalance$.MODULE$)).contains(this.state());
    }

    public void transitionTo(GroupState groupState) {
        this.assertValidTransition(groupState);
        this.state_$eq(groupState);
    }

    public String selectProtocol() {
        if (this.members().isEmpty()) {
            throw new IllegalStateException("Cannot select protocol for empty group");
        }
        scala.collection.immutable.Set<String> candidates = this.candidateProtocols();
        List votes = ((TraversableLike)this.allMemberMetadata().map((Function1<MemberMetadata, String> & Serializable & scala.Serializable)x$2 -> x$2.vote(candidates), List$.MODULE$.canBuildFrom())).groupBy((Function1<String, String> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x)).mapValues((Function1<List, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger(x$3.size())).toList();
        return (String)((Tuple2)votes.maxBy((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger(x$4._2$mcI$sp()), Ordering$Int$.MODULE$))._1();
    }

    private scala.collection.immutable.Set<String> candidateProtocols() {
        return (scala.collection.immutable.Set)((LinearSeqOptimized)this.allMemberMetadata().map((Function1<MemberMetadata, scala.collection.immutable.Set> & Serializable & scala.Serializable)x$5 -> x$5.protocols(), List$.MODULE$.canBuildFrom())).reduceLeft((Function2<scala.collection.immutable.Set, scala.collection.immutable.Set, scala.collection.immutable.Set> & Serializable & scala.Serializable)(commonProtocols, protocols) -> (scala.collection.immutable.Set)commonProtocols.$amp(protocols));
    }

    public boolean supportsProtocols(scala.collection.immutable.Set<String> memberProtocols) {
        return this.members().isEmpty() || ((TraversableOnce)memberProtocols.$amp(this.candidateProtocols())).nonEmpty();
    }

    public void initNextGeneration() {
        List<MemberMetadata> list = this.notYetRejoinedMembers();
        GenTraversable genTraversable = List$.MODULE$.empty();
        Predef$.MODULE$.assert(!(list != null ? !((Object)list).equals(genTraversable) : genTraversable != null));
        if (this.members().nonEmpty()) {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq(new Some<String>(this.selectProtocol()));
            this.transitionTo(CompletingRebalance$.MODULE$);
        } else {
            this.generationId_$eq(this.generationId() + 1);
            this.kafka$coordinator$group$GroupMetadata$$protocol_$eq(None$.MODULE$);
            this.transitionTo(Empty$.MODULE$);
        }
        this.receivedConsumerOffsetCommits_$eq(false);
        this.receivedTransactionalOffsetCommits_$eq(false);
    }

    public scala.collection.immutable.Map<String, byte[]> currentMemberMetadata() {
        if (this.is(Dead$.MODULE$) || this.is(PreparingRebalance$.MODULE$)) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Cannot obtain member metadata for group in state %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.state()})));
        }
        return ((TraversableOnce)this.members().map((Function1<String, MemberMetadata>)(Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String memberId = (String)tuple2._1();
            MemberMetadata memberMetadata = (MemberMetadata)tuple2._2();
            Tuple2<String, byte[]> tuple22 = new Tuple2<String, byte[]>(memberId, memberMetadata.metadata(this.kafka$coordinator$group$GroupMetadata$$protocol().get()));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public GroupSummary summary() {
        GroupSummary groupSummary;
        if (this.is(Stable$.MODULE$)) {
            String protocol = this.protocolOrNull();
            if (protocol == null) {
                throw new IllegalStateException("Invalid null group protocol for stable group");
            }
            Iterable members = this.members().values().map((Function1<MemberMetadata, MemberSummary> & Serializable & scala.Serializable)member -> member.summary(protocol), Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), protocol, members.toList());
        } else {
            Iterable members = this.members().values().map((Function1<MemberMetadata, MemberSummary> & Serializable & scala.Serializable)member -> member.summaryNoMetadata(), Iterable$.MODULE$.canBuildFrom());
            groupSummary = new GroupSummary(this.state().toString(), (String)this.protocolType().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), GroupCoordinator$.MODULE$.NoProtocol(), members.toList());
        }
        return groupSummary;
    }

    public GroupOverview overview() {
        return new GroupOverview(this.groupId(), (String)this.protocolType().getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""));
    }

    public void initializeOffsets(Map<TopicPartition, CommitRecordMetadataAndOffset> offsets, scala.collection.immutable.Map<Object, scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingTxnOffsets) {
        this.offsets().$plus$plus$eq(offsets);
        this.pendingTransactionalOffsetCommits().$plus$plus$eq(pendingTxnOffsets);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onOffsetCommitAppend(TopicPartition topicPartition, CommitRecordMetadataAndOffset offsetWithCommitRecordMetadata) {
        Serializable serializable;
        if (this.pendingOffsetCommits().contains(topicPartition)) {
            if (offsetWithCommitRecordMetadata.appendedBatchOffset().isEmpty()) {
                throw new IllegalStateException("Cannot complete offset commit write without providing the metadata of the record in the log.");
            }
            serializable = !this.offsets().contains(topicPartition) || this.offsets().apply(topicPartition).olderThan(offsetWithCommitRecordMetadata) ? this.offsets().put(topicPartition, offsetWithCommitRecordMetadata) : BoxedUnit.UNIT;
        } else {
            serializable = BoxedUnit.UNIT;
        }
        Option<OffsetAndMetadata> option = this.pendingOffsetCommits().get(topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata stagedOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offsetWithCommitRecordMetadata.offsetAndMetadata();
            OffsetAndMetadata offsetAndMetadata2 = stagedOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove(topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void failPendingOffsetWrite(TopicPartition topicPartition, OffsetAndMetadata offset) {
        Option<OffsetAndMetadata> option = this.pendingOffsetCommits().get(topicPartition);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetAndMetadata pendingOffset = (OffsetAndMetadata)some.value();
            OffsetAndMetadata offsetAndMetadata = offset;
            OffsetAndMetadata offsetAndMetadata2 = pendingOffset;
            if (!(offsetAndMetadata != null ? !((Object)offsetAndMetadata).equals(offsetAndMetadata2) : offsetAndMetadata2 != null)) {
                this.pendingOffsetCommits().remove(topicPartition);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void prepareOffsetCommit(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.receivedConsumerOffsetCommits_$eq(true);
        this.pendingOffsetCommits().$plus$plus$eq(offsets);
    }

    public void prepareTxnOffsetCommit(long producerId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " is pending"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId), this.groupId(), offsets})));
        this.receivedTransactionalOffsetCommits_$eq(true);
        scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset> producerOffsets = this.pendingTransactionalOffsetCommits().getOrElseUpdate(BoxesRunTime.boxToLong(producerId), (Function0<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>>)(Function0<scala.collection.mutable.Map> & Serializable & scala.Serializable)() -> Map$.MODULE$.empty());
        offsets.foreach((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
            Option<CommitRecordMetadataAndOffset> option = producerOffsets.put(topicPartition, new CommitRecordMetadataAndOffset(None$.MODULE$, offsetAndMetadata));
            return option;
        });
    }

    public boolean hasReceivedConsistentOffsetCommits() {
        return !this.receivedConsumerOffsetCommits() || !this.receivedTransactionalOffsetCommits();
    }

    public void failPendingTxnOffsetCommit(long producerId, TopicPartition topicPartition) {
        Option<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> option = this.pendingTransactionalOffsetCommits().get(BoxesRunTime.boxToLong(producerId));
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)some.value();
            Option pendingOffsetCommit = pendingOffsets.remove(topicPartition);
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " failed "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId), this.groupId(), pendingOffsetCommit})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to be appended to the log"})).s(Nil$.MODULE$));
            if (pendingOffsets.isEmpty()) {
                this.pendingTransactionalOffsetCommits().remove(BoxesRunTime.boxToLong(producerId));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onTxnOffsetCommitAppend(long producerId, TopicPartition topicPartition, CommitRecordMetadataAndOffset commitRecordMetadataAndOffset) {
        block3: {
            block2: {
                var6_4 = this.pendingTransactionalOffsetCommits().get(BoxesRunTime.boxToLong(producerId));
                if (!(var6_4 instanceof Some)) break block2;
                var7_5 = (Some)var6_4;
                pendingOffset = (scala.collection.mutable.Map)var7_5.value();
                if (!pendingOffset.contains(topicPartition)) ** GOTO lbl-1000
                v0 = ((CommitRecordMetadataAndOffset)pendingOffset.apply(topicPartition)).offsetAndMetadata();
                var9_7 = commitRecordMetadataAndOffset.offsetAndMetadata();
                if (!(v0 != null ? v0.equals(var9_7) == false : var9_7 != null)) {
                    pendingOffset.update(topicPartition, commitRecordMetadataAndOffset);
                    v1 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = BoxedUnit.UNIT;
                }
                var5_8 = v1;
                break block3;
            }
            var5_9 = BoxedUnit.UNIT;
        }
    }

    public void completePendingTxnOffsetCommit(long producerId, boolean isCommit) {
        Option<scala.collection.mutable.Map<TopicPartition, CommitRecordMetadataAndOffset>> pendingOffsetsOpt = this.pendingTransactionalOffsetCommits().remove(BoxesRunTime.boxToLong(producerId));
        if (isCommit) {
            pendingOffsetsOpt.foreach((Function1<scala.collection.mutable.Map, Object> & Serializable & scala.Serializable)pendingOffsets -> {
                pendingOffsets.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> {
                    Serializable serializable;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
                        if (commitRecordMetadataAndOffset.appendedBatchOffset().isEmpty()) {
                            throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete a transactional offset commit for producerId ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId$3)})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and groupId ", " even though the offset commit record itself hasn't been appended to the log."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{$this.groupId()})));
                        }
                        Option<CommitRecordMetadataAndOffset> currentOffsetOpt = $this.offsets().get(topicPartition);
                        if (currentOffsetOpt.forall((Function1<CommitRecordMetadataAndOffset, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(x$6.olderThan(commitRecordMetadataAndOffset)))) {
                            $this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + "committed and loaded into the cache.");
                            serializable = $this.offsets().put(topicPartition, commitRecordMetadataAndOffset);
                        } else {
                            $this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offset ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId$3), $this.groupId(), commitRecordMetadataAndOffset})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"committed, but not loaded since its offset is older than current offset ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{currentOffsetOpt})));
                            serializable = BoxedUnit.UNIT;
                        }
                    } else {
                        throw new MatchError(tuple2);
                    }
                    BoxedUnit boxedUnit = serializable;
                    return boxedUnit;
                });
                return BoxedUnit.UNIT;
            });
        } else {
            this.trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TxnOffsetCommit for producer ", " and group ", " with offsets ", " aborted"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(producerId), this.groupId(), pendingOffsetsOpt})));
        }
    }

    public Set<Object> activeProducers() {
        return this.pendingTransactionalOffsetCommits().keySet();
    }

    public boolean hasPendingOffsetCommitsFromProducer(long producerId) {
        return this.pendingTransactionalOffsetCommits().contains(BoxesRunTime.boxToLong(producerId));
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeOffsets(Seq<TopicPartition> topicPartitions) {
        return ((TraversableOnce)topicPartitions.flatMap((Function1<TopicPartition, Iterable> & Serializable & scala.Serializable)topicPartition -> {
            this.pendingOffsetCommits().remove((TopicPartition)topicPartition);
            this.pendingTransactionalOffsetCommits().foreach((Function1<Tuple2, Option> & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                scala.collection.mutable.Map pendingOffsets = (scala.collection.mutable.Map)tuple2._2();
                Option option = pendingOffsets.remove(topicPartition);
                return option;
            });
            Option<CommitRecordMetadataAndOffset> removedOffset = this.offsets().remove((TopicPartition)topicPartition);
            return Option$.MODULE$.option2Iterable(removedOffset.map((Function1<CommitRecordMetadataAndOffset, Tuple2> & Serializable & scala.Serializable)x$7 -> Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), x$7.offsetAndMetadata())));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> removeExpiredOffsets(long startMs) {
        HashMap expiredOffsets = ((TraversableLike)this.offsets().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean(GroupMetadata.$anonfun$removeExpiredOffsets$1(this, startMs, x0$5)))).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordOffsetAndMetadata = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2<TopicPartition, OffsetAndMetadata> tuple22 = new Tuple2<TopicPartition, OffsetAndMetadata>(topicPartition, commitRecordOffsetAndMetadata.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        this.offsets().$minus$minus$eq(expiredOffsets.keySet());
        return expiredOffsets.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> allOffsets() {
        return ((TraversableOnce)this.offsets().map((Function1<TopicPartition, CommitRecordMetadataAndOffset>)(Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
            Tuple2<TopicPartition, OffsetAndMetadata> tuple22 = new Tuple2<TopicPartition, OffsetAndMetadata>(topicPartition, commitRecordMetadataAndOffset.offsetAndMetadata());
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<OffsetAndMetadata> offset(TopicPartition topicPartition) {
        return this.offsets().get(topicPartition).map((Function1<CommitRecordMetadataAndOffset, OffsetAndMetadata> & Serializable & scala.Serializable)x$8 -> x$8.offsetAndMetadata());
    }

    public Option<CommitRecordMetadataAndOffset> offsetWithRecordMetadata(TopicPartition topicPartition) {
        return this.offsets().get(topicPartition);
    }

    public int numOffsets() {
        return this.offsets().size();
    }

    public boolean hasOffsets() {
        return this.offsets().nonEmpty() || this.pendingOffsetCommits().nonEmpty() || this.pendingTransactionalOffsetCommits().nonEmpty();
    }

    private void assertValidTransition(GroupState targetState) {
        if (!((SetLike)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(targetState)).contains(this.state())) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Group %s should be in the %s states before moving to %s state. Instead it is in %s state")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId(), ((TraversableOnce)GroupMetadata$.MODULE$.kafka$coordinator$group$GroupMetadata$$validPreviousStates().apply(targetState)).mkString(","), targetState, this.state()})));
        }
    }

    public String toString() {
        return "GroupMetadata(" + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"groupId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.groupId()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"generation=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.generationId())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"protocolType=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.protocolType()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentState=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.currentState()})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"members=", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.members()}));
    }

    public static final /* synthetic */ boolean $anonfun$notYetRejoinedMembers$1(MemberMetadata x$1) {
        return x$1.awaitingJoinCallback() == null;
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredOffsets$1(GroupMetadata $this, long startMs$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        CommitRecordMetadataAndOffset commitRecordMetadataAndOffset = (CommitRecordMetadataAndOffset)tuple2._2();
        boolean bl = commitRecordMetadataAndOffset.offsetAndMetadata().expireTimestamp() < startMs$1 && !$this.pendingOffsetCommits().contains(topicPartition);
        return bl;
    }

    public GroupMetadata(String groupId, GroupState initialState) {
        this.groupId = groupId;
        Logging.$init$(this);
        this.lock = new ReentrantLock();
        this.state = initialState;
        this.protocolType = None$.MODULE$;
        this.generationId = 0;
        this.kafka$coordinator$group$GroupMetadata$$leaderId = None$.MODULE$;
        this.kafka$coordinator$group$GroupMetadata$$protocol = None$.MODULE$;
        this.members = new HashMap();
        this.offsets = new HashMap();
        this.pendingOffsetCommits = new HashMap();
        this.pendingTransactionalOffsetCommits = new HashMap();
        this.receivedTransactionalOffsetCommits = false;
        this.receivedConsumerOffsetCommits = false;
        this.newMemberAdded = false;
    }
}

