/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.OffsetRequest$;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.NewShinyConsumer$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CT3x'\"Lg._\"p]N,X.\u001a:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00051\u0011\u0015m]3D_:\u001cX/\\3s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012!\u0002;pa&\u001c\u0007cA\u0005\u0016/%\u0011aC\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005aybBA\r\u001e!\tQ\"\"D\u0001\u001c\u0015\tab!\u0001\u0004=e>|GOP\u0005\u0003=)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0011\"\u0005\u0019\u0019FO]5oO*\u0011aD\u0003\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005Y\u0001/\u0019:uSRLwN\\%e!\rIQ#\n\t\u0003\u0013\u0019J!a\n\u0006\u0003\u0007%sG\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u0019ygMZ:fiB\u0019\u0011\"F\u0016\u0011\u0005%a\u0013BA\u0017\u000b\u0005\u0011auN\\4\t\u0011=\u0002!\u0011!Q\u0001\nQ\t\u0011b\u001e5ji\u0016d\u0017n\u001d;\t\u0011E\u0002!\u0011!Q\u0001\nI\nQbY8ogVlWM\u001d)s_B\u001c\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\u0002\u0013QLW.Z8vi6\u001bX#A\u0016\t\u0011y\u0002!\u0011!Q\u0001\n-\n!\u0002^5nK>,H/T:!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q9!i\u0011#F\r\u001eC\u0005CA\b\u0001\u0011\u0015\u0019r\b1\u0001\u0015\u0011\u0015\u0019s\b1\u0001%\u0011\u0015Is\b1\u0001+\u0011\u0015ys\b1\u0001\u0015\u0011\u0015\tt\b1\u00013\u0011\u001dYt\b%AA\u0002-Bqa\u0001\u0001C\u0002\u0013\u0005!*F\u0001L!\u0011aUkV,\u000e\u00035S!a\u0001(\u000b\u0005=\u0003\u0016aB2mS\u0016tGo\u001d\u0006\u0003\u000bES!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO&\u0011a+\u0014\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u0007%A&,\u0003\u0002Z\u0015\t)\u0011I\u001d:bsB\u0011\u0011bW\u0005\u00039*\u0011AAQ=uK\"1a\f\u0001Q\u0001\n-\u000b\u0011bY8ogVlWM\u001d\u0011\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\u0006Q!/Z2pe\u0012LE/\u001a:\u0016\u0003\t\u00042aM2f\u0013\t!GG\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011aemV,\n\u0005\u001dl%AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u00039\u0011XmY8sI&#XM]0%KF$\"a\u001b8\u0011\u0005%a\u0017BA7\u000b\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003c\u0003-\u0011XmY8sI&#XM\u001d\u0011\t\u000bM\u0004A\u0011\u0001;\u0002\u0019\r|gn];nKJLe.\u001b;\u0015\u0003-DQA\u001e\u0001\u0005\u0002]\fAa]3fWR!1\u000e_={\u0011\u0015\u0019R\u000f1\u0001\u0018\u0011\u0015\u0019S\u000f1\u0001&\u0011\u0015IS\u000f1\u0001,\u0011\u0015a\b\u0001\"\u0011~\u0003\u001d\u0011XmY3jm\u0016$\u0012A \t\u0003\u001f}L1!!\u0001\u0003\u0005I\u0011\u0015m]3D_:\u001cX/\\3s%\u0016\u001cwN\u001d3\t\r\u0005\u0015\u0001\u0001\"\u0011u\u0003\u0011\u0019Ho\u001c9\t\r\u0005%\u0001\u0001\"\u0011u\u0003\u001d\u0019G.Z1okBDa!!\u0004\u0001\t\u0003\"\u0018AB2p[6LG\u000fK\u0004\u0001\u0003#\t9\"a\u0007\u0011\u0007%\t\u0019\"C\u0002\u0002\u0016)\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\tI\"AA\f)\"L7\u000fI2mCN\u001c\b\u0005[1tA\t,WM\u001c\u0011eKB\u0014XmY1uK\u0012\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0001\u0002F.Z1tK\u0002*8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3.\u00194lC:\u001aG.[3oiNt3m\u001c8tk6,'OL&bM.\f7i\u001c8tk6,'\u000fI5ogR,\u0017\r\u001a\u0018\"\u0005\u0005u\u0011\u0001\u0003\u0019/cEr\u0003G\f\u0019\b\u0013\u0005\u0005\"!!A\t\u0002\u0005\r\u0012\u0001\u0005(foNC\u0017N\\=D_:\u001cX/\\3s!\ry\u0011Q\u0005\u0004\t\u0003\t\t\t\u0011#\u0001\u0002(M\u0019\u0011Q\u0005\u0005\t\u000f\u0001\u000b)\u0003\"\u0001\u0002,Q\u0011\u00111\u0005\u0005\u000b\u0003_\t)#%A\u0005\u0002\u0005E\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u00024)\u001a1&!\u000e,\u0005\u0005]\u0002\u0003BA\u001d\u0003\u0007j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0011\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\nYDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0003\"!\n\u0002\u0012\u0005]\u00111\u0004")
public class NewShinyConsumer
implements BaseConsumer {
    private final Option<String> topic;
    private final Option<Object> partitionId;
    private final Option<Object> offset;
    private final Option<String> whitelist;
    private final long timeoutMs;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIter;

    public static long $lessinit$greater$default$6() {
        return NewShinyConsumer$.MODULE$.$lessinit$greater$default$6();
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> recordIter() {
        return this.recordIter;
    }

    public void recordIter_$eq(Iterator<ConsumerRecord<byte[], byte[]>> x$1) {
        this.recordIter = x$1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void consumerInit() {
        Tuple4<Option<String>, Option<Object>, Option<Object>, Option<String>> tuple4 = new Tuple4<Option<String>, Option<Object>, Option<Object>, Option<String>>(this.topic, this.partitionId, this.offset, this.whitelist);
        if (tuple4 != null) {
            Option<String> option = tuple4._1();
            Option<Object> option2 = tuple4._2();
            Option<Object> option3 = tuple4._3();
            Option<String> option4 = tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int partitionId = BoxesRunTime.unboxToInt(some2.value());
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        long offset = BoxesRunTime.unboxToLong(some3.value());
                        if (None$.MODULE$.equals(option4)) {
                            this.seek(topic, partitionId, offset);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
            }
        }
        if (tuple4 != null) {
            Option<String> option = tuple4._1();
            Option<Object> option5 = tuple4._2();
            Option<Object> option6 = tuple4._3();
            Option<String> option7 = tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (option5 instanceof Some) {
                    Some some4 = (Some)option5;
                    int partitionId = BoxesRunTime.unboxToInt(some4.value());
                    if (None$.MODULE$.equals(option6) && None$.MODULE$.equals(option7)) {
                        this.seek(topic, partitionId, OffsetRequest$.MODULE$.LatestTime());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (tuple4 != null) {
            Option<String> option = tuple4._1();
            Option<Object> option8 = tuple4._2();
            Option<Object> option9 = tuple4._3();
            Option<String> option10 = tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9) && None$.MODULE$.equals(option10)) {
                    this.consumer().subscribe(Collections.singletonList(topic));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple4 == null) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        Option<String> option = tuple4._1();
        Option<Object> option11 = tuple4._2();
        Option<Object> option12 = tuple4._3();
        Option<String> option13 = tuple4._4();
        if (!None$.MODULE$.equals(option)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!None$.MODULE$.equals(option11)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!None$.MODULE$.equals(option12)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!(option13 instanceof Some)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        Some some = (Some)option13;
        String whitelist = (String)some.value();
        this.consumer().subscribe(Pattern.compile(whitelist));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void seek(String topic, int partitionId, long offset) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        this.consumer().assign(Collections.singletonList(topicPartition));
        long l = offset;
        if (OffsetRequest$.MODULE$.EarliestTime() == l) {
            this.consumer().seekToBeginning(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OffsetRequest$.MODULE$.LatestTime() == l) {
            this.consumer().seekToEnd(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.consumer().seek(topicPartition, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public BaseConsumerRecord receive() {
        if (!this.recordIter().hasNext()) {
            this.recordIter_$eq(this.consumer().poll(this.timeoutMs()).iterator());
            if (!this.recordIter().hasNext()) {
                throw new ConsumerTimeoutException();
            }
        }
        ConsumerRecord<byte[], byte[]> record = this.recordIter().next();
        return new BaseConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), record.key(), record.value(), record.headers());
    }

    @Override
    public void stop() {
        this.consumer().wakeup();
    }

    @Override
    public void cleanup() {
        this.consumer().close();
    }

    @Override
    public void commit() {
        this.consumer().commitSync();
    }

    public NewShinyConsumer(Option<String> topic, Option<Object> partitionId, Option<Object> offset, Option<String> whitelist, Properties consumerProps, long timeoutMs) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.offset = offset;
        this.whitelist = whitelist;
        this.timeoutMs = timeoutMs;
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumerInit();
        this.recordIter = this.consumer().poll(0L).iterator();
    }
}

