/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.PartitionFetchState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001\u001d\u0011QcQ8ogVlWM\u001d$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002!\r|gn];nKJLEm\u0015;sS:<\u0007CA\t\u001b\u001d\t\u0011\u0002\u0004\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u00051AH]8pizR\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\ta\u0001\u0015:fI\u00164\u0017BA\u000e\u001d\u0005\u0019\u0019FO]5oO*\u0011\u0011D\u0006\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005Ia-\u001a;dQ\u0016\u0014\u0018\n\u001a\t\u0003A\u0005j\u0011AF\u0005\u0003EY\u00111!\u00138u\u0011!!\u0003A!b\u0001\n\u0003)\u0013AB2p]\u001aLw-F\u0001'!\t9\u0003&D\u0001\u0003\u0013\tI#A\u0001\bD_:\u001cX/\\3s\u0007>tg-[4\t\u0011-\u0002!\u0011!Q\u0001\n\u0019\nqaY8oM&<\u0007\u0005C\u0005.\u0001\t\u0005\t\u0015!\u0003/i\u0005a1o\\;sG\u0016\u0014%o\\6feB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\bG2,8\u000f^3s\u0013\t\u0019\u0004G\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\n\u00055b\u0001\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\taZT\bS\u0007\u0002s)\u0011!HF\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001f:\u0005\ri\u0015\r\u001d\t\u0003}\u0019k\u0011a\u0010\u0006\u0003\u0001\u0006\u000baaY8n[>t'BA\u0003C\u0015\t\u0019E)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u000b\u0006\u0019qN]4\n\u0005\u001d{$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003O%K!A\u0013\u0002\u0003%A\u000b'\u000f^5uS>tGk\u001c9jG&sgm\u001c\u0005\t\u0019\u0002\u0011)\u0019!C\u0001\u001b\u000612m\u001c8tk6,'OR3uG\",'/T1oC\u001e,'/F\u0001O!\t9s*\u0003\u0002Q\u0005\t12i\u001c8tk6,'OR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003O\u0003]\u0019wN\\:v[\u0016\u0014h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0003U\u0001\u0011\u0005Q+\u0001\u0004=S:LGO\u0010\u000b\b-^C\u0016LW.]!\t9\u0003\u0001C\u0003\u0010'\u0002\u0007\u0001\u0003C\u0003\u001f'\u0002\u0007q\u0004C\u0003%'\u0002\u0007a\u0005C\u0003.'\u0002\u0007a\u0006C\u00037'\u0002\u0007q\u0007C\u0003M'\u0002\u0007a*\u0002\u0003_\u0001\u0001y&a\u0001*F#B\u0011\u0001m\u001b\b\u0003O\u0005<QA\u0019\u0002\t\u0002\r\fQcQ8ogVlWM\u001d$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002(I\u001a)\u0011A\u0001E\u0001KN\u0011AM\u001a\t\u0003A\u001dL!\u0001\u001b\f\u0003\r\u0005s\u0017PU3g\u0011\u0015!F\r\"\u0001k)\u0005\u0019g\u0001\u00027e\u00015\u0014ABR3uG\"\u0014V-];fgR\u001c2a\u001b4o!\ty'O\u0004\u0002\na&\u0011\u0011OC\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\ta7O\u0003\u0002r\u0015!AQo\u001bBC\u0002\u0013\u0005a/\u0001\u0006v]\u0012,'\u000f\\=j]\u001e,\u0012a\u001e\t\u0003qnl\u0011!\u001f\u0006\u0003u\u0012\t1!\u00199j\u0013\ta\u0017\u0010\u0003\u0005~W\n\u0005\t\u0015!\u0003x\u0003-)h\u000eZ3sYfLgn\u001a\u0011\t\u000bQ[G\u0011A@\u0015\t\u0005\u0005\u0011Q\u0001\t\u0004\u0003\u0007YW\"\u00013\t\u000bUt\b\u0019A<\t\u0015\u0005%1\u000e#b\u0001\n\u0013\tY!\u0001\u0006uaR{wJ\u001a4tKR,\"!!\u0004\u0011\u000baZT(a\u0004\u0011\u0007\u0001\n\t\"C\u0002\u0002\u0014Y\u0011A\u0001T8oO\"9\u0011qC6\u0005\u0002\u0005e\u0011aB5t\u000b6\u0004H/_\u000b\u0003\u00037\u00012\u0001IA\u000f\u0013\r\tyB\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019c\u001bC\u0001\u0003K\taa\u001c4gg\u0016$H\u0003BA\b\u0003OAq!!\u000b\u0002\"\u0001\u0007Q(\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u000552\u000e\"\u0011\u00020\u0005AAo\\*ue&tw\rF\u0001\u0011\r\u0019\t\u0019\u0004\u001a\u0001\u00026\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006\u001cR!!\rg\u0003o\u00012a\\A\u001d\u0013\r\t\u0019d\u001d\u0005\u000bk\u0006E\"Q1A\u0005\u0002\u0005uRCAA !\rA\u0018\u0011I\u0005\u0004\u0003\u0007J(A\u0007$fi\u000eD'+Z:q_:\u001cX\rU1si&$\u0018n\u001c8ECR\f\u0007BC?\u00022\t\u0005\t\u0015!\u0003\u0002@!9A+!\r\u0005\u0002\u0005%C\u0003BA&\u0003\u001b\u0002B!a\u0001\u00022!9Q/a\u0012A\u0002\u0005}\u0002\u0002CA)\u0003c!\t!a\u0015\u0002\u000b\u0015\u0014(o\u001c:\u0016\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005ms(\u0001\u0005qe>$xnY8m\u0013\u0011\ty&!\u0017\u0003\r\u0015\u0013(o\u001c:t\u0011!\t\u0019'!\r\u0005\u0002\u0005\u0015\u0014!\u0003;p%\u0016\u001cwN\u001d3t+\t\t9\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\tigP\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005E\u00141\u000e\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\u0005U\u0014\u0011\u0007C\u0001\u0003o\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\WCAA\b\u0011!\tY(!\r\u0005\u0002\u0005u\u0014!C3yG\u0016\u0004H/[8o+\t\ty\bE\u0003!\u0003\u0003\u000b))C\u0002\u0002\u0004Z\u0011aa\u00149uS>t\u0007\u0003BAD\u0003#sA!!#\u0002\u000e:\u00191#a#\n\u0003]I1!a$\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!a%\u0002\u0016\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u001f3\u0002\u0002CA\u0017\u0003c!\t%!'\u0015\u0005\u0005m\u0005\u0003BAO\u0003Ok!!a(\u000b\t\u0005\u0005\u00161U\u0001\u0005Y\u0006twM\u0003\u0002\u0002&\u0006!!.\u0019<b\u0013\rY\u0012q\u0014\u0015\bI\u0006-\u0016\u0011WA[!\r\u0001\u0013QV\u0005\u0004\u0003_3\"A\u00033faJ,7-\u0019;fI\u0006\u0012\u00111W\u0001\u0002\"QC\u0017n\u001d\u0011pE*,7\r\u001e\u0011iCN\u0004#-Z3oA\u0011,\u0007O]3dCR,G\rI1oI\u0002:\u0018\u000e\u001c7!E\u0016\u0004#/Z7pm\u0016$\u0007%\u001b8!C\u00022W\u000f^;sK\u0002\u0012X\r\\3bg\u0016t\u0003\u0005\u00157fCN,\u0007%^:fA=\u0014xML1qC\u000eDWML6bM.\fgf\u00197jK:$8OL2p]N,X.\u001a:/S:$XM\u001d8bYNtc)\u001a;dQ\u0016\u0014\b%\u001b8ti\u0016\fGML\u0011\u0003\u0003o\u000b\u0001\u0002\r\u00182c9\u0002d\u0006\r\u0015\bI\u0006-\u00161XA[C\t\ti,AA\u0010)\"L7\u000fI2mCN\u001c\b\u0005[1tA\t,WM\u001c\u0011eKB\u0014XmY1uK\u0012\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0001\u0002F.Z1tK\u0002*8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3.\u00194lC:\u001aG.[3oiNt3m\u001c8tk6,'OL5oi\u0016\u0014h.\u00197t]\u0019+Go\u00195fe\u0002Jgn\u001d;fC\u0012t\u0003fB1\u0002,\u0006E\u0016QW\u0003\u0007\u0003\u0007\u0004\u0001!!2\u0003\u0005A#\u0005c\u00011\u00022!I\u0011\u0011\u001a\u0001C\u0002\u0013%\u00111Z\u0001\tG2LWM\u001c;JIV\t\u0001\u0003C\u0004\u0002P\u0002\u0001\u000b\u0011\u0002\t\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0004\u0003\"CAj\u0001\t\u0007I\u0011BAk\u0003%1W\r^2i'&TX-F\u0001 \u0011\u001d\tI\u000e\u0001Q\u0001\n}\t!BZ3uG\"\u001c\u0016N_3!\u0011%\ti\u000e\u0001b\u0001\n\u0013\ty.\u0001\btS6\u0004H.Z\"p]N,X.\u001a:\u0016\u0005\u0005\u0005\bcA\u0014\u0002d&\u0019\u0011Q\u001d\u0002\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"A\u0011\u0011\u001e\u0001!\u0002\u0013\t\t/A\btS6\u0004H.Z\"p]N,X.\u001a:!\u0011%\ti\u000f\u0001b\u0001\n\u0013\ty/A\ngKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'/\u0006\u0002\u0002rB\u0019\u00010a=\n\u0007\u0005U\u0018PA\nGKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\u0003\u0005\u0002z\u0002\u0001\u000b\u0011BAy\u0003Q1W\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3sA!9\u0011Q \u0001\u0005B\u0005}\u0018\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\tY\u0002C\u0004\u0003\u0004\u0001!\tE!\u0002\u0002\u0011MDW\u000f\u001e3po:$\"Aa\u0002\u0011\u0007\u0001\u0012I!C\u0002\u0003\fY\u0011A!\u00168ji\"9!q\u0002\u0001\u0005\u0002\tE\u0011\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0003\b\tM!Q\u0003B\r\u0011\u001d\tIC!\u0004A\u0002uB\u0001Ba\u0006\u0003\u000e\u0001\u0007\u0011qB\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0003\u001c\t5\u0001\u0019AAc\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uC\"9!q\u0004\u0001\u0005\u0002\t\u0005\u0012A\u00065b]\u0012dWm\u00144gg\u0016$x*\u001e;PMJ\u000bgnZ3\u0015\t\u0005=!1\u0005\u0005\b\u0003S\u0011i\u00021\u0001>\u0011\u001d\u00119\u0003\u0001C\u0001\u0005S\t!\u0004[1oI2,\u0007+\u0019:uSRLwN\\:XSRDWI\u001d:peN$BAa\u0002\u0003,!A!Q\u0006B\u0013\u0001\u0004\u0011y#\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!a\"\u00032uJAAa\r\u0002\u0016\nA\u0011\n^3sC\ndW\rC\u0004\u00038\u0001!\tB!\u000f\u0002#\t,\u0018\u000e\u001c3GKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0006\u0003\u0003<\t\u0005\u0003\u0003B8\u0003>}K1Aa\u0010t\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og\"9aG!\u000eA\u0002\t\r\u0003#\u0002\u001d\u0003F\t%\u0013b\u0001B$s\t\u00191+Z9\u0011\r\u0001\u0012Y%\u0010B(\u0013\r\u0011iE\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007%\u0011\t&C\u0002\u0003T)\u00111\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016DqAa\u0016\u0001\t#\u0011I&A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0003\\\t\u0005\u0004CBAD\u0005;\u0012y&\u0003\u0003\u0003H\u0005U\u0005C\u0002\u0011\u0003Lu\n)\rC\u0004\u0003d\tU\u0003\u0019A0\u0002\u0019\u0019,Go\u00195SKF,Xm\u001d;\t\u000f\t\u001d\u0004\u0001\"\u0011\u0003j\u00059\"-^5mI2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e\u000b\u0005\u0005W\u0012y\u0007E\u0003p\u0005{\u0011i\u0007\u0005\u00039wuz\u0002\u0002\u0003B9\u0005K\u0002\rAa\u001d\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t!\u0019\t9I!\u0018\u0003J!9!q\u000f\u0001\u0005B\te\u0014!\u00064fi\u000eDW\t]8dQN4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0005w\u0012I\tE\u00039wu\u0012i\b\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019iP\u0001\te\u0016\fX/Z:ug&!!q\u0011BA\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRD\u0001B!\f\u0003v\u0001\u0007!Q\u000e\u0005\b\u0005\u001b\u0003A\u0011\tBH\u00035i\u0017-\u001f2f)J,hnY1uKR!!\u0011\u0013BJ!\u0015y'QHA\u0007\u0011!\u0011)Ja#A\u0002\tm\u0014!\u00044fi\u000eDW\rZ#q_\u000eD7\u000fK\u0004\u0001\u0003W\u000bY,!.")
public class ConsumerFetcherThread
extends AbstractFetcherThread {
    private final ConsumerConfig config;
    private final Map<TopicPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;
    private final String clientId;
    private final int fetchSize;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder fetchRequestBuilder;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    private String clientId() {
        return this.clientId;
    }

    private int fetchSize() {
        return this.fetchSize;
    }

    private SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block0: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown || !this.isInterruptible()) break block0;
            this.simpleConsumer().disconnectToHandleJavaIOBug();
        }
        return (boolean)var1_1;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger(topicPartition.partition()), BoxesRunTime.boxToLong(pti.getFetchOffset()), BoxesRunTime.boxToLong(fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.underlying().messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        String string = this.config().autoOffsetReset();
        String string2 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string3 = string;
        long l = !(string2 != null ? !string2.equals(string3) : string3 != null) ? OffsetRequest$.MODULE$.EarliestTime() : OffsetRequest$.MODULE$.LatestTime();
        long startTimestamp = l;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        block0: {
            if (!partitions.nonEmpty()) break block0;
            this.removePartitions(partitions.toSet());
            this.consumerFetcherManager().addPartitionsWithError(partitions);
        }
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        partitionMap.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = (TopicPartition)tuple2._1();
            PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
            BoxedUnit boxedUnit = partitionFetchState.isReadyForFetch() ? this.fetchRequestBuilder().addFetch(topicPartition.topic(), topicPartition.partition(), partitionFetchState.fetchOffset(), this.fetchSize()) : BoxedUnit.UNIT;
            return boxedUnit;
        });
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(this.fetchRequestBuilder().build()), (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        return this.simpleConsumer().fetch(fetchRequest.underlying()).data().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            FetchResponsePartitionData value;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    value = (FetchResponsePartitionData)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            String t = topicAndPartition.topic();
            int p = topicAndPartition.partition();
            Tuple2<TopicPartition, PartitionData> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(t, p)), new PartitionData(value));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        return new AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>>((Map<TopicPartition, Object>)Map$.MODULE$.apply(Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        return (Map)Map$.MODULE$.apply(Nil$.MODULE$);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        return new AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>>((Map<TopicPartition, Object>)Map$.MODULE$.apply(Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$));
    }

    public ConsumerFetcherThread(String consumerIdString, int fetcherId, ConsumerConfig config, BrokerEndPoint sourceBroker, Map<TopicPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ConsumerFetcherThread-", "-", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{consumerIdString, BoxesRunTime.boxToInteger(fetcherId), BoxesRunTime.boxToInteger(sourceBroker.id())})), config.clientId(), sourceBroker, config.refreshLeaderBackoffMs(), true, false);
        this.logIdent_$eq(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ConsumerFetcher consumerId=", ", leaderId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{consumerIdString, BoxesRunTime.boxToInteger(super.sourceBroker().id())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(fetcherId)})));
        this.clientId = config.clientId();
        this.fetchSize = config.fetchMessageMaxBytes();
        this.simpleConsumer = new SimpleConsumer(super.sourceBroker().host(), super.sourceBroker().port(), config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.clientId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(this.clientId()).replicaId(Request$.MODULE$.OrdinaryConsumerId()).maxWait(config.fetchWaitMaxMs()).minBytes(config.fetchMinBytes()).requestVersion((short)3);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private Map<TopicPartition, Object> tpToOffset;
        private final kafka.api.FetchRequest underlying;
        private volatile boolean bitmap$0;

        public kafka.api.FetchRequest underlying() {
            return this.underlying;
        }

        private Map<TopicPartition, Object> tpToOffset$lzycompute() {
            FetchRequest fetchRequest = this;
            synchronized (fetchRequest) {
                if (!this.bitmap$0) {
                    this.tpToOffset = ((TraversableOnce)this.underlying().requestInfo().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$3 -> {
                        Tuple2 tuple2 = x0$3;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
                        PartitionFetchInfo fetchInfo = (PartitionFetchInfo)tuple2._2();
                        Tuple2<TopicPartition, Long> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(tp.topic(), tp.partition())), BoxesRunTime.boxToLong(fetchInfo.offset()));
                        return tuple22;
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    this.bitmap$0 = true;
                }
            }
            return this.tpToOffset;
        }

        private Map<TopicPartition, Object> tpToOffset() {
            return !this.bitmap$0 ? this.tpToOffset$lzycompute() : this.tpToOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().requestInfo().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return BoxesRunTime.unboxToLong(this.tpToOffset().apply(topicPartition));
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(kafka.api.FetchRequest underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponsePartitionData underlying;

        public FetchResponsePartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error();
        }

        @Override
        public MemoryRecords toRecords() {
            return ((ByteBufferMessageSet)this.underlying().messages()).asRecords();
        }

        @Override
        public long highWatermark() {
            return this.underlying().hw();
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Errors errors2 = Errors.NONE;
            return !(errors != null ? !((Object)((Object)errors)).equals((Object)errors2) : errors2 != null) ? None$.MODULE$ : new Some<Throwable>(ErrorMapping$.MODULE$.exceptionFor(this.error().code()));
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponsePartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

