/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$Throttle$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentInProgress$;
import kafka.admin.ReassignmentStatus;
import kafka.cluster.Broker;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class ReassignPartitionsCommand$
implements Logging {
    public static ReassignPartitionsCommand$ MODULE$;
    private final ReassignPartitionsCommand.Throttle NoThrottle;
    private final String AnyLogDir;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Map<TopicPartitionReplica, String> $lessinit$greater$default$4() {
        return scala.collection.Map$.MODULE$.empty();
    }

    public ReassignPartitionsCommand.Throttle NoThrottle() {
        return this.NoThrottle;
    }

    public String AnyLogDir() {
        return this.AnyLogDir;
    }

    public void main(String[] args) {
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = this.validateAndParseArgs(args);
        String zkConnect = opts.options().valueOf(opts.zkConnectOpt());
        Time time = Time.SYSTEM;
        Option<AdminClient> adminClientOpt = this.createAdminClient(opts);
        try (KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnect, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());){
            try {
                if (opts.options().has(opts.verifyOpt())) {
                    this.verifyAssignment(zkClient, adminClientOpt, opts);
                } else if (opts.options().has(opts.generateOpt())) {
                    this.generateAssignment(zkClient, opts);
                } else if (opts.options().has(opts.executeOpt())) {
                    this.executeAssignment(zkClient, adminClientOpt, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println("Partitions reassignment failed due to " + e.getMessage());
                Predef$.MODULE$.println(Utils.stackTrace(e));
            }
        }
    }

    private Option<AdminClient> createAdminClient(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        Option option;
        if (opts.options().has(opts.bootstrapServerOpt())) {
            Properties props = new Properties();
            props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
            props.put("client.id", "reassign-partitions-tool");
            option = new Some<AdminClient>(AdminClient.create(props));
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String jsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String jsonString = Utils.readFileAsString(jsonFile);
        this.verifyAssignment(zkClient, adminClientOpt, jsonString);
    }

    public void verifyAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, String jsonString) {
        Predef$.MODULE$.println("Status of partition reassignment: ");
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(jsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned = tuple2._1();
        Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple22 = new Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>>(partitionsToBeReassigned, replicaAssignment);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple23 = tuple22;
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned2 = tuple23._1();
        Map<TopicPartitionReplica, String> replicaAssignment2 = tuple23._2();
        Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfPartitionReassignmentSucceeded(zkClient, partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()));
        Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus = this.checkIfReplicaReassignmentSucceeded(adminClientOpt, replicaAssignment2);
        reassignedPartitionsStatus.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$1 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$1(x0$1);
            return BoxedUnit.UNIT;
        });
        replicasReassignmentStatus.foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$2 -> {
            ReassignPartitionsCommand$.$anonfun$verifyAssignment$2(x0$2);
            return BoxedUnit.UNIT;
        });
        this.removeThrottle(zkClient, reassignedPartitionsStatus, replicasReassignmentStatus, adminZkClient);
    }

    public void removeThrottle(KafkaZkClient zkClient, Map<TopicPartition, ReassignmentStatus> reassignedPartitionsStatus, Map<TopicPartitionReplica, ReassignmentStatus> replicasReassignmentStatus, AdminZkClient adminZkClient) {
        block1: {
            if (!reassignedPartitionsStatus.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$removeThrottle$1(x0$3))) || !replicasReassignmentStatus.forall((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$removeThrottle$2(x0$4)))) break block1;
            BooleanRef changed = BooleanRef.create(false);
            ((IterableLike)zkClient.getAllBrokersInCluster().map((Function1<Broker, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger(x$2.id()), Seq$.MODULE$.canBuildFrom())).foreach((JFunction1$mcVI$sp & scala.Serializable)brokerId -> {
                block0: {
                    Properties configs = adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger(brokerId)).toString());
                    if (!(configs.remove(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp()) != null | configs.remove(DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()) != null)) break block0;
                    adminZkClient.changeBrokerConfig((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), configs);
                    changed$1.elem = true;
                }
            });
            Seq topics = (Seq)((SetLike)reassignedPartitionsStatus.keySet().map((Function1<TopicPartition, String> & Serializable & scala.Serializable)tp -> tp.topic(), Set$.MODULE$.canBuildFrom())).$plus$plus(replicasReassignmentStatus.keySet().map((Function1<TopicPartitionReplica, String> & Serializable & scala.Serializable)replica -> replica.topic(), Set$.MODULE$.canBuildFrom())).toSeq().distinct();
            topics.foreach((Function1<String, Object> & Serializable & scala.Serializable)topic -> {
                ReassignPartitionsCommand$.$anonfun$removeThrottle$7(adminZkClient, changed, topic);
                return BoxedUnit.UNIT;
            });
            if (changed.elem) {
                Predef$.MODULE$.println("Throttle was removed.");
            }
        }
    }

    public void generateAssignment(KafkaZkClient zkClient, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String topicsToMoveJsonFile = opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
        int[] brokerListToReassign = (int[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(opts.options().valueOf(opts.brokerListOpt()))).split(','))).map((Function1<String, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger(ReassignPartitionsCommand$.$anonfun$generateAssignment$1(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable<Object> duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
        if (duplicateReassignments.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignments.mkString(",")})));
        }
        String topicsToMoveJsonString = Utils.readFileAsString(topicsToMoveJsonFile);
        boolean disableRackAware = opts.options().has(opts.disableRackAware());
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkClient, Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map<TopicPartition, Seq<Object>> proposedAssignments = tuple2._1();
        Map<TopicPartition, Seq<Object>> currentAssignments = tuple2._2();
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple22 = new Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>>(proposedAssignments, currentAssignments);
        Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> tuple23 = tuple22;
        Map<TopicPartition, Seq<Object>> proposedAssignments2 = tuple23._1();
        Map<TopicPartition, Seq<Object>> currentAssignments2 = tuple23._2();
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n%s\n")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(currentAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(proposedAssignments2, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>> generateAssignment(KafkaZkClient zkClient, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = ZkUtils$.MODULE$.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> currentAssignment = zkClient.getReplicaAssignmentForTopics(topicsToReassign.toSet());
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            String string = tp.topic();
            return string;
        });
        scala.Serializable rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        Seq<BrokerMetadata> brokerMetadatas = adminZkClient.getBrokerMetadatas((RackAwareMode)((Object)rackAwareMode), (Option<Seq<Object>>)new Some<Seq<Object>>(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        groupedByTopic.foreach((Function1<Tuple2, scala.collection.mutable.Map> & Serializable & scala.Serializable)x0$6 -> {
            Seq seq;
            scala.collection.immutable.Map assignment;
            String topic;
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                Seq replicas;
                topic = (String)tuple2._1();
                assignment = (scala.collection.immutable.Map)tuple2._2();
                Tuple2 tuple22 = (Tuple2)assignment.head();
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                seq = replicas = (Seq)tuple22._2();
            } else {
                throw new MatchError(tuple2);
            }
            Seq replicas = seq;
            Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(brokerMetadatas, assignment.size(), replicas.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionsToBeReassigned.$plus$plus$eq(assignedReplicas.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$7 -> {
                Tuple2 tuple2 = x0$7;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int partition = tuple2._1$mcI$sp();
                Seq replicas = (Seq)tuple2._2();
                Tuple2<TopicPartition, Seq> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(topic, partition)), replicas);
                return tuple22;
            }, scala.collection.Map$.MODULE$.canBuildFrom()));
            return map;
        });
        return new Tuple2<Map<TopicPartition, Seq<Object>>, Map<TopicPartition, Seq<Object>>>(partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        String reassignmentJsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt());
        String reassignmentJsonString = Utils.readFileAsString(reassignmentJsonFile);
        long interBrokerThrottle = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.interBrokerThrottleOpt()));
        long replicaAlterLogDirsThrottle = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.replicaAlterLogDirsThrottleOpt()));
        long timeoutMs = BoxesRunTime.unboxToLong(opts.options().valueOf(opts.timeoutOpt()));
        this.executeAssignment(zkClient, adminClientOpt, reassignmentJsonString, new ReassignPartitionsCommand.Throttle(interBrokerThrottle, replicaAlterLogDirsThrottle, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3()), timeoutMs);
    }

    public void executeAssignment(KafkaZkClient zkClient, Option<AdminClient> adminClientOpt, String reassignmentJsonString, ReassignPartitionsCommand.Throttle throttle, long timeoutMs) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parseAndValidate(zkClient, reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionAssignment = tuple2._1();
        Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple22 = new Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>>(partitionAssignment, replicaAssignment);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple23 = tuple22;
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionAssignment2 = tuple23._1();
        Map<TopicPartitionReplica, String> replicaAssignment2 = tuple23._2();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkClient, adminClientOpt, partitionAssignment2.toMap(Predef$.MODULE$.$conforms()), replicaAssignment2, adminZkClient);
        if (zkClient.reassignPartitionsInProgress()) {
            Predef$.MODULE$.println("There is an existing assignment running.");
            reassignPartitionsCommand.maybeLimit(throttle);
        } else {
            this.printCurrentAssignment(zkClient, partitionAssignment2.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x$6 -> ((TopicPartition)x$6._1()).topic(), Seq$.MODULE$.canBuildFrom()));
            if (throttle.interBrokerLimit() >= 0L || throttle.replicaAlterLogDirsLimit() >= 0L) {
                Predef$.MODULE$.println(String.format("Warning: You must run Verify periodically, until the reassignment completes, to ensure the throttle is removed. You can also alter the throttle by rerunning the Execute command passing a new value.", new Object[0]));
            }
            if (reassignPartitionsCommand.reassignPartitions(throttle, timeoutMs)) {
                Predef$.MODULE$.println("Successfully started reassignment of partitions.");
            } else {
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionAssignment2})));
            }
        }
    }

    public long executeAssignment$default$5() {
        return 10000L;
    }

    public void printCurrentAssignment(KafkaZkClient zkClient, Seq<String> topics) {
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> currentPartitionReplicaAssignment = zkClient.getReplicaAssignmentForTopics(topics.toSet());
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.formatAsReassignmentJson(currentPartitionReplicaAssignment, (Map<TopicPartitionReplica, String>)scala.collection.Map$.MODULE$.empty())})));
    }

    public String formatAsReassignmentJson(Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartitionReplica, String> replicaLogDirAssignment) {
        return Json$.MODULE$.encodeAsString(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partitions"), JavaConverters$.MODULE$.asJavaIterableConverter(partitionsToBeReassigned.map((Function1<Tuple2, java.util.Map> & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            java.util.Map map = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("topic"), tp.topic()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("partition"), BoxesRunTime.boxToInteger(tp.partition())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("replicas"), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas).asJava()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("log_dirs"), JavaConverters$.MODULE$.seqAsJavaListConverter(replicas.map((Function1<Object, String> & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.$anonfun$formatAsReassignmentJson$2(replicaLogDirAssignment, tp, BoxesRunTime.unboxToInt(r)), Seq$.MODULE$.canBuildFrom())).asJava())}))).asJava();
            return map;
        }, Iterable$.MODULE$.canBuildFrom())).asJava())}))).asJava());
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parsePartitionReassignmentData(String jsonData) {
        ListBuffer partitionAssignment = (ListBuffer)ListBuffer$.MODULE$.empty();
        GenMap replicaAssignment = Map$.MODULE$.empty();
        Option$.MODULE$.option2Iterable(Json$.MODULE$.parseFull(jsonData)).toSeq().foreach(arg_0 -> ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1$adapted(partitionAssignment, (scala.collection.mutable.Map)replicaAssignment, arg_0));
        return new Tuple2<ListBuffer, GenMap>(partitionAssignment, replicaAssignment);
    }

    public Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> parseAndValidate(KafkaZkClient zkClient, String reassignmentJsonString) {
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple2 = this.parsePartitionReassignmentData(reassignmentJsonString);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned = tuple2._1();
        Map<TopicPartitionReplica, String> replicaAssignment = tuple2._2();
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple22 = new Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>>(partitionsToBeReassigned, replicaAssignment);
        Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>> tuple23 = tuple22;
        Seq<Tuple2<TopicPartition, Seq<Object>>> partitionsToBeReassigned2 = tuple23._1();
        Map<TopicPartitionReplica, String> replicaAssignment2 = tuple23._2();
        if (partitionsToBeReassigned2.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        if (partitionsToBeReassigned2.exists((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseAndValidate$1(x$9)))) {
            throw new AdminCommandFailedException("Partition replica list cannot be empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates(partitionsToBeReassigned2.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$10 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$10;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$11 -> {
            Tuple2 tuple2 = x0$11;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2(tp, CoreUtils$.MODULE$.duplicates(replicas));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x0$12 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parseAndValidate$4(x0$12)));
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$13 -> {
                Tuple2 tuple2 = x0$13;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Iterable duplicateReplicas = (Iterable)tuple2._2();
                String string = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tp, duplicateReplicas.mkString(",")}));
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatesMsg})));
        }
        Seq proposedTopics = (Seq)((SeqLike)partitionsToBeReassigned2.map((Function1<Tuple2, String> & Serializable & scala.Serializable)x0$14 -> {
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            String string = tp.topic();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).distinct();
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> existingAssignment = zkClient.getReplicaAssignmentForTopics(proposedTopics.toSet());
        Seq nonExistentPartitions = (Seq)((TraversableLike)partitionsToBeReassigned2.map((Function1<Tuple2, TopicPartition> & Serializable & scala.Serializable)x0$15 -> {
            TopicPartition tp;
            Tuple2 tuple2 = x0$15;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            TopicPartition topicPartition = tp = (TopicPartition)tuple2._1();
            return topicPartition;
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1<TopicPartition, Object> & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean(existingAssignment.contains(key)));
        if (nonExistentPartitions.nonEmpty()) {
            throw new AdminCommandFailedException("The proposed assignment contains non-existent partitions: " + nonExistentPartitions);
        }
        Seq<Object> existingBrokerIDs = zkClient.getSortedBrokerList();
        scala.collection.immutable.Set nonExistingBrokerIDs = ((TraversableOnce)((TraversableLike)partitionsToBeReassigned2.toMap(Predef$.MODULE$.$conforms()).values().flatten(Predef$.MODULE$.$conforms())).filterNot((Function1<Object, Object> & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean(existingBrokerIDs.contains(elem)))).toSet();
        if (nonExistingBrokerIDs.nonEmpty()) {
            throw new AdminCommandFailedException("The proposed assignment contains non-existent brokerIDs: " + nonExistingBrokerIDs.mkString(","));
        }
        return new Tuple2<Seq<Tuple2<TopicPartition, Seq<Object>>>, Map<TopicPartitionReplica, String>>(partitionsToBeReassigned2, replicaAssignment2);
    }

    private Map<TopicPartition, ReassignmentStatus> checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned) {
        scala.collection.immutable.Map<TopicPartition, Seq<Object>> partitionsBeingReassigned = zkClient.getPartitionReassignment();
        return ((TraversableOnce)partitionsToBeReassigned.keys().map((Function1<TopicPartition, Tuple2> & Serializable & scala.Serializable)topicAndPartition -> new Tuple2<TopicPartition, ReassignmentStatus>((TopicPartition)topicAndPartition, MODULE$.checkIfPartitionReassignmentSucceeded(zkClient, (TopicPartition)topicAndPartition, partitionsToBeReassigned, (Map<TopicPartition, Seq<Object>>)partitionsBeingReassigned)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<TopicPartitionReplica, ReassignmentStatus> checkIfReplicaReassignmentSucceeded(Option<AdminClient> adminClientOpt, Map<TopicPartitionReplica, String> replicaAssignment) {
        GenMap genMap;
        if (replicaAssignment.nonEmpty()) {
            AdminClient adminClient = (AdminClient)adminClientOpt.getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> {
                throw new AdminCommandFailedException("bootstrap-server needs to be provided in order to reassign replica to the specified log directory");
            });
            genMap = JavaConverters$.MODULE$.mapAsScalaMapConverter(adminClient.describeReplicaLogDirs(JavaConverters$.MODULE$.setAsJavaSetConverter(replicaAssignment.keySet()).asJava()).all().get()).asScala();
        } else {
            genMap = scala.collection.Map$.MODULE$.empty();
        }
        GenMap replicaLogDirInfos = genMap;
        return replicaAssignment.map(arg_0 -> ReassignPartitionsCommand$.$anonfun$checkIfReplicaReassignmentSucceeded$2((Map)replicaLogDirInfos, arg_0), scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(KafkaZkClient zkClient, TopicPartition topicAndPartition, Map<TopicPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicPartition, Seq<Object>> partitionsBeingReassigned) {
        ReassignmentStatus reassignmentStatus;
        Seq newReplicas = (Seq)partitionsToBeReassigned.apply(topicAndPartition);
        Option option = partitionsBeingReassigned.get(topicAndPartition);
        if (option instanceof Some) {
            reassignmentStatus = ReassignmentInProgress$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            ReassignmentStatus reassignmentStatus2;
            Seq<Object> assignedReplicas;
            Seq<Object> seq = assignedReplicas = zkClient.getReplicasForPartition(new TopicPartition(topicAndPartition.topic(), topicAndPartition.partition()));
            Seq seq2 = newReplicas;
            if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
                reassignmentStatus2 = ReassignmentCompleted$.MODULE$;
            } else {
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                reassignmentStatus2 = ReassignmentFailed$.MODULE$;
            }
            reassignmentStatus = reassignmentStatus2;
        } else {
            throw new MatchError(option);
        }
        return reassignmentStatus;
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsCommand.ReassignPartitionsCommandOptions validateAndParseArgs(String[] args) {
        void var2_2;
        block6: {
            ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts;
            block7: {
                block5: {
                    opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
                    if (args.length == 0) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "This command moves topic partitions between replicas.");
                    }
                    int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count((Function1<OptionSpec, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$validateAndParseArgs$1(opts, x$1)));
                    if (actions != 1) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
                    }
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
                    if (!opts.options().has(opts.verifyOpt())) break block5;
                    if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
                    }
                    CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), opts.verifyOpt(), (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()})));
                    break block6;
                }
                if (!opts.options().has(opts.generateOpt())) break block7;
                if (!opts.options().has(opts.topicsToMoveJsonFileOpt()) || !opts.options().has(opts.brokerListOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
                }
                CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), opts.generateOpt(), (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.interBrokerThrottleOpt(), opts.replicaAlterLogDirsThrottleOpt(), opts.reassignmentJsonFileOpt()})));
                break block6;
            }
            if (!opts.options().has(opts.executeOpt())) break block6;
            if (!opts.options().has(opts.reassignmentJsonFileOpt())) {
                throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
            }
            CommandLineUtils$.MODULE$.checkInvalidArgs(opts.parser(), opts.options(), opts.executeOpt(), (Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.topicsToMoveJsonFileOpt(), opts.disableRackAware(), opts.brokerListOpt()})));
        }
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError(tuple2);
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError(reassignmentStatus);
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyAssignment$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) throw new MatchError(tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        ReassignmentStatus status = (ReassignmentStatus)tuple2._2();
        ReassignmentStatus reassignmentStatus = status;
        if (ReassignmentCompleted$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s completed successfully")).format(Predef$.MODULE$.genericWrapArray(new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ReassignmentFailed$.MODULE$.equals(reassignmentStatus)) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s failed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!ReassignmentInProgress$.MODULE$.equals(reassignmentStatus)) throw new MatchError(reassignmentStatus);
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of replica %s is still in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{replica})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$1(Tuple2 x0$3) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$removeThrottle$2(Tuple2 x0$4) {
        ReassignmentStatus status;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ReassignmentStatus reassignmentStatus = status = (ReassignmentStatus)tuple2._2();
        ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
        boolean bl = !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$removeThrottle$7(AdminZkClient adminZkClient$1, BooleanRef changed$1, String topic) {
        block0: {
            Properties configs = adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
            if (!(configs.remove(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) != null | configs.remove(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()) != null)) break block0;
            adminZkClient$1.changeTopicConfig(topic, configs);
            changed$1.elem = true;
        }
    }

    public static final /* synthetic */ int $anonfun$generateAssignment$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ String $anonfun$formatAsReassignmentJson$2(Map replicaLogDirAssignment$1, TopicPartition tp$1, int r) {
        return (String)replicaLogDirAssignment$1.getOrElse(new TopicPartitionReplica(tp$1.topic(), tp$1.partition(), r), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.AnyLogDir());
    }

    public static final /* synthetic */ boolean $anonfun$parsePartitionReassignmentData$6(Tuple2 x$7) {
        Object T2 = x$7._2();
        String string = MODULE$.AnyLogDir();
        return T2 == null ? string != null : !T2.equals(string);
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$2(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue partitionsSeq) {
        partitionsSeq.asJsonArray().iterator().foreach((Function1<JsonValue, scala.collection.mutable.Map> & Serializable & scala.Serializable)p -> {
            Seq seq;
            JsonObject partitionFields = p.asJsonObject();
            String topic = partitionFields.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
            int partition = BoxesRunTime.unboxToInt(partitionFields.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
            Seq newReplicas = partitionFields.apply("replicas").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Option<JsonValue> option = partitionFields.get("log_dirs");
            if (option instanceof Some) {
                Some some = (Some)option;
                JsonValue jsonValue = (JsonValue)some.value();
                seq = jsonValue.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            } else if (None$.MODULE$.equals(option)) {
                seq = newReplicas.map((Function1<Object, String> & Serializable & scala.Serializable)r -> ReassignPartitionsCommand$.MODULE$.AnyLogDir(), Seq$.MODULE$.canBuildFrom());
            } else {
                throw new MatchError(option);
            }
            Seq newLogDirs = seq;
            if (newReplicas.size() != newLogDirs.size()) {
                throw new AdminCommandFailedException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Size of replicas list ", " is different from "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{newReplicas})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of log dirs list ", " for partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{newLogDirs, new TopicPartition(topic, partition)})));
            }
            partitionAssignment$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(topic, partition)), newReplicas));
            return (scala.collection.mutable.Map)replicaAssignment$1.$plus$plus$eq((TraversableOnce)((TraversableLike)((TraversableLike)newReplicas.zip(newLogDirs, Seq$.MODULE$.canBuildFrom())).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$9 -> {
                Tuple2 tuple2 = x0$9;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int replica = tuple2._1$mcI$sp();
                String logDir = (String)tuple2._2();
                Tuple2<TopicPartitionReplica, String> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartitionReplica(topic, partition, replica)), logDir);
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$6(x$7))));
        });
    }

    public static final /* synthetic */ void $anonfun$parsePartitionReassignmentData$1(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue js) {
        Option$.MODULE$.option2Iterable(js.asJsonObject().get("partitions")).toSeq().foreach((Function1<JsonValue, Object> & Serializable & scala.Serializable)partitionsSeq -> {
            ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$2(partitionAssignment$1, replicaAssignment$1, partitionsSeq);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$1(Tuple2 x$9) {
        return ((SeqLike)x$9._2()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$parseAndValidate$4(Tuple2 x0$12) {
        Tuple2 tuple2 = x0$12;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterable duplicatedReplicas = (Iterable)tuple2._2();
        boolean bl = duplicatedReplicas.nonEmpty();
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Tuple2 $anonfun$checkIfReplicaReassignmentSucceeded$2(Map replicaLogDirInfos$1, Tuple2 x0$16) {
        void var3_12;
        Tuple2 tuple2 = x0$16;
        if (tuple2 == null) throw new MatchError(tuple2);
        TopicPartitionReplica replica = (TopicPartitionReplica)tuple2._1();
        String newLogDir = (String)tuple2._2();
        Option option = replicaLogDirInfos$1.get(replica);
        if (option instanceof Some) {
            ReassignmentStatus reassignmentStatus;
            Some some = (Some)option;
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaLogDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)some.value();
            if (replicaLogDirInfo.getCurrentReplicaLogDir() == null) {
                Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replica.topic(), BoxesRunTime.boxToInteger(replica.partition())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker ", ". There is likely offline log directory on the broker."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(replica.brokerId())})));
                reassignmentStatus = ReassignmentFailed$.MODULE$;
            } else {
                String string = replicaLogDirInfo.getFutureReplicaLogDir();
                String string2 = newLogDir;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    reassignmentStatus = ReassignmentInProgress$.MODULE$;
                } else if (replicaLogDirInfo.getFutureReplicaLogDir() != null) {
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replica.topic(), BoxesRunTime.boxToInteger(replica.partition()), BoxesRunTime.boxToInteger(replica.brokerId())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is being moved to log dir ", " instead of ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicaLogDirInfo.getFutureReplicaLogDir(), newLogDir})));
                    reassignmentStatus = ReassignmentFailed$.MODULE$;
                } else {
                    String string3 = replicaLogDirInfo.getCurrentReplicaLogDir();
                    String string4 = newLogDir;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        reassignmentStatus = ReassignmentCompleted$.MODULE$;
                    } else {
                        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " on broker ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replica.topic(), BoxesRunTime.boxToInteger(replica.partition()), BoxesRunTime.boxToInteger(replica.brokerId())})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not being moved from log dir ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicaLogDirInfo.getCurrentReplicaLogDir(), newLogDir})));
                        reassignmentStatus = ReassignmentFailed$.MODULE$;
                    }
                }
            }
            ReassignmentInProgress$ reassignmentInProgress$ = reassignmentStatus;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", "-", " is not found in any live log dir on broker ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replica.topic(), BoxesRunTime.boxToInteger(replica.partition()), BoxesRunTime.boxToInteger(replica.brokerId())})));
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
        }
        void status = var3_12;
        return new Tuple2<TopicPartitionReplica, void>(replica, status);
    }

    public static final /* synthetic */ boolean $anonfun$validateAndParseArgs$1(ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1, OptionSpec x$1) {
        return opts$1.options().has(x$1);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.NoThrottle = new ReassignPartitionsCommand.Throttle(-1L, -1L, ReassignPartitionsCommand$Throttle$.MODULE$.apply$default$3());
        this.AnyLogDir = "any";
    }

    public static final /* synthetic */ Object $anonfun$parsePartitionReassignmentData$1$adapted(ListBuffer partitionAssignment$1, scala.collection.mutable.Map replicaAssignment$1, JsonValue js) {
        ReassignPartitionsCommand$.$anonfun$parsePartitionReassignmentData$1(partitionAssignment$1, replicaAssignment$1, js);
        return BoxedUnit.UNIT;
    }
}

