/*
 * Decompiled with CFR 0.152.
 */
package jersey.repackaged.com.google.common.util.concurrent;

import jersey.repackaged.com.google.common.base.Preconditions;
import jersey.repackaged.com.google.common.util.concurrent.AbstractFuture;
import jersey.repackaged.com.google.common.util.concurrent.ForwardingListenableFuture;
import jersey.repackaged.com.google.common.util.concurrent.Futures;
import jersey.repackaged.com.google.common.util.concurrent.ListenableFuture;

final class AsyncSettableFuture<V>
extends ForwardingListenableFuture<V> {
    private final NestedFuture<V> nested = new NestedFuture();
    private final ListenableFuture<V> dereferenced = Futures.dereference(this.nested);

    public static <V> AsyncSettableFuture<V> create() {
        return new AsyncSettableFuture<V>();
    }

    private AsyncSettableFuture() {
    }

    @Override
    protected ListenableFuture<V> delegate() {
        return this.dereferenced;
    }

    public boolean setFuture(ListenableFuture<? extends V> future) {
        return this.nested.setFuture(Preconditions.checkNotNull(future));
    }

    private static final class NestedFuture<V>
    extends AbstractFuture<ListenableFuture<? extends V>> {
        private NestedFuture() {
        }

        boolean setFuture(ListenableFuture<? extends V> value) {
            boolean result2 = this.set(value);
            if (this.isCancelled()) {
                value.cancel(this.wasInterrupted());
            }
            return result2;
        }
    }
}

