/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.AbstractTemporaryFile;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.UrlType;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ResourceImpl
extends AbstractTemporaryFile
implements Resource {
    private final String mimeType;
    private final Set<UrlType> urlTypes;
    private final URI actualLocation;

    public ResourceImpl(RdfResourceEntry rdfResourceEntry, String mimeType, URI actualLocation) {
        super(rdfResourceEntry.getResourceUrl(), "media_resource_", null);
        this.mimeType = mimeType;
        this.urlTypes = new HashSet<UrlType>(rdfResourceEntry.getUrlTypes());
        this.actualLocation = actualLocation;
    }

    @Override
    public Path getContentPath() {
        return super.getContentPath();
    }

    @Override
    public Set<UrlType> getUrlTypes() {
        return Collections.unmodifiableSet(this.urlTypes);
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public URI getActualLocation() {
        return this.actualLocation;
    }

    @Override
    public File getContentFile() {
        return Optional.ofNullable(this.getContentPath()).map(Path::toFile).orElse(null);
    }
}

