/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceExtractionResult
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceExtractionResult.class);
    private final AbstractResourceMetadata metadata;
    private final List<Thumbnail> thumbnails;

    public ResourceExtractionResult(AbstractResourceMetadata metadata, List<? extends Thumbnail> thumbnails) {
        this.metadata = metadata;
        this.thumbnails = thumbnails == null ? null : new ArrayList<Thumbnail>(thumbnails);
    }

    public AbstractResourceMetadata getOriginalMetadata() {
        return this.metadata;
    }

    public ResourceMetadata getMetadata() {
        return this.metadata == null ? null : this.metadata.prepareForSerialization();
    }

    public List<Thumbnail> getThumbnails() {
        return this.thumbnails == null ? null : Collections.unmodifiableList(this.thumbnails);
    }

    @Override
    public void close() throws IOException {
        if (this.thumbnails == null) {
            return;
        }
        IOException exception = null;
        for (Thumbnail thumbnail : this.thumbnails) {
            try {
                thumbnail.close();
            }
            catch (IOException e) {
                exception = Optional.ofNullable(exception).orElse(e);
                LOGGER.warn("Could not close thumbnail: {}", (Object)thumbnail.getResourceUrl(), (Object)e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }
}

