/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.model;

import eu.europeana.corelib.definitions.jibx.ColorSpaceType;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.model.AbstractResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.ResourceMetadata;
import eu.europeana.metis.mediaprocessing.model.Thumbnail;
import eu.europeana.metis.mediaprocessing.model.WebResource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImageResourceMetadata
extends AbstractResourceMetadata {
    private static final long serialVersionUID = -1818426883878915580L;
    private int width;
    private int height;
    private ColorSpaceType colorSpace;
    private List<String> dominantColors;

    public ImageResourceMetadata(String mimeType, String resourceUrl, long contentSize, int width, int height, ColorSpaceType colorSpace, List<String> dominantColors, List<? extends Thumbnail> thumbnails) throws MediaExtractionException {
        super(mimeType, resourceUrl, contentSize, thumbnails);
        this.width = width;
        this.height = height;
        this.colorSpace = colorSpace;
        Optional<String> badColor = dominantColors.stream().filter(color -> !color.matches("[0-9A-F]{6}")).findAny();
        if (badColor.isPresent()) {
            throw new MediaExtractionException("Unrecognized hex String: " + badColor.get());
        }
        this.dominantColors = dominantColors.stream().map(c -> "#" + c).collect(Collectors.toList());
    }

    ImageResourceMetadata() {
    }

    @Override
    protected ResourceMetadata prepareForSerialization() {
        return new ResourceMetadata(this);
    }

    @Override
    protected void updateResource(WebResource resource) {
        super.updateResource(resource);
        resource.setWidth(this.width);
        resource.setHeight(this.height);
        resource.setOrientation(this.width > this.height ? WebResource.Orientation.LANDSCAPE : WebResource.Orientation.PORTRAIT);
        resource.setColorspace(this.colorSpace);
        resource.setDominantColors(this.getDominantColors());
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorSpaceType getColorSpace() {
        return this.colorSpace;
    }

    public List<String> getDominantColors() {
        return this.dominantColors == null ? Collections.emptyList() : Collections.unmodifiableList(this.dominantColors);
    }
}

