/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.http;

import eu.europeana.metis.mediaprocessing.http.AbstractHttpClient;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDownloadClient
extends AbstractHttpClient<RdfResourceEntry, Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceDownloadClient.class);
    private final Predicate<String> shouldDownloadMimetype;

    public ResourceDownloadClient(int maxRedirectCount, Predicate<String> shouldDownloadMimetype, int connectTimeout, int socketTimeout) {
        super(maxRedirectCount, connectTimeout, socketTimeout);
        this.shouldDownloadMimetype = shouldDownloadMimetype;
    }

    @Override
    protected String getResourceUrl(RdfResourceEntry resourceEntry) {
        return resourceEntry.getResourceUrl();
    }

    @Override
    protected Resource createResult(RdfResourceEntry resourceEntry, URI actualUri, String mimeType, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        ResourceImpl resource = new ResourceImpl(resourceEntry, mimeType, actualUri);
        try {
            if (this.shouldDownloadMimetype.test(mimeType)) {
                LOGGER.debug("Starting download of resource: {}", (Object)resourceEntry.getResourceUrl());
                ResourceDownloadClient.downloadResource(resourceEntry.getResourceUrl(), resource, contentRetriever);
                LOGGER.debug("Finished download of resource: {}", (Object)resourceEntry.getResourceUrl());
            } else {
                LOGGER.debug("Media type {} not supported - choosing not to download resource: {}", (Object)mimeType, (Object)resourceEntry.getResourceUrl());
                resource.markAsNoContent();
            }
        }
        catch (IOException | RuntimeException e) {
            resource.close();
            throw e;
        }
        return resource;
    }

    private static void downloadResource(String resourceUrl, ResourceImpl resource, AbstractHttpClient.ContentRetriever contentRetriever) throws IOException {
        try (InputStream inputStream = contentRetriever.getContent();){
            resource.setContent(inputStream);
        }
        if (resource.getContentSize() == 0L) {
            throw new IOException("Download failed of resource " + resourceUrl + ": no content found.");
        }
    }
}

