/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHttpClient<I, R>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpClient.class);
    private static final int HTTP_SUCCESS_MIN_INCLUSIVE = 200;
    private static final int HTTP_SUCCESS_MAX_EXCLUSIVE = 300;
    private static final long CLEAN_TASK_CHECK_INTERVAL_IN_SECONDS = 60L;
    private static final long MAX_TASK_IDLE_TIME_IN_SECONDS = 300L;
    private final PoolingHttpClientConnectionManager connectionManager;
    private final CloseableHttpClient client;
    private final ScheduledExecutorService connectionCleaningSchedule = Executors.newScheduledThreadPool(1);

    AbstractHttpClient(int maxRedirectCount, int connectTimeout, int socketTimeout) {
        RequestConfig requestConfig = RequestConfig.custom().setMaxRedirects(maxRedirectCount).setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.connectionManager.setDefaultMaxPerRoute(1);
        this.client = HttpClients.custom().setDefaultRequestConfig(requestConfig).setConnectionManager(this.connectionManager).build();
        this.connectionCleaningSchedule.scheduleWithFixedDelay(() -> this.cleanConnections(this.connectionManager), 60L, 60L, TimeUnit.SECONDS);
    }

    private void cleanConnections(PoolingHttpClientConnectionManager connectionManager) {
        try {
            connectionManager.closeExpiredConnections();
            connectionManager.closeIdleConnections(300L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Could not clean up expired and idle connections.", e);
        }
    }

    public R download(I resourceEntry) throws IOException {
        String resourceUlr = this.getResourceUrl(resourceEntry);
        HttpGet httpGet = new HttpGet(resourceUlr);
        HttpClientContext context = HttpClientContext.create();
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)httpGet, context);){
            int status = response.getStatusLine().getStatusCode();
            if (!AbstractHttpClient.httpCallIsSuccessful(status)) {
                throw new IOException("Download failed of resource " + resourceUlr + ". Status code " + status + " (message: " + response.getStatusLine().getReasonPhrase() + ").");
            }
            HttpEntity responseEntity = response.getEntity();
            String mimeType = Optional.ofNullable(responseEntity).map(HttpEntity::getContentType).map(NameValuePair::getValue).orElse("application/octet-stream");
            List<URI> redirectUris = context.getRedirectLocations();
            URI actualUri = redirectUris == null ? httpGet.getURI() : redirectUris.get(redirectUris.size() - 1);
            ContentRetriever content = responseEntity == null ? ContentRetriever.forEmptyContent() : responseEntity::getContent;
            R r = this.createResult(resourceEntry, actualUri, mimeType, content);
            return r;
        }
    }

    private static boolean httpCallIsSuccessful(int status) {
        return status >= 200 && status < 300;
    }

    protected abstract String getResourceUrl(I var1);

    protected abstract R createResult(I var1, URI var2, String var3, ContentRetriever var4) throws IOException;

    @Override
    public void close() throws IOException {
        this.connectionCleaningSchedule.shutdown();
        this.connectionManager.close();
        this.client.close();
    }

    @FunctionalInterface
    protected static interface ContentRetriever {
        public InputStream getContent() throws IOException;

        public static ContentRetriever forEmptyContent() {
            return () -> new ByteArrayInputStream(new byte[0]);
        }
    }
}

