/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

public enum ResourceType {
    AUDIO,
    VIDEO,
    TEXT,
    IMAGE,
    UNKNOWN;


    public static ResourceType getResourceType(String mimeType) {
        if (mimeType == null) {
            return UNKNOWN;
        }
        ResourceType result2 = mimeType.startsWith("image/") ? IMAGE : (mimeType.startsWith("audio/") ? AUDIO : (mimeType.startsWith("video/") ? VIDEO : (ResourceType.isText(mimeType) ? TEXT : UNKNOWN)));
        return result2;
    }

    private static boolean isText(String mimeType) {
        switch (mimeType) {
            case "application/xml": 
            case "application/rtf": 
            case "application/epub": 
            case "application/pdf": 
            case "application/xhtml+xml": {
                return true;
            }
        }
        return mimeType.startsWith("text/");
    }

    static boolean shouldDownloadMimetype(String mimeType) {
        ResourceType resourceType = ResourceType.getResourceType(mimeType);
        return IMAGE == resourceType || TEXT == resourceType;
    }
}

