/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.MediaExtractor;
import eu.europeana.metis.mediaprocessing.exception.MediaExtractionException;
import eu.europeana.metis.mediaprocessing.exception.MediaProcessorException;
import eu.europeana.metis.mediaprocessing.extraction.AudioVideoProcessor;
import eu.europeana.metis.mediaprocessing.extraction.CommandExecutor;
import eu.europeana.metis.mediaprocessing.extraction.ImageProcessor;
import eu.europeana.metis.mediaprocessing.extraction.MediaProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ResourceType;
import eu.europeana.metis.mediaprocessing.extraction.TextProcessor;
import eu.europeana.metis.mediaprocessing.extraction.ThumbnailGenerator;
import eu.europeana.metis.mediaprocessing.http.ResourceDownloadClient;
import eu.europeana.metis.mediaprocessing.model.RdfResourceEntry;
import eu.europeana.metis.mediaprocessing.model.Resource;
import eu.europeana.metis.mediaprocessing.model.ResourceExtractionResult;
import java.io.IOException;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaExtractorImpl
implements MediaExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaExtractorImpl.class);
    private final ResourceDownloadClient resourceDownloadClient;
    private final Tika tika;
    private final ImageProcessor imageProcessor;
    private final AudioVideoProcessor audioVideoProcessor;
    private final TextProcessor textProcessor;

    MediaExtractorImpl(ResourceDownloadClient resourceDownloadClient, Tika tika, ImageProcessor imageProcessor, AudioVideoProcessor audioVideoProcessor, TextProcessor textProcessor) {
        this.resourceDownloadClient = resourceDownloadClient;
        this.tika = tika;
        this.imageProcessor = imageProcessor;
        this.audioVideoProcessor = audioVideoProcessor;
        this.textProcessor = textProcessor;
    }

    public static MediaExtractorImpl newInstance(int redirectCount, int thumbnailGenerateTimeout, int audioVideoProbeTimeout, int connectTimeout, int socketTimeout) throws MediaProcessorException {
        ThumbnailGenerator thumbnailGenerator = new ThumbnailGenerator(new CommandExecutor(thumbnailGenerateTimeout));
        ResourceDownloadClient downloadClient = new ResourceDownloadClient(redirectCount, ResourceType::shouldDownloadMimetype, connectTimeout, socketTimeout);
        return new MediaExtractorImpl(downloadClient, new Tika(), new ImageProcessor(thumbnailGenerator), new AudioVideoProcessor(new CommandExecutor(audioVideoProbeTimeout)), new TextProcessor(thumbnailGenerator));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceExtractionResult performMediaExtraction(RdfResourceEntry resourceEntry) throws MediaExtractionException {
        try (Resource resource = (Resource)this.resourceDownloadClient.download(resourceEntry);){
            ResourceExtractionResult resourceExtractionResult = this.processResource(resource);
            return resourceExtractionResult;
        }
        catch (IOException | RuntimeException e) {
            throw new MediaExtractionException("Problem while processing " + resourceEntry.getResourceUrl(), e);
        }
    }

    String verifyMimeType(Resource resource) throws MediaExtractionException {
        String detectedMimeType;
        try {
            detectedMimeType = resource.hasContent() ? this.tika.detect(resource.getContentPath()) : this.tika.detect(resource.getActualLocation().toURL());
        }
        catch (IOException e) {
            throw new MediaExtractionException("Mime type checking error", e);
        }
        String providedMimeType = resource.getMimeType();
        if (!("application/xhtml+xml".equals(detectedMimeType) && providedMimeType.startsWith("text/html") || detectedMimeType.equals(providedMimeType))) {
            LOGGER.info("Invalid mime type provided (should be {}, was {}): {}", detectedMimeType, providedMimeType, resource.getResourceUrl());
        }
        return detectedMimeType;
    }

    MediaProcessor chooseMediaProcessor(ResourceType resourceType) {
        MediaProcessor processor;
        switch (resourceType) {
            case TEXT: {
                processor = this.textProcessor;
                break;
            }
            case AUDIO: 
            case VIDEO: {
                processor = this.audioVideoProcessor;
                break;
            }
            case IMAGE: {
                processor = this.imageProcessor;
                break;
            }
            default: {
                processor = null;
            }
        }
        return processor;
    }

    ResourceExtractionResult processResource(Resource resource) throws MediaExtractionException {
        String detectedMimeType = this.verifyMimeType(resource);
        try {
            if (!resource.hasContent() && ResourceType.shouldDownloadMimetype(detectedMimeType)) {
                throw new MediaExtractionException("File content is not downloaded and mimeType does not support processing without a downloaded file.");
            }
        }
        catch (IOException e) {
            throw new MediaExtractionException("Could not determine whether resource has content.", e);
        }
        MediaProcessor processor = this.chooseMediaProcessor(ResourceType.getResourceType(detectedMimeType));
        return processor == null ? null : processor.process(resource, detectedMimeType);
    }

    @Override
    public void close() throws IOException {
        this.resourceDownloadClient.close();
    }
}

