/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.metis.mediaprocessing.extraction;

import eu.europeana.metis.mediaprocessing.exception.CommandExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommandExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandExecutor.class);
    private static final String COMMAND_ARGUMENT_REGEX = "[0-9A-Za-z_\\/\\\\:\\-. ]+";
    private final ProcessFactory processFactory;
    private final int commandTimeout;

    CommandExecutor(int commandTimeout) {
        this(commandTimeout, (command, redirectErrorStream) -> new ProcessBuilder(command).redirectErrorStream(redirectErrorStream).start());
    }

    CommandExecutor(int commandTimeout, ProcessFactory processFactory) {
        this.commandTimeout = commandTimeout;
        this.processFactory = processFactory;
    }

    private static void sanitizeCommand(List<String> command) {
        boolean validCommand = command.stream().allMatch(argument -> Pattern.matches(COMMAND_ARGUMENT_REGEX, argument));
        if (!validCommand) {
            throw new IllegalArgumentException("Command contains characters that are not allowed.");
        }
    }

    List<String> execute(List<String> command, boolean redirectErrorStream) throws CommandExecutionException {
        try {
            return this.executeInternal(command, redirectErrorStream);
        }
        catch (IOException | RuntimeException e) {
            throw new CommandExecutionException("Problem while executing command.", e);
        }
    }

    List<String> executeInternal(List<String> command, boolean redirectErrorStream) throws IOException, CommandExecutionException {
        List<String> result2;
        String error;
        Process process = this.processFactory.createProcess(command, redirectErrorStream);
        try {
            if (!process.waitFor(this.commandTimeout, TimeUnit.SECONDS)) {
                process.destroyForcibly();
                throw new CommandExecutionException("The process did not terminate within the timeout of " + this.commandTimeout + " seconds. It was forcibly destroyed.");
            }
        }
        catch (InterruptedException e) {
            process.destroyForcibly();
            Thread.currentThread().interrupt();
            throw new CommandExecutionException("Process was interrupted.", e);
        }
        if (redirectErrorStream) {
            error = null;
        } else {
            try (InputStream errorStream = process.getErrorStream();){
                String errorStreamContents = IOUtils.toString(errorStream, Charset.defaultCharset());
                error = StringUtils.isBlank(errorStreamContents) ? null : errorStreamContents;
            }
        }
        try (InputStream in = process.getInputStream();){
            result2 = IOUtils.readLines(in, Charset.defaultCharset());
        }
        if (error != null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Command presented with error:\nCommand: [{}]\nError: {}", (Object)String.join((CharSequence)" ", command), (Object)error);
            }
            if (result2.isEmpty()) {
                throw new IOException("External process returned error content:\n" + error);
            }
        }
        return result2;
    }

    public static interface ProcessFactory {
        public Process createProcess(List<String> var1, boolean var2) throws IOException;
    }
}

