/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.io;

import eu.europeana.cloud.common.model.DataSet;
import eu.europeana.cloud.common.model.Representation;
import eu.europeana.cloud.mcs.driver.DataSetServiceClient;
import eu.europeana.cloud.mcs.driver.exception.DriverException;
import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.cloud.service.mcs.exception.MCSException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddResultToDataSetBolt
extends AbstractDpsBolt {
    private String ecloudMcsAddress;
    private static final Logger LOGGER = LoggerFactory.getLogger(AddResultToDataSetBolt.class);
    private DataSetServiceClient dataSetServiceClient;

    public AddResultToDataSetBolt(String ecloudMcsAddress) {
        this.ecloudMcsAddress = ecloudMcsAddress;
    }

    @Override
    public void prepare() {
        this.dataSetServiceClient = new DataSetServiceClient(this.ecloudMcsAddress);
    }

    @Override
    public void execute(StormTaskTuple t) {
        String authorizationHeader = t.getParameter("AUTHORIZATION_HEADER");
        String resultUrl = t.getParameter("OUTPUT_URL");
        try {
            List<String> datasets = this.readDataSetsList(t.getParameter("OUTPUT_DATA_SETS"));
            if (datasets != null) {
                LOGGER.info("Data-sets that will be affected: {}", (Object)datasets);
                for (String datasetLocation : datasets) {
                    Representation resultRepresentation = this.parseResultUrl(resultUrl);
                    DataSet dataSet = this.parseDataSetURl(datasetLocation);
                    this.assignRepresentationToDataSet(dataSet, resultRepresentation, authorizationHeader);
                }
            }
            if (t.getParameter("UNIFIED_ERROR_MESSAGE") == null) {
                this.emitSuccessNotification(t.getTaskId(), t.getFileUrl(), "", "", resultUrl);
            } else {
                this.emitSuccessNotification(t.getTaskId(), t.getFileUrl(), "", "", resultUrl, t.getParameter("UNIFIED_ERROR_MESSAGE"), t.getParameter("EXCEPTION_ERROR_MESSAGE"));
            }
        }
        catch (DriverException | MCSException e) {
            LOGGER.warn("Error while communicating with MCS {}", (Object)e.getMessage());
            this.emitErrorNotification(t.getTaskId(), resultUrl, e.getMessage(), "The cause of the error is: " + e.getCause());
        }
        catch (MalformedURLException e) {
            this.emitErrorNotification(t.getTaskId(), resultUrl, e.getMessage(), "The cause of the error is: " + e.getCause());
        }
    }

    private void assignRepresentationToDataSet(DataSet dataSet, Representation resultRepresentation, String authorizationHeader) throws MCSException, DriverException {
        int retries = 3;
        while (true) {
            try {
                this.dataSetServiceClient.assignRepresentationToDataSet(dataSet.getProviderId(), dataSet.getId(), resultRepresentation.getCloudId(), resultRepresentation.getRepresentationName(), resultRepresentation.getVersion(), "Authorization", authorizationHeader);
            }
            catch (Exception e) {
                if (retries-- > 0) {
                    LOGGER.warn("Error while assigning record to dataset. Retries left: {}", (Object)retries);
                    this.waitForSpecificTime();
                    continue;
                }
                LOGGER.error("Error while assigning record to dataset.");
                throw e;
            }
            break;
        }
    }

    private List<String> readDataSetsList(String listParameter) {
        if (listParameter == null) {
            return null;
        }
        return Arrays.asList(listParameter.split(","));
    }

    private Representation parseResultUrl(String url) throws MalformedURLException {
        UrlParser parser = new UrlParser(url);
        if (parser.isUrlToRepresentationVersionFile()) {
            Representation rep = new Representation();
            rep.setCloudId(parser.getPart(UrlPart.RECORDS));
            rep.setRepresentationName(parser.getPart(UrlPart.REPRESENTATIONS));
            rep.setVersion(parser.getPart(UrlPart.VERSIONS));
            return rep;
        }
        throw new MalformedURLException("The resulted output URL is not formulated correctly");
    }

    private DataSet parseDataSetURl(String url) throws MalformedURLException {
        UrlParser parser = new UrlParser(url);
        if (parser.isUrlToDataset()) {
            DataSet dataSet = new DataSet();
            dataSet.setId(parser.getPart(UrlPart.DATA_SETS));
            dataSet.setProviderId(parser.getPart(UrlPart.DATA_PROVIDERS));
            return dataSet;
        }
        throw new MalformedURLException("The dataSet URL is not formulated correctly");
    }
}

