/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CallContext {
    final long contextAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    final Type returnType;
    final Type[] parameterTypes;
    final long[] parameterTypeHandles;
    final int flags;
    private final Foreign foreign = Foreign.getInstance();

    public static CallContext getCallContext(Type returnType2, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        return CallContextCache.getInstance().getCallContext(returnType2, parameterTypes, convention, saveErrno);
    }

    public static CallContext getCallContext(Type returnType2, Type[] parameterTypes, CallingConvention convention, boolean saveErrno, boolean faultProtect) {
        return CallContextCache.getInstance().getCallContext(returnType2, parameterTypes, convention, saveErrno, faultProtect);
    }

    public CallContext(Type returnType2, Type ... parameterTypes) {
        this(returnType2, parameterTypes, CallingConvention.DEFAULT, true);
    }

    public CallContext(Type returnType2, Type[] parameterTypes, CallingConvention convention) {
        this(returnType2, parameterTypes, convention, true);
    }

    public CallContext(Type returnType2, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        this(returnType2, parameterTypes, convention, saveErrno, false);
    }

    CallContext(Type returnType2, Type[] parameterTypes, CallingConvention convention, boolean saveErrno, boolean faultProtect) {
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0) | (faultProtect ? 4 : 0);
        long h = this.foreign.newCallContext(returnType2.handle(), Type.nativeHandles(parameterTypes), flags);
        if (h == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h;
        this.returnType = returnType2;
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.parameterCount = parameterTypes.length;
        this.rawParameterSize = this.foreign.getCallContextRawParameterSize(h);
        this.parameterTypeHandles = Type.nativeHandles(parameterTypes);
        this.flags = flags;
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getAddress() {
        return this.contextAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index) {
        return this.parameterTypes[index];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallContext that = (CallContext)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.parameterCount != that.parameterCount) {
            return false;
        }
        if (this.rawParameterSize != that.rawParameterSize) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, that.parameterTypes)) {
            return false;
        }
        return this.returnType.equals(that.returnType);
    }

    public int hashCode() {
        int result2 = this.parameterCount;
        result2 = 31 * result2 + this.returnType.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.parameterTypes);
        result2 = 31 * result2 + this.flags;
        return result2;
    }

    @Deprecated
    public final void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L) {
                this.foreign.freeCallContext(this.contextAddress);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "exception when freeing " + this.getClass() + ": %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

