/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.NewInstance;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;

public final class XMLReaderFactory {
    private static final String property = "org.xml.sax.driver";

    private XMLReaderFactory() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        String string2 = null;
        ClassLoader classLoader = NewInstance.getClassLoader();
        try {
            string2 = System.getProperty(property);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                String string3 = "META-INF/services/org.xml.sax.driver";
                InputStream inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
                    string2 = bufferedReader.readLine();
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null) {
            // empty if block
        }
        if (string2 != null) {
            return XMLReaderFactory.loadClass(classLoader, string2);
        }
        try {
            return new ParserAdapter(ParserFactory.makeParser());
        }
        catch (Exception exception) {
            throw new SAXException("Can't create default XMLReader; is system property org.xml.sax.driver set?");
        }
    }

    public static XMLReader createXMLReader(String string2) throws SAXException {
        return XMLReaderFactory.loadClass(NewInstance.getClassLoader(), string2);
    }

    private static XMLReader loadClass(ClassLoader classLoader, String string2) throws SAXException {
        try {
            return (XMLReader)NewInstance.newInstance(classLoader, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("SAX2 driver class " + string2 + " not found", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX2 driver class " + string2 + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX2 driver class " + string2 + " loaded but cannot be instantiated (no empty public constructor?)", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX2 driver class " + string2 + " does not implement XMLReader", classCastException);
        }
    }
}

