/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.accept;

import java.util.Map;
import javax.servlet.ServletContext;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletPathExtensionContentNegotiationStrategy
extends PathExtensionContentNegotiationStrategy {
    private final ServletContext servletContext;

    public ServletPathExtensionContentNegotiationStrategy(ServletContext servletContext, Map<String, MediaType> mediaTypes) {
        super(mediaTypes);
        Assert.notNull(servletContext, "ServletContext is required!");
        this.servletContext = servletContext;
    }

    public ServletPathExtensionContentNegotiationStrategy(ServletContext servletContext) {
        this(servletContext, null);
    }

    @Override
    protected MediaType handleNoMatch(NativeWebRequest webRequest, String extension2) {
        MediaType superMediaType;
        String mimeType;
        MediaType mediaType = null;
        if (this.servletContext != null && StringUtils.hasText(mimeType = this.servletContext.getMimeType("file." + extension2))) {
            mediaType = MediaType.parseMediaType(mimeType);
        }
        if ((mediaType == null || MediaType.APPLICATION_OCTET_STREAM.equals(mediaType)) && (superMediaType = super.handleNoMatch(webRequest, extension2)) != null) {
            mediaType = superMediaType;
        }
        return mediaType;
    }
}

