/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.authority.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAttributes2GrantedAuthoritiesMapper
implements Attributes2GrantedAuthoritiesMapper,
InitializingBean {
    private String attributePrefix = "ROLE_";
    private boolean convertAttributeToUpperCase = false;
    private boolean convertAttributeToLowerCase = false;
    private boolean addPrefixIfAlreadyExisting = false;

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.isTrue(!this.isConvertAttributeToUpperCase() || !this.isConvertAttributeToLowerCase(), "Either convertAttributeToUpperCase or convertAttributeToLowerCase can be set to true, but not both");
    }

    public List<GrantedAuthority> getGrantedAuthorities(Collection<String> attributes) {
        ArrayList<GrantedAuthority> result2 = new ArrayList<GrantedAuthority>(attributes.size());
        for (String attribute : attributes) {
            result2.add(this.getGrantedAuthority(attribute));
        }
        return result2;
    }

    private GrantedAuthority getGrantedAuthority(String attribute) {
        if (this.isConvertAttributeToLowerCase()) {
            attribute = attribute.toLowerCase(Locale.getDefault());
        } else if (this.isConvertAttributeToUpperCase()) {
            attribute = attribute.toUpperCase(Locale.getDefault());
        }
        if (this.isAddPrefixIfAlreadyExisting() || !attribute.startsWith(this.getAttributePrefix())) {
            return new SimpleGrantedAuthority(this.getAttributePrefix() + attribute);
        }
        return new SimpleGrantedAuthority(attribute);
    }

    private boolean isConvertAttributeToLowerCase() {
        return this.convertAttributeToLowerCase;
    }

    public void setConvertAttributeToLowerCase(boolean b) {
        this.convertAttributeToLowerCase = b;
    }

    private boolean isConvertAttributeToUpperCase() {
        return this.convertAttributeToUpperCase;
    }

    public void setConvertAttributeToUpperCase(boolean b) {
        this.convertAttributeToUpperCase = b;
    }

    private String getAttributePrefix() {
        return this.attributePrefix == null ? "" : this.attributePrefix;
    }

    public void setAttributePrefix(String string2) {
        this.attributePrefix = string2;
    }

    private boolean isAddPrefixIfAlreadyExisting() {
        return this.addPrefixIfAlreadyExisting;
    }

    public void setAddPrefixIfAlreadyExisting(boolean b) {
        this.addPrefixIfAlreadyExisting = b;
    }
}

