/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityContextConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SecurityContextConfigurer<H>, H> {
    public SecurityContextConfigurer<H> securityContextRepository(SecurityContextRepository securityContextRepository) {
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(SecurityContextRepository.class, securityContextRepository);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        SessionCreationPolicy sessionCreationPolicy;
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        SecurityContextPersistenceFilter securityContextFilter = new SecurityContextPersistenceFilter(securityContextRepository);
        SessionManagementConfigurer sessionManagement = http.getConfigurer(SessionManagementConfigurer.class);
        SessionCreationPolicy sessionCreationPolicy2 = sessionCreationPolicy = sessionManagement == null ? null : sessionManagement.getSessionCreationPolicy();
        if (SessionCreationPolicy.ALWAYS == sessionCreationPolicy) {
            securityContextFilter.setForceEagerSessionCreation(true);
        }
        securityContextFilter = this.postProcess(securityContextFilter);
        http.addFilter(securityContextFilter);
    }
}

