/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.assembler.AbstractReflectiveMBeanInfoAssembler;
import org.springframework.jmx.export.assembler.AutodetectCapableMBeanInfoAssembler;
import org.springframework.jmx.export.metadata.InvalidMetadataException;
import org.springframework.jmx.export.metadata.JmxAttributeSource;
import org.springframework.jmx.export.metadata.JmxMetadataUtils;
import org.springframework.jmx.export.metadata.ManagedAttribute;
import org.springframework.jmx.export.metadata.ManagedMetric;
import org.springframework.jmx.export.metadata.ManagedNotification;
import org.springframework.jmx.export.metadata.ManagedOperation;
import org.springframework.jmx.export.metadata.ManagedOperationParameter;
import org.springframework.jmx.export.metadata.ManagedResource;
import org.springframework.jmx.support.MetricType;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataMBeanInfoAssembler
extends AbstractReflectiveMBeanInfoAssembler
implements AutodetectCapableMBeanInfoAssembler,
InitializingBean {
    private JmxAttributeSource attributeSource;

    public MetadataMBeanInfoAssembler() {
    }

    public MetadataMBeanInfoAssembler(JmxAttributeSource attributeSource) {
        Assert.notNull(attributeSource, "JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    public void setAttributeSource(JmxAttributeSource attributeSource) {
        Assert.notNull(attributeSource, "JmxAttributeSource must not be null");
        this.attributeSource = attributeSource;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.attributeSource == null) {
            throw new IllegalArgumentException("Property 'attributeSource' is required");
        }
    }

    @Override
    protected void checkManagedBean(Object managedBean) throws IllegalArgumentException {
        if (AopUtils.isJdkDynamicProxy(managedBean)) {
            throw new IllegalArgumentException("MetadataMBeanInfoAssembler does not support JDK dynamic proxies - export the target beans directly or use CGLIB proxies instead");
        }
    }

    @Override
    public boolean includeBean(Class<?> beanClass, String beanName) {
        return this.attributeSource.getManagedResource(this.getClassToExpose(beanClass)) != null;
    }

    @Override
    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method) || this.hasManagedMetric(method);
    }

    @Override
    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.hasManagedAttribute(method);
    }

    @Override
    protected boolean includeOperation(Method method, String beanKey) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null && this.hasManagedAttribute(method)) {
            return true;
        }
        return this.hasManagedOperation(method);
    }

    private boolean hasManagedAttribute(Method method) {
        return this.attributeSource.getManagedAttribute(method) != null;
    }

    private boolean hasManagedMetric(Method method) {
        return this.attributeSource.getManagedMetric(method) != null;
    }

    private boolean hasManagedOperation(Method method) {
        return this.attributeSource.getManagedOperation(method) != null;
    }

    @Override
    protected String getDescription(Object managedBean, String beanKey) {
        ManagedResource mr = this.attributeSource.getManagedResource(this.getClassToExpose(managedBean));
        return mr != null ? mr.getDescription() : "";
    }

    @Override
    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor, String beanKey) {
        ManagedMetric metric;
        ManagedAttribute setter2;
        Method readMethod = propertyDescriptor.getReadMethod();
        Method writeMethod = propertyDescriptor.getWriteMethod();
        ManagedAttribute getter2 = readMethod != null ? this.attributeSource.getManagedAttribute(readMethod) : null;
        ManagedAttribute managedAttribute = setter2 = writeMethod != null ? this.attributeSource.getManagedAttribute(writeMethod) : null;
        if (getter2 != null && StringUtils.hasText(getter2.getDescription())) {
            return getter2.getDescription();
        }
        if (setter2 != null && StringUtils.hasText(setter2.getDescription())) {
            return setter2.getDescription();
        }
        ManagedMetric managedMetric = metric = readMethod != null ? this.attributeSource.getManagedMetric(readMethod) : null;
        if (metric != null && StringUtils.hasText(metric.getDescription())) {
            return metric.getDescription();
        }
        return propertyDescriptor.getDisplayName();
    }

    @Override
    protected String getOperationDescription(Method method, String beanKey) {
        PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
        if (pd != null) {
            ManagedAttribute ma = this.attributeSource.getManagedAttribute(method);
            if (ma != null && StringUtils.hasText(ma.getDescription())) {
                return ma.getDescription();
            }
            ManagedMetric metric = this.attributeSource.getManagedMetric(method);
            if (metric != null && StringUtils.hasText(metric.getDescription())) {
                return metric.getDescription();
            }
            return method.getName();
        }
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null && StringUtils.hasText(mo.getDescription())) {
            return mo.getDescription();
        }
        return method.getName();
    }

    @Override
    protected MBeanParameterInfo[] getOperationParameters(Method method, String beanKey) {
        Object[] params = this.attributeSource.getManagedOperationParameters(method);
        if (ObjectUtils.isEmpty(params)) {
            return super.getOperationParameters(method, beanKey);
        }
        MBeanParameterInfo[] parameterInfo = new MBeanParameterInfo[params.length];
        Class<?>[] methodParameters = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Object param2 = params[i];
            parameterInfo[i] = new MBeanParameterInfo(((ManagedOperationParameter)param2).getName(), methodParameters[i].getName(), ((ManagedOperationParameter)param2).getDescription());
        }
        return parameterInfo;
    }

    @Override
    protected ModelMBeanNotificationInfo[] getNotificationInfo(Object managedBean, String beanKey) {
        ManagedNotification[] notificationAttributes = this.attributeSource.getManagedNotifications(this.getClassToExpose(managedBean));
        ModelMBeanNotificationInfo[] notificationInfos = new ModelMBeanNotificationInfo[notificationAttributes.length];
        for (int i = 0; i < notificationAttributes.length; ++i) {
            ManagedNotification attribute = notificationAttributes[i];
            notificationInfos[i] = JmxMetadataUtils.convertToModelMBeanNotificationInfo(attribute);
        }
        return notificationInfos;
    }

    @Override
    protected void populateMBeanDescriptor(Descriptor desc, Object managedBean, String beanKey) {
        ManagedResource mr = this.attributeSource.getManagedResource(this.getClassToExpose(managedBean));
        if (mr == null) {
            throw new InvalidMetadataException("No ManagedResource attribute found for class: " + this.getClassToExpose(managedBean));
        }
        this.applyCurrencyTimeLimit(desc, mr.getCurrencyTimeLimit());
        if (mr.isLog()) {
            desc.setField("log", "true");
        }
        if (StringUtils.hasLength(mr.getLogFile())) {
            desc.setField("logFile", mr.getLogFile());
        }
        if (StringUtils.hasLength(mr.getPersistPolicy())) {
            desc.setField("persistPolicy", mr.getPersistPolicy());
        }
        if (mr.getPersistPeriod() >= 0) {
            desc.setField("persistPeriod", Integer.toString(mr.getPersistPeriod()));
        }
        if (StringUtils.hasLength(mr.getPersistName())) {
            desc.setField("persistName", mr.getPersistName());
        }
        if (StringUtils.hasLength(mr.getPersistLocation())) {
            desc.setField("persistLocation", mr.getPersistLocation());
        }
    }

    @Override
    protected void populateAttributeDescriptor(Descriptor desc, Method getter2, Method setter2, String beanKey) {
        if (getter2 != null && this.hasManagedMetric(getter2)) {
            this.populateMetricDescriptor(desc, this.attributeSource.getManagedMetric(getter2));
        } else {
            ManagedAttribute gma = getter2 == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(getter2);
            ManagedAttribute sma = setter2 == null ? ManagedAttribute.EMPTY : this.attributeSource.getManagedAttribute(setter2);
            this.populateAttributeDescriptor(desc, gma, sma);
        }
    }

    private void populateAttributeDescriptor(Descriptor desc, ManagedAttribute gma, ManagedAttribute sma) {
        int persistPeriod;
        this.applyCurrencyTimeLimit(desc, this.resolveIntDescriptor(gma.getCurrencyTimeLimit(), sma.getCurrencyTimeLimit()));
        Object defaultValue = this.resolveObjectDescriptor(gma.getDefaultValue(), sma.getDefaultValue());
        desc.setField("default", defaultValue);
        String persistPolicy = this.resolveStringDescriptor(gma.getPersistPolicy(), sma.getPersistPolicy());
        if (StringUtils.hasLength(persistPolicy)) {
            desc.setField("persistPolicy", persistPolicy);
        }
        if ((persistPeriod = this.resolveIntDescriptor(gma.getPersistPeriod(), sma.getPersistPeriod())) >= 0) {
            desc.setField("persistPeriod", Integer.toString(persistPeriod));
        }
    }

    private void populateMetricDescriptor(Descriptor desc, ManagedMetric metric) {
        this.applyCurrencyTimeLimit(desc, metric.getCurrencyTimeLimit());
        if (StringUtils.hasLength(metric.getPersistPolicy())) {
            desc.setField("persistPolicy", metric.getPersistPolicy());
        }
        if (metric.getPersistPeriod() >= 0) {
            desc.setField("persistPeriod", Integer.toString(metric.getPersistPeriod()));
        }
        if (StringUtils.hasLength(metric.getDisplayName())) {
            desc.setField("displayName", metric.getDisplayName());
        }
        if (StringUtils.hasLength(metric.getUnit())) {
            desc.setField("units", metric.getUnit());
        }
        if (StringUtils.hasLength(metric.getCategory())) {
            desc.setField("metricCategory", metric.getCategory());
        }
        String metricType = metric.getMetricType() == null ? MetricType.GAUGE.toString() : metric.getMetricType().toString();
        desc.setField("metricType", metricType);
    }

    @Override
    protected void populateOperationDescriptor(Descriptor desc, Method method, String beanKey) {
        ManagedOperation mo = this.attributeSource.getManagedOperation(method);
        if (mo != null) {
            this.applyCurrencyTimeLimit(desc, mo.getCurrencyTimeLimit());
        }
    }

    private int resolveIntDescriptor(int getter2, int setter2) {
        return getter2 >= setter2 ? getter2 : setter2;
    }

    private Object resolveObjectDescriptor(Object getter2, Object setter2) {
        return getter2 != null ? getter2 : setter2;
    }

    private String resolveStringDescriptor(String getter2, String setter2) {
        return StringUtils.hasLength(getter2) ? getter2 : setter2;
    }
}

