/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;
import org.springframework.util.ReflectionUtils;

public class WebSphereNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String JDBC_ADAPTER_CONNECTION_NAME = "com.ibm.ws.rsadapter.jdbc.WSJdbcConnection";
    private static final String JDBC_ADAPTER_UTIL_NAME = "com.ibm.ws.rsadapter.jdbc.WSJdbcUtil";
    private Class webSphereConnectionClass;
    private Method webSphereNativeConnectionMethod;

    public WebSphereNativeJdbcExtractor() {
        try {
            this.webSphereConnectionClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_CONNECTION_NAME);
            Class<?> jdbcAdapterUtilClass = this.getClass().getClassLoader().loadClass(JDBC_ADAPTER_UTIL_NAME);
            this.webSphereNativeConnectionMethod = jdbcAdapterUtilClass.getMethod("getNativeConnection", this.webSphereConnectionClass);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize WebSphereNativeJdbcExtractor because WebSphere API classes are not available: " + ex);
        }
    }

    public boolean isNativeConnectionNecessaryForNativeStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativePreparedStatements() {
        return true;
    }

    public boolean isNativeConnectionNecessaryForNativeCallableStatements() {
        return true;
    }

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (this.webSphereConnectionClass.isAssignableFrom(con.getClass())) {
            return (Connection)ReflectionUtils.invokeJdbcMethod(this.webSphereNativeConnectionMethod, null, con);
        }
        return con;
    }
}

