/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;
    private PropertyResolver propertyResolver;
    private final boolean ignoreUnresolvablePlaceholders;

    public ResourceEditor() {
        this((ResourceLoader)new DefaultResourceLoader(), null);
    }

    @Deprecated
    public ResourceEditor(ResourceLoader resourceLoader) {
        this(resourceLoader, null, true);
    }

    @Deprecated
    public ResourceEditor(ResourceLoader resourceLoader, boolean ignoreUnresolvablePlaceholders) {
        this(resourceLoader, null, ignoreUnresolvablePlaceholders);
    }

    public ResourceEditor(ResourceLoader resourceLoader, PropertyResolver propertyResolver) {
        this(resourceLoader, propertyResolver, true);
    }

    public ResourceEditor(ResourceLoader resourceLoader, PropertyResolver propertyResolver, boolean ignoreUnresolvablePlaceholders) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
        this.propertyResolver = propertyResolver;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public void setAsText(String text2) {
        if (StringUtils.hasText(text2)) {
            String locationToUse = this.resolvePath(text2).trim();
            this.setValue(this.resourceLoader.getResource(locationToUse));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String path) {
        if (this.propertyResolver == null) {
            this.propertyResolver = new StandardEnvironment();
        }
        return this.ignoreUnresolvablePlaceholders ? this.propertyResolver.resolvePlaceholders(path) : this.propertyResolver.resolveRequiredPlaceholders(path);
    }

    public String getAsText() {
        Resource value2 = (Resource)this.getValue();
        try {
            return value2 != null ? value2.getURL().toExternalForm() : "";
        }
        catch (IOException ex) {
            return null;
        }
    }
}

