/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;

public class LocalVariablesSorter
extends MethodVisitor {
    protected final int firstLocal;
    private final State state;

    public LocalVariablesSorter(int access, String desc, MethodVisitor mv) {
        super(262144, mv);
        this.state = new State();
        Type[] args = Type.getArgumentTypes(desc);
        this.state.nextLocal = (8 & access) != 0 ? 0 : 1;
        for (int i = 0; i < args.length; ++i) {
            this.state.nextLocal += args[i].getSize();
        }
        this.firstLocal = this.state.nextLocal;
    }

    public LocalVariablesSorter(LocalVariablesSorter lvs) {
        super(262144, lvs.mv);
        this.state = lvs.state;
        this.firstLocal = lvs.firstLocal;
    }

    public void visitVarInsn(int opcode, int var) {
        int size2;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                size2 = 2;
                break;
            }
            default: {
                size2 = 1;
            }
        }
        this.mv.visitVarInsn(opcode, this.remap(var, size2));
    }

    public void visitIincInsn(int var, int increment) {
        this.mv.visitIincInsn(this.remap(var, 1), increment);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack, this.state.nextLocal);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index2) {
        this.mv.visitLocalVariable(name, desc, signature, start, end, this.remap(index2));
    }

    protected int newLocal(int size2) {
        int var = this.state.nextLocal;
        this.state.nextLocal += size2;
        return var;
    }

    private int remap(int var, int size2) {
        int value2;
        if (var < this.firstLocal) {
            return var;
        }
        int key = 2 * var + size2 - 1;
        int length = this.state.mapping.length;
        if (key >= length) {
            int[] newMapping = new int[Math.max(2 * length, key + 1)];
            System.arraycopy(this.state.mapping, 0, newMapping, 0, length);
            this.state.mapping = newMapping;
        }
        if ((value2 = this.state.mapping[key]) == 0) {
            this.state.mapping[key] = value2 = this.state.nextLocal + 1;
            this.state.nextLocal += size2;
        }
        return value2 - 1;
    }

    private int remap(int var) {
        int value2;
        if (var < this.firstLocal) {
            return var;
        }
        int key = 2 * var;
        int n = value2 = key < this.state.mapping.length ? this.state.mapping[key] : 0;
        if (value2 == 0) {
            int n2 = value2 = key + 1 < this.state.mapping.length ? this.state.mapping[key + 1] : 0;
        }
        if (value2 == 0) {
            throw new IllegalStateException("Unknown local variable " + var);
        }
        return value2 - 1;
    }

    private static class State {
        int[] mapping = new int[40];
        int nextLocal;

        private State() {
        }
    }
}

